/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.consent;

import de.adorsys.psd2.consent.api.service.PisCommonPaymentServiceEncrypted;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import java.beans.ConstructorProperties;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PisPsuDataService {
    private static final Logger log = LoggerFactory.getLogger(PisPsuDataService.class);
    private final PisCommonPaymentServiceEncrypted pisCommonPaymentServiceEncrypted;
    private final RequestProviderService requestProviderService;

    public List<PsuIdData> getPsuDataByPaymentId(String paymentId) {
        return this.pisCommonPaymentServiceEncrypted.getPsuDataListByPaymentId(paymentId).orElseGet(() -> {
            log.info("InR-ID: [{}], X-Request-ID [{}], Payment-ID [{}]. Can't get PsuData by payment ID because PsuData list not found by id at cms.", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), paymentId});
            return null;
        });
    }

    @ConstructorProperties(value={"pisCommonPaymentServiceEncrypted", "requestProviderService"})
    public PisPsuDataService(PisCommonPaymentServiceEncrypted pisCommonPaymentServiceEncrypted, RequestProviderService requestProviderService) {
        this.pisCommonPaymentServiceEncrypted = pisCommonPaymentServiceEncrypted;
        this.requestProviderService = requestProviderService;
    }
}

