/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.authorization.ais;

import de.adorsys.psd2.xs2a.core.error.TppMessage;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import de.adorsys.psd2.xs2a.domain.consent.DecoupledUpdateConsentPsuDataResponse;
import de.adorsys.psd2.xs2a.domain.consent.UpdateConsentPsuDataReq;
import de.adorsys.psd2.xs2a.domain.consent.UpdateConsentPsuDataResponse;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aAuthenticationObject;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.context.SpiContextDataProvider;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ServiceType;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiErrorMapper;
import de.adorsys.psd2.xs2a.service.spi.SpiAspspConsentDataProviderFactory;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountConsent;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiAuthorisationDecoupledScaResponse;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.AisConsentSpi;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CommonDecoupledAisService {
    private static final Logger log = LoggerFactory.getLogger(CommonDecoupledAisService.class);
    private final AisConsentSpi aisConsentSpi;
    private final RequestProviderService requestProviderService;
    private final SpiErrorMapper spiErrorMapper;
    private final SpiAspspConsentDataProviderFactory aspspConsentDataProviderFactory;
    private final SpiContextDataProvider spiContextDataProvider;

    public UpdateConsentPsuDataResponse proceedDecoupledApproach(UpdateConsentPsuDataReq request, SpiAccountConsent spiAccountConsent, PsuIdData psuData) {
        return this.proceedDecoupledApproach(request, spiAccountConsent, null, psuData);
    }

    public UpdateConsentPsuDataResponse proceedDecoupledApproach(UpdateConsentPsuDataReq request, SpiAccountConsent spiAccountConsent, String authenticationMethodId, PsuIdData psuData) {
        String consentId = request.getConsentId();
        String authorisationId = request.getAuthorizationId();
        SpiResponse spiResponse = this.aisConsentSpi.startScaDecoupled(this.spiContextDataProvider.provideWithPsuIdData(psuData), authorisationId, authenticationMethodId, (Object)spiAccountConsent, this.aspspConsentDataProviderFactory.getSpiAspspDataProviderFor(consentId));
        if (spiResponse.hasError()) {
            MessageError messageError = new MessageError(this.spiErrorMapper.mapToErrorHolder(spiResponse, ServiceType.AIS));
            log.info("InR-ID: [{}], X-Request-ID: [{}], Consent-ID [{}], Authorisation-ID [{}], PSU-ID [{}], Authentication-Method-ID [{}]. Notifies a decoupled app about starting SCA when proceed decoupled approach has failed. Error msg: {}.", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), request.getConsentId(), request.getAuthorizationId(), psuData.getPsuId(), authenticationMethodId, messageError});
            return this.createFailedResponse(messageError, spiResponse.getErrors(), request);
        }
        DecoupledUpdateConsentPsuDataResponse response = new DecoupledUpdateConsentPsuDataResponse(ScaStatus.SCAMETHODSELECTED, consentId, authorisationId);
        response.setPsuMessage(((SpiAuthorisationDecoupledScaResponse)spiResponse.getPayload()).getPsuMessage());
        response.setChosenScaMethod(this.buildXs2aAuthenticationObjectForDecoupledApproach(authenticationMethodId));
        return response;
    }

    private Xs2aAuthenticationObject buildXs2aAuthenticationObjectForDecoupledApproach(String authenticationMethodId) {
        Xs2aAuthenticationObject xs2aAuthenticationObject = new Xs2aAuthenticationObject();
        xs2aAuthenticationObject.setAuthenticationMethodId(authenticationMethodId);
        return xs2aAuthenticationObject;
    }

    private UpdateConsentPsuDataResponse createFailedResponse(MessageError messageError, List<TppMessage> messages, UpdateConsentPsuDataReq updateConsentPsuDataReq) {
        UpdateConsentPsuDataResponse response = new UpdateConsentPsuDataResponse(ScaStatus.FAILED, updateConsentPsuDataReq.getConsentId(), updateConsentPsuDataReq.getAuthorizationId());
        response.setMessageError(messageError);
        response.setPsuMessage(this.buildPsuMessage(messages));
        return response;
    }

    private String buildPsuMessage(List<TppMessage> messages) {
        ArrayList textMessages = new ArrayList();
        messages.forEach(tppMessage -> textMessages.add(tppMessage.getMessageText()));
        return String.join((CharSequence)", ", textMessages);
    }

    @ConstructorProperties(value={"aisConsentSpi", "requestProviderService", "spiErrorMapper", "aspspConsentDataProviderFactory", "spiContextDataProvider"})
    public CommonDecoupledAisService(AisConsentSpi aisConsentSpi, RequestProviderService requestProviderService, SpiErrorMapper spiErrorMapper, SpiAspspConsentDataProviderFactory aspspConsentDataProviderFactory, SpiContextDataProvider spiContextDataProvider) {
        this.aisConsentSpi = aisConsentSpi;
        this.requestProviderService = requestProviderService;
        this.spiErrorMapper = spiErrorMapper;
        this.aspspConsentDataProviderFactory = aspspConsentDataProviderFactory;
        this.spiContextDataProvider = spiContextDataProvider;
    }
}

