/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.component.logger;

import de.adorsys.psd2.xs2a.component.logger.TppLogType;
import de.adorsys.psd2.xs2a.component.logger.TppRequestLogBuilder;
import de.adorsys.psd2.xs2a.component.logger.TppResponseLogBuilder;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TppLogger {
    private static final Logger log = LoggerFactory.getLogger((String)"access-log");

    private TppLogger() {
    }

    public static TppRequestLogBuilder logRequest(HttpServletRequest request) {
        return new TppRequestLogBuilder(request);
    }

    public static TppResponseLogBuilder logResponse(HttpServletResponse response) {
        return new TppResponseLogBuilder(response);
    }

    public static abstract class TppLogBuilder<T extends TppLogBuilder<T>> {
        protected static final String X_REQUEST_ID = "X-Request-ID";
        private static final String INTERNAL_REQUEST_ID = "InR-ID";
        private Map<String, String> logParams = new LinkedHashMap<String, String>();
        private TppLogType tppLogType;

        TppLogBuilder(TppLogType tppLogType) {
            this.tppLogType = tppLogType;
        }

        public T withInternalRequestId(@NotNull UUID internalRequestId) {
            this.putLogParameter(INTERNAL_REQUEST_ID, internalRequestId.toString());
            return this.getThis();
        }

        public T withXRequestId() {
            this.putLogParameter(X_REQUEST_ID, this.getXRequestIdValue());
            return this.getThis();
        }

        public T withParam(String paramName, String paramValue) {
            this.putLogParameter(paramName, paramValue);
            return this.getThis();
        }

        public void perform() {
            String logMessageParams = this.logParams.entrySet().stream().map(e -> (String)e.getKey() + ": [" + (String)e.getValue() + "]").collect(Collectors.joining(", "));
            log.info(this.tppLogType.name() + " - " + logMessageParams);
        }

        void putLogParameter(String parameterName, String parameterValue) {
            this.logParams.put(parameterName, parameterValue);
        }

        protected abstract String getXRequestIdValue();

        protected abstract T getThis();
    }
}

