/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.validator.body.payment.type;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.domain.pis.PeriodicPayment;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.web.validator.ErrorBuildingService;
import de.adorsys.psd2.xs2a.web.validator.body.payment.mapper.PaymentMapper;
import de.adorsys.psd2.xs2a.web.validator.body.payment.type.SinglePaymentTypeValidatorImpl;
import java.time.LocalDate;
import java.util.Objects;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PeriodicPaymentTypeValidatorImpl
extends SinglePaymentTypeValidatorImpl {
    @Autowired
    public PeriodicPaymentTypeValidatorImpl(ErrorBuildingService errorBuildingService, ObjectMapper objectMapper, PaymentMapper paymentMapper) {
        super(errorBuildingService, objectMapper, paymentMapper);
    }

    @Override
    public PaymentType getPaymentType() {
        return PaymentType.PERIODIC;
    }

    @Override
    public void validate(Object body, MessageError messageError) {
        try {
            this.doPeriodicValidation(this.paymentMapper.getPeriodicPayment(body), messageError);
        }
        catch (IllegalArgumentException e) {
            this.errorBuildingService.enrichMessageError(messageError, e.getMessage());
        }
    }

    void doPeriodicValidation(PeriodicPayment periodicPayment, MessageError messageError) {
        super.doSingleValidation(periodicPayment, messageError);
        if (Objects.isNull(periodicPayment.getStartDate())) {
            this.errorBuildingService.enrichMessageError(messageError, "Value 'startDate' should not be null");
        } else {
            this.validateStartDate(periodicPayment.getStartDate(), messageError);
        }
        if (Objects.nonNull(periodicPayment.getExecutionRule())) {
            this.checkRequiredFieldForMaxLength(periodicPayment.getExecutionRule().getValue(), "executionRule", 140, messageError);
        }
        if (Objects.isNull(periodicPayment.getFrequency())) {
            this.errorBuildingService.enrichMessageError(messageError, "Value 'frequency' should not be null");
        }
        if (this.areDatesInvalidInPeriodicPayment(periodicPayment)) {
            this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of(MessageErrorCode.PERIOD_INVALID, "Date values has wrong order"));
        }
        this.validateUltimateDebtor(periodicPayment.getUltimateDebtor(), messageError);
        this.validateUltimateCreditor(periodicPayment.getUltimateCreditor(), messageError);
        this.validateRemittanceInformationStructured(periodicPayment.getRemittanceInformationStructured(), messageError);
    }

    private void validateStartDate(LocalDate startDate, MessageError messageError) {
        if (startDate.isBefore(LocalDate.now())) {
            this.errorBuildingService.enrichMessageError(messageError, "Value 'startDate' should not be in the past");
        }
    }

    private boolean areDatesInvalidInPeriodicPayment(PeriodicPayment periodicPayment) {
        LocalDate paymentStartDate = periodicPayment.getStartDate();
        if (paymentStartDate == null || paymentStartDate.isBefore(LocalDate.now())) {
            return false;
        }
        LocalDate paymentEndDate = periodicPayment.getEndDate();
        return this.isDateInThePast(paymentStartDate) || Optional.ofNullable(paymentEndDate).map(dt -> dt.isBefore(paymentStartDate)).orElse(false) != false;
    }
}

