/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.validator.body;

import com.fasterxml.jackson.core.type.TypeReference;
import de.adorsys.psd2.xs2a.component.JsonConverter;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.web.converter.LocalDateConverter;
import de.adorsys.psd2.xs2a.web.validator.ErrorBuildingService;
import de.adorsys.psd2.xs2a.web.validator.constants.Xs2aBodyDateFormatter;
import de.adorsys.psd2.xs2a.web.validator.constants.Xs2aRequestBodyDateField;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.InputStream;
import java.time.format.DateTimeParseException;
import java.util.EnumSet;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class DateFieldValidator {
    private static final String DAY_OF_EXECUTION_FIELD_NAME = "dayOfExecution";
    private static final String DAY_OF_MONTH_REGEX = "(0?[1-9]|[12]\\d|3[01])";
    private static final String DAY_OF_EXECUTION_WRONG_VALUE_ERROR = "Value 'dayOfExecution' should be a number of day in month";
    private static final String ERROR_TEXT_ISO_DATE_FORMAT = "Wrong format for '%s': value should be %s '%s' format.";
    private static final String BODY_DESERIALIZATION_ERROR = "Cannot deserialize the request body";
    private final ErrorBuildingService errorBuildingService;
    private final JsonConverter jsonConverter;
    private final LocalDateConverter localDateConverter;

    public void validateDateFormat(HttpServletRequest request, EnumSet<Xs2aRequestBodyDateField> fields, MessageError messageError) {
        this.validateRawDataDates(request, fields, messageError);
    }

    public void validateDayOfExecution(HttpServletRequest request, MessageError messageError) {
        this.extractField(request, DAY_OF_EXECUTION_FIELD_NAME, messageError).ifPresent(day -> this.validateDayOfExecutionValue((String)day, messageError));
    }

    private void validateRawDataDates(HttpServletRequest request, EnumSet<Xs2aRequestBodyDateField> fields, MessageError messageError) {
        for (Xs2aRequestBodyDateField field : fields) {
            this.extractField(request, field.getFieldName(), messageError).ifPresent(date -> this.convert(field.getFieldName(), (String)date, field.getFormatter(), messageError));
        }
    }

    private void convert(String key, String value, Xs2aBodyDateFormatter formatter, MessageError messageError) {
        try {
            this.localDateConverter.convert(value, formatter.getFormatter());
        }
        catch (DateTimeParseException ex) {
            this.errorBuildingService.enrichMessageError(messageError, String.format(ERROR_TEXT_ISO_DATE_FORMAT, key, formatter.name(), formatter.getPattern()));
        }
    }

    private Optional<String> extractField(HttpServletRequest request, String fieldName, MessageError messageError) {
        Optional<String> fieldOptional = Optional.empty();
        try {
            fieldOptional = this.jsonConverter.toJsonField((InputStream)request.getInputStream(), fieldName, new TypeReference<String>(){});
        }
        catch (IOException e) {
            this.errorBuildingService.enrichMessageError(messageError, BODY_DESERIALIZATION_ERROR);
        }
        return fieldOptional;
    }

    private void validateDayOfExecutionValue(String value, MessageError messageError) {
        if (!this.isNumberADayOfMonth(value)) {
            this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of(MessageErrorCode.FORMAT_ERROR, DAY_OF_EXECUTION_WRONG_VALUE_ERROR));
        }
    }

    private boolean isNumberADayOfMonth(@NotNull String value) {
        return value.matches(DAY_OF_MONTH_REGEX);
    }

    @ConstructorProperties(value={"errorBuildingService", "jsonConverter", "localDateConverter"})
    public DateFieldValidator(ErrorBuildingService errorBuildingService, JsonConverter jsonConverter, LocalDateConverter localDateConverter) {
        this.errorBuildingService = errorBuildingService;
        this.jsonConverter = jsonConverter;
        this.localDateConverter = localDateConverter;
    }
}

