/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.interceptor.logging;

import de.adorsys.psd2.xs2a.component.logger.request.RequestResponseLogMessage;
import de.adorsys.psd2.xs2a.component.logger.request.RequestResponseLogger;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import java.beans.ConstructorProperties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class RequestResponseLoggingInterceptor
extends HandlerInterceptorAdapter {
    private final RequestResponseLogger requestResponseLogger;
    private final RequestProviderService requestProviderService;

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        RequestResponseLogMessage message = RequestResponseLogMessage.builder(request, response).withInternalRequestId(this.requestProviderService.getInternalRequestId()).withRequestUri().withRequestHeaders().withRequestPayload().withResponseStatus().withResponseHeaders().withResponseBody().build();
        this.requestResponseLogger.logMessage(message);
    }

    @ConstructorProperties(value={"requestResponseLogger", "requestProviderService"})
    public RequestResponseLoggingInterceptor(RequestResponseLogger requestResponseLogger, RequestProviderService requestProviderService) {
        this.requestResponseLogger = requestResponseLogger;
        this.requestProviderService = requestProviderService;
    }
}

