/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web;

import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import java.beans.ConstructorProperties;
import org.springframework.stereotype.Component;

@Component
public class RedirectLinkBuilder {
    private static final String REDIRECT_URL = "{redirect-id}";
    private static final String ENCRYPTED_CONSENT_ID = "{encrypted-consent-id}";
    private static final String ENCRYPTED_PAYMENT_ID = "{encrypted-payment-id}";
    private final AspspProfileServiceWrapper aspspProfileService;

    public String buildConsentScaRedirectLink(String encryptedConsentId, String redirectId) {
        return this.aspspProfileService.getAisRedirectUrlToAspsp().replace(REDIRECT_URL, redirectId).replace(ENCRYPTED_CONSENT_ID, encryptedConsentId);
    }

    public String buildPaymentScaRedirectLink(String encryptedPaymentId, String redirectId) {
        return this.aspspProfileService.getPisRedirectUrlToAspsp().replace(REDIRECT_URL, redirectId).replace(ENCRYPTED_PAYMENT_ID, encryptedPaymentId);
    }

    public String buildPaymentCancellationScaRedirectLink(String encryptedPaymentId, String redirectId) {
        return this.aspspProfileService.getPisPaymentCancellationRedirectUrlToAspsp().replace(REDIRECT_URL, redirectId).replace(ENCRYPTED_PAYMENT_ID, encryptedPaymentId);
    }

    @ConstructorProperties(value={"aspspProfileService"})
    public RedirectLinkBuilder(AspspProfileServiceWrapper aspspProfileService) {
        this.aspspProfileService = aspspProfileService;
    }
}

