/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator.ais.account;

import de.adorsys.psd2.xs2a.core.ais.BookingStatus;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.domain.consent.AccountConsent;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ErrorType;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.service.validator.ais.AbstractAisTppValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.account.common.AccountConsentValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.account.common.AccountReferenceAccessValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.account.common.PermittedAccountReferenceValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.account.common.TransactionReportAcceptHeaderValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.account.dto.TransactionsReportByPeriodObject;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class GetTransactionsReportValidator
extends AbstractAisTppValidator<TransactionsReportByPeriodObject> {
    private static final String ENTRY_REFERENCE_FROM_NOT_SUPPORTED_ERROR_TEXT = "Parameter 'entryReferenceFrom' is not supported by ASPSP";
    private static final String DELTA_LIST_NOT_SUPPORTED_ERROR_TEXT = "Parameter 'deltaList' is not supported by ASPSP";
    private static final String ONE_DELTA_REPORT_CAN_BE_PRESENT_ERROR_TEXT = "Only one delta report query parameter can be present in request";
    private static final String BOOKING_STATUS_NOT_SUPPORTED_ERROR_TEXT = "bookingStatus '%s' is not supported by ASPSP";
    private final PermittedAccountReferenceValidator permittedAccountReferenceValidator;
    private final AccountConsentValidator accountConsentValidator;
    private final AspspProfileServiceWrapper aspspProfileService;
    private final TransactionReportAcceptHeaderValidator transactionReportAcceptHeaderValidator;
    private final AccountReferenceAccessValidator accountReferenceAccessValidator;

    @Override
    @NotNull
    protected ValidationResult executeBusinessValidation(TransactionsReportByPeriodObject requestObject) {
        ValidationResult acceptHeaderValidationResult = this.transactionReportAcceptHeaderValidator.validate(requestObject.getAcceptHeader());
        if (acceptHeaderValidationResult.isNotValid()) {
            return acceptHeaderValidationResult;
        }
        ValidationResult validationResult = this.validateTransactionReportParameters(requestObject.getEntryReferenceFrom(), requestObject.getDeltaList());
        if (validationResult.isNotValid()) {
            return validationResult;
        }
        AccountConsent accountConsent = requestObject.getAccountConsent();
        ValidationResult accountReferenceValidationResult = this.accountReferenceAccessValidator.validate(accountConsent.getAccess(), requestObject.getTransactions(), requestObject.getAccountId());
        if (accountReferenceValidationResult.isNotValid()) {
            return accountReferenceValidationResult;
        }
        ValidationResult permittedAccountReferenceValidationResult = this.permittedAccountReferenceValidator.validate(accountConsent, requestObject.getAccountId(), requestObject.isWithBalance());
        if (permittedAccountReferenceValidationResult.isNotValid()) {
            return permittedAccountReferenceValidationResult;
        }
        BookingStatus bookingStatus = requestObject.getBookingStatus();
        if (this.isNotSupportedBookingStatus(bookingStatus)) {
            return ValidationResult.invalid(ErrorType.AIS_400, TppMessageInformation.of(MessageErrorCode.PARAMETER_NOT_SUPPORTED, String.format(BOOKING_STATUS_NOT_SUPPORTED_ERROR_TEXT, bookingStatus.getValue())));
        }
        return this.accountConsentValidator.validate(accountConsent, requestObject.getRequestUri());
    }

    private ValidationResult validateTransactionReportParameters(String entryReferenceFrom, Boolean deltaList) {
        boolean isAllParametersPresentAndSupported;
        ArrayList<TppMessageInformation> tppMessageInformationList = new ArrayList<TppMessageInformation>();
        boolean isEntryReferenceFromSupported = this.aspspProfileService.isEntryReferenceFromSupported();
        boolean isEntryReferenceFromPresentInRequest = StringUtils.isNotBlank((CharSequence)entryReferenceFrom);
        if (isEntryReferenceFromPresentInRequest && !isEntryReferenceFromSupported) {
            tppMessageInformationList.add(TppMessageInformation.of(MessageErrorCode.PARAMETER_NOT_SUPPORTED, ENTRY_REFERENCE_FROM_NOT_SUPPORTED_ERROR_TEXT));
        }
        boolean isDeltaListSupported = this.aspspProfileService.isDeltaListSupported();
        boolean isDeltaListPresentInRequest = BooleanUtils.isTrue((Boolean)deltaList);
        if (isDeltaListPresentInRequest && !isDeltaListSupported) {
            tppMessageInformationList.add(TppMessageInformation.of(MessageErrorCode.PARAMETER_NOT_SUPPORTED, DELTA_LIST_NOT_SUPPORTED_ERROR_TEXT));
        }
        boolean bl = isAllParametersPresentAndSupported = isDeltaListSupported && isEntryReferenceFromSupported && isEntryReferenceFromPresentInRequest && isDeltaListPresentInRequest;
        if (isAllParametersPresentAndSupported) {
            tppMessageInformationList.add(TppMessageInformation.of(MessageErrorCode.FORMAT_ERROR, ONE_DELTA_REPORT_CAN_BE_PRESENT_ERROR_TEXT));
        }
        return tppMessageInformationList.isEmpty() ? ValidationResult.valid() : ValidationResult.invalid(ErrorType.AIS_400, tppMessageInformationList.toArray(new TppMessageInformation[0]));
    }

    private boolean isNotSupportedBookingStatus(BookingStatus bookingStatus) {
        return !this.aspspProfileService.getAvailableBookingStatuses().contains(bookingStatus);
    }

    @ConstructorProperties(value={"permittedAccountReferenceValidator", "accountConsentValidator", "aspspProfileService", "transactionReportAcceptHeaderValidator", "accountReferenceAccessValidator"})
    public GetTransactionsReportValidator(PermittedAccountReferenceValidator permittedAccountReferenceValidator, AccountConsentValidator accountConsentValidator, AspspProfileServiceWrapper aspspProfileService, TransactionReportAcceptHeaderValidator transactionReportAcceptHeaderValidator, AccountReferenceAccessValidator accountReferenceAccessValidator) {
        this.permittedAccountReferenceValidator = permittedAccountReferenceValidator;
        this.accountConsentValidator = accountConsentValidator;
        this.aspspProfileService = aspspProfileService;
        this.transactionReportAcceptHeaderValidator = transactionReportAcceptHeaderValidator;
        this.accountReferenceAccessValidator = accountReferenceAccessValidator;
    }
}

