/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator;

import de.adorsys.psd2.consent.api.service.PisCommonPaymentServiceEncrypted;
import de.adorsys.psd2.xs2a.domain.pis.PaymentAuthorisationType;
import de.adorsys.psd2.xs2a.service.validator.EndpointAccessChecker;
import java.beans.ConstructorProperties;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class PisEndpointAccessCheckerService
extends EndpointAccessChecker {
    private final PisCommonPaymentServiceEncrypted pisCommonPaymentServiceEncrypted;

    public boolean isEndpointAccessible(String authorisationId, PaymentAuthorisationType authorisationType) {
        Optional authorisationResponse = Optional.empty();
        if (authorisationType == PaymentAuthorisationType.INITIATION) {
            authorisationResponse = this.pisCommonPaymentServiceEncrypted.getPisAuthorisationById(authorisationId);
        } else if (authorisationType == PaymentAuthorisationType.CANCELLATION) {
            authorisationResponse = this.pisCommonPaymentServiceEncrypted.getPisCancellationAuthorisationById(authorisationId);
        }
        return authorisationResponse.map(p -> this.isAccessible(p.getChosenScaApproach(), p.getScaStatus())).orElse(true);
    }

    @ConstructorProperties(value={"pisCommonPaymentServiceEncrypted"})
    public PisEndpointAccessCheckerService(PisCommonPaymentServiceEncrypted pisCommonPaymentServiceEncrypted) {
        this.pisCommonPaymentServiceEncrypted = pisCommonPaymentServiceEncrypted;
    }
}

