/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.payment.sca;

import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.tpp.TppInfo;
import de.adorsys.psd2.xs2a.domain.ErrorHolder;
import de.adorsys.psd2.xs2a.domain.pis.BulkPayment;
import de.adorsys.psd2.xs2a.domain.pis.BulkPaymentInitiationResponse;
import de.adorsys.psd2.xs2a.domain.pis.CommonPayment;
import de.adorsys.psd2.xs2a.domain.pis.CommonPaymentInitiationResponse;
import de.adorsys.psd2.xs2a.domain.pis.PeriodicPayment;
import de.adorsys.psd2.xs2a.domain.pis.PeriodicPaymentInitiationResponse;
import de.adorsys.psd2.xs2a.domain.pis.SinglePayment;
import de.adorsys.psd2.xs2a.domain.pis.SinglePaymentInitiationResponse;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.authorization.ScaApproachServiceTypeProvider;
import de.adorsys.psd2.xs2a.service.context.SpiContextDataProvider;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ServiceType;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiErrorMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aPaymentMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.Xs2aToSpiBulkPaymentMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.Xs2aToSpiPaymentInfo;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.Xs2aToSpiPeriodicPaymentMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.Xs2aToSpiSinglePaymentMapper;
import de.adorsys.psd2.xs2a.service.spi.InitialSpiAspspConsentDataProvider;
import de.adorsys.psd2.xs2a.service.spi.SpiAspspConsentDataProviderFactory;
import de.adorsys.psd2.xs2a.spi.domain.SpiAspspConsentDataProvider;
import de.adorsys.psd2.xs2a.spi.domain.SpiContextData;
import de.adorsys.psd2.xs2a.spi.domain.payment.response.SpiBulkPaymentInitiationResponse;
import de.adorsys.psd2.xs2a.spi.domain.payment.response.SpiPaymentInitiationResponse;
import de.adorsys.psd2.xs2a.spi.domain.payment.response.SpiPeriodicPaymentInitiationResponse;
import de.adorsys.psd2.xs2a.spi.domain.payment.response.SpiSinglePaymentInitiationResponse;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.BulkPaymentSpi;
import de.adorsys.psd2.xs2a.spi.service.CommonPaymentSpi;
import de.adorsys.psd2.xs2a.spi.service.PeriodicPaymentSpi;
import de.adorsys.psd2.xs2a.spi.service.SinglePaymentSpi;
import java.beans.ConstructorProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public abstract class ScaPaymentService
implements ScaApproachServiceTypeProvider {
    private static final Logger log = LoggerFactory.getLogger(ScaPaymentService.class);
    private final SinglePaymentSpi singlePaymentSpi;
    private final PeriodicPaymentSpi periodicPaymentSpi;
    private final BulkPaymentSpi bulkPaymentSpi;
    private final CommonPaymentSpi commonPaymentSpi;
    private final Xs2aToSpiSinglePaymentMapper xs2AToSpiSinglePaymentMapper;
    private final Xs2aToSpiPeriodicPaymentMapper xs2aToSpiPeriodicPaymentMapper;
    private final Xs2aToSpiBulkPaymentMapper xs2aToSpiBulkPaymentMapper;
    private final Xs2aToSpiPaymentInfo xs2aToSpiPaymentInfo;
    private final SpiToXs2aPaymentMapper spiToXs2aPaymentMapper;
    private final SpiContextDataProvider spiContextDataProvider;
    private final SpiErrorMapper spiErrorMapper;
    private final SpiAspspConsentDataProviderFactory aspspConsentDataProviderFactory;
    private final RequestProviderService requestProviderService;

    public SinglePaymentInitiationResponse createSinglePayment(SinglePayment payment, TppInfo tppInfo, String paymentProduct, PsuIdData psuIdData) {
        SpiContextData spiContextData = this.spiContextDataProvider.provideWithPsuIdData(psuIdData);
        InitialSpiAspspConsentDataProvider aspspConsentDataProvider = this.aspspConsentDataProviderFactory.getInitialAspspConsentDataProvider();
        SpiResponse spiResponse = this.singlePaymentSpi.initiatePayment(spiContextData, this.xs2AToSpiSinglePaymentMapper.mapToSpiSinglePayment(payment, paymentProduct), (SpiAspspConsentDataProvider)aspspConsentDataProvider);
        if (spiResponse.hasError()) {
            ErrorHolder errorHolder = this.spiErrorMapper.mapToErrorHolder(spiResponse, ServiceType.PIS);
            log.info("InR-ID: [{}], X-Request-ID: [{}], Payment-ID [{}]. CREATE SINGLE Payment failed. Can't initiate Payment at SPI-level. Error msg: {}.", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), payment.getPaymentId(), errorHolder});
            return new SinglePaymentInitiationResponse(errorHolder);
        }
        return this.spiToXs2aPaymentMapper.mapToPaymentInitiateResponse((SpiSinglePaymentInitiationResponse)spiResponse.getPayload(), aspspConsentDataProvider);
    }

    public PeriodicPaymentInitiationResponse createPeriodicPayment(PeriodicPayment payment, TppInfo tppInfo, String paymentProduct, PsuIdData psuIdData) {
        SpiContextData spiContextData = this.spiContextDataProvider.provideWithPsuIdData(psuIdData);
        InitialSpiAspspConsentDataProvider aspspConsentDataProvider = this.aspspConsentDataProviderFactory.getInitialAspspConsentDataProvider();
        SpiResponse spiResponse = this.periodicPaymentSpi.initiatePayment(spiContextData, this.xs2aToSpiPeriodicPaymentMapper.mapToSpiPeriodicPayment(payment, paymentProduct), (SpiAspspConsentDataProvider)aspspConsentDataProvider);
        if (spiResponse.hasError()) {
            ErrorHolder errorHolder = this.spiErrorMapper.mapToErrorHolder(spiResponse, ServiceType.PIS);
            log.info("InR-ID: [{}], X-Request-ID: [{}], Payment-ID [{}]. CREATE PERIODIC Payment failed. Can't initiate Payment at SPI-level. Error msg: {}.", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), payment.getPaymentId(), errorHolder});
            return new PeriodicPaymentInitiationResponse(errorHolder);
        }
        return this.spiToXs2aPaymentMapper.mapToPaymentInitiateResponse((SpiPeriodicPaymentInitiationResponse)spiResponse.getPayload(), aspspConsentDataProvider);
    }

    public BulkPaymentInitiationResponse createBulkPayment(BulkPayment bulkPayment, TppInfo tppInfo, String paymentProduct, PsuIdData psuIdData) {
        SpiContextData spiContextData = this.spiContextDataProvider.provideWithPsuIdData(psuIdData);
        InitialSpiAspspConsentDataProvider aspspConsentDataProvider = this.aspspConsentDataProviderFactory.getInitialAspspConsentDataProvider();
        SpiResponse spiResponse = this.bulkPaymentSpi.initiatePayment(spiContextData, this.xs2aToSpiBulkPaymentMapper.mapToSpiBulkPayment(bulkPayment, paymentProduct), (SpiAspspConsentDataProvider)aspspConsentDataProvider);
        if (spiResponse.hasError()) {
            ErrorHolder errorHolder = this.spiErrorMapper.mapToErrorHolder(spiResponse, ServiceType.PIS);
            log.info("InR-ID: [{}], X-Request-ID: [{}], Payment-ID [{}]. CREATE BULK Payment failed. Can't initiate Payment at SPI-level. Error msg: {}.", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), bulkPayment.getPaymentId(), errorHolder});
            return new BulkPaymentInitiationResponse(errorHolder);
        }
        return this.spiToXs2aPaymentMapper.mapToPaymentInitiateResponse((SpiBulkPaymentInitiationResponse)spiResponse.getPayload(), aspspConsentDataProvider);
    }

    public CommonPaymentInitiationResponse createCommonPayment(CommonPayment payment, TppInfo tppInfo, String paymentProduct, PsuIdData psuIdData) {
        SpiContextData spiContextData = this.spiContextDataProvider.provide(psuIdData, tppInfo);
        InitialSpiAspspConsentDataProvider aspspConsentDataProvider = this.aspspConsentDataProviderFactory.getInitialAspspConsentDataProvider();
        SpiResponse spiResponse = this.commonPaymentSpi.initiatePayment(spiContextData, this.xs2aToSpiPaymentInfo.mapToSpiPaymentRequest(payment, paymentProduct), (SpiAspspConsentDataProvider)aspspConsentDataProvider);
        if (spiResponse.hasError()) {
            ErrorHolder errorHolder = this.spiErrorMapper.mapToErrorHolder(spiResponse, ServiceType.PIS);
            log.info("InR-ID: [{}], X-Request-ID: [{}], Payment-ID [{}]. CREATE COMMON Payment failed. Can't initiate Payment at SPI-level. Error msg: {}.", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), payment.getPaymentId(), errorHolder});
            return new CommonPaymentInitiationResponse(errorHolder);
        }
        return this.spiToXs2aPaymentMapper.mapToCommonPaymentInitiateResponse((SpiPaymentInitiationResponse)spiResponse.getPayload(), payment.getPaymentType(), aspspConsentDataProvider);
    }

    @ConstructorProperties(value={"singlePaymentSpi", "periodicPaymentSpi", "bulkPaymentSpi", "commonPaymentSpi", "xs2AToSpiSinglePaymentMapper", "xs2aToSpiPeriodicPaymentMapper", "xs2aToSpiBulkPaymentMapper", "xs2aToSpiPaymentInfo", "spiToXs2aPaymentMapper", "spiContextDataProvider", "spiErrorMapper", "aspspConsentDataProviderFactory", "requestProviderService"})
    public ScaPaymentService(SinglePaymentSpi singlePaymentSpi, PeriodicPaymentSpi periodicPaymentSpi, BulkPaymentSpi bulkPaymentSpi, CommonPaymentSpi commonPaymentSpi, Xs2aToSpiSinglePaymentMapper xs2AToSpiSinglePaymentMapper, Xs2aToSpiPeriodicPaymentMapper xs2aToSpiPeriodicPaymentMapper, Xs2aToSpiBulkPaymentMapper xs2aToSpiBulkPaymentMapper, Xs2aToSpiPaymentInfo xs2aToSpiPaymentInfo, SpiToXs2aPaymentMapper spiToXs2aPaymentMapper, SpiContextDataProvider spiContextDataProvider, SpiErrorMapper spiErrorMapper, SpiAspspConsentDataProviderFactory aspspConsentDataProviderFactory, RequestProviderService requestProviderService) {
        this.singlePaymentSpi = singlePaymentSpi;
        this.periodicPaymentSpi = periodicPaymentSpi;
        this.bulkPaymentSpi = bulkPaymentSpi;
        this.commonPaymentSpi = commonPaymentSpi;
        this.xs2AToSpiSinglePaymentMapper = xs2AToSpiSinglePaymentMapper;
        this.xs2aToSpiPeriodicPaymentMapper = xs2aToSpiPeriodicPaymentMapper;
        this.xs2aToSpiBulkPaymentMapper = xs2aToSpiBulkPaymentMapper;
        this.xs2aToSpiPaymentInfo = xs2aToSpiPaymentInfo;
        this.spiToXs2aPaymentMapper = spiToXs2aPaymentMapper;
        this.spiContextDataProvider = spiContextDataProvider;
        this.spiErrorMapper = spiErrorMapper;
        this.aspspConsentDataProviderFactory = aspspConsentDataProviderFactory;
        this.requestProviderService = requestProviderService;
    }
}

