/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.payment;

import de.adorsys.psd2.consent.api.pis.PisPayment;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.domain.ErrorHolder;
import de.adorsys.psd2.xs2a.domain.pis.ReadPaymentStatusResponse;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ServiceType;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiErrorMapper;
import de.adorsys.psd2.xs2a.service.payment.ReadPaymentStatusService;
import de.adorsys.psd2.xs2a.service.payment.SpiPaymentFactory;
import de.adorsys.psd2.xs2a.service.spi.SpiAspspConsentDataProviderFactory;
import de.adorsys.psd2.xs2a.spi.domain.SpiAspspConsentDataProvider;
import de.adorsys.psd2.xs2a.spi.domain.SpiContextData;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiBulkPayment;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.BulkPaymentSpi;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="status-bulk-payments")
public class ReadBulkPaymentStatusService
implements ReadPaymentStatusService {
    private static final Logger log = LoggerFactory.getLogger(ReadBulkPaymentStatusService.class);
    private final SpiPaymentFactory spiPaymentFactory;
    private final SpiErrorMapper spiErrorMapper;
    private final BulkPaymentSpi bulkPaymentSpi;
    private final SpiAspspConsentDataProviderFactory aspspConsentDataProviderFactory;
    private final RequestProviderService requestProviderService;

    @Override
    public ReadPaymentStatusResponse readPaymentStatus(List<PisPayment> pisPayments, String paymentProduct, SpiContextData spiContextData, @NotNull String encryptedPaymentId) {
        Optional<SpiBulkPayment> spiBulkPaymentOptional = this.spiPaymentFactory.createSpiBulkPayment(pisPayments, paymentProduct);
        if (!spiBulkPaymentOptional.isPresent()) {
            return new ReadPaymentStatusResponse(ErrorHolder.builder(MessageErrorCode.RESOURCE_UNKNOWN_404).messages(Collections.singletonList("Payment not found")).build());
        }
        SpiAspspConsentDataProvider aspspConsentDataProvider = this.aspspConsentDataProviderFactory.getSpiAspspDataProviderFor(encryptedPaymentId);
        SpiResponse spiResponse = this.bulkPaymentSpi.getPaymentStatusById(spiContextData, spiBulkPaymentOptional.get(), aspspConsentDataProvider);
        if (spiResponse.hasError()) {
            ErrorHolder errorHolder = this.spiErrorMapper.mapToErrorHolder(spiResponse, ServiceType.PIS);
            log.info("InR-ID: [{}], X-Request-ID: [{}], Payment-ID [{}]. READ BULK Payment STATUS failed. Can't get Payment status by id at SPI-level. Error msg: [{}]", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), spiBulkPaymentOptional.get().getPaymentId(), errorHolder});
            return new ReadPaymentStatusResponse(errorHolder);
        }
        return new ReadPaymentStatusResponse((TransactionStatus)spiResponse.getPayload());
    }

    @ConstructorProperties(value={"spiPaymentFactory", "spiErrorMapper", "bulkPaymentSpi", "aspspConsentDataProviderFactory", "requestProviderService"})
    public ReadBulkPaymentStatusService(SpiPaymentFactory spiPaymentFactory, SpiErrorMapper spiErrorMapper, BulkPaymentSpi bulkPaymentSpi, SpiAspspConsentDataProviderFactory aspspConsentDataProviderFactory, RequestProviderService requestProviderService) {
        this.spiPaymentFactory = spiPaymentFactory;
        this.spiErrorMapper = spiErrorMapper;
        this.bulkPaymentSpi = bulkPaymentSpi;
        this.aspspConsentDataProviderFactory = aspspConsentDataProviderFactory;
        this.requestProviderService = requestProviderService;
    }
}

