/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.payment;

import de.adorsys.psd2.consent.api.pis.proto.PisPaymentInfo;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.tpp.TppInfo;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aCreatePisAuthorisationResponse;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aPisCommonPayment;
import de.adorsys.psd2.xs2a.domain.pis.BulkPayment;
import de.adorsys.psd2.xs2a.domain.pis.BulkPaymentInitiationResponse;
import de.adorsys.psd2.xs2a.domain.pis.PaymentInitiationParameters;
import de.adorsys.psd2.xs2a.domain.pis.SinglePayment;
import de.adorsys.psd2.xs2a.service.authorization.AuthorisationMethodDecider;
import de.adorsys.psd2.xs2a.service.authorization.pis.PisScaAuthorisationService;
import de.adorsys.psd2.xs2a.service.authorization.pis.PisScaAuthorisationServiceResolver;
import de.adorsys.psd2.xs2a.service.consent.Xs2aPisCommonPaymentService;
import de.adorsys.psd2.xs2a.service.mapper.consent.Xs2aPisCommonPaymentMapper;
import de.adorsys.psd2.xs2a.service.mapper.consent.Xs2aToCmsPisCommonPaymentRequestMapper;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ErrorType;
import de.adorsys.psd2.xs2a.service.payment.CreatePaymentService;
import de.adorsys.psd2.xs2a.service.payment.sca.ScaPaymentService;
import de.adorsys.psd2.xs2a.service.payment.sca.ScaPaymentServiceResolver;
import de.adorsys.psd2.xs2a.service.spi.InitialSpiAspspConsentDataProvider;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class CreateBulkPaymentService
implements CreatePaymentService<BulkPayment, BulkPaymentInitiationResponse> {
    private final ScaPaymentServiceResolver scaPaymentServiceResolver;
    private final Xs2aPisCommonPaymentService pisCommonPaymentService;
    private final AuthorisationMethodDecider authorisationMethodDecider;
    private final PisScaAuthorisationServiceResolver pisScaAuthorisationServiceResolver;
    private final Xs2aPisCommonPaymentMapper xs2aPisCommonPaymentMapper;
    private final Xs2aToCmsPisCommonPaymentRequestMapper xs2aToCmsPisCommonPaymentRequestMapper;

    @Override
    public ResponseObject<BulkPaymentInitiationResponse> createPayment(BulkPayment bulkPayment, PaymentInitiationParameters paymentInitiationParameters, TppInfo tppInfo) {
        PsuIdData psuData = paymentInitiationParameters.getPsuData();
        ScaPaymentService scaPaymentService = (ScaPaymentService)this.scaPaymentServiceResolver.getService();
        BulkPaymentInitiationResponse response = scaPaymentService.createBulkPayment(bulkPayment, tppInfo, paymentInitiationParameters.getPaymentProduct(), psuData);
        if (response.hasError()) {
            return this.buildErrorResponse(response.getErrorHolder());
        }
        PisPaymentInfo pisPaymentInfo = this.xs2aToCmsPisCommonPaymentRequestMapper.mapToPisPaymentInfo(paymentInitiationParameters, tppInfo, response);
        Xs2aPisCommonPayment pisCommonPayment = this.xs2aPisCommonPaymentMapper.mapToXs2aPisCommonPayment(this.pisCommonPaymentService.createCommonPayment(pisPaymentInfo), psuData);
        String externalPaymentId = pisCommonPayment.getPaymentId();
        if (StringUtils.isBlank((CharSequence)externalPaymentId)) {
            return ResponseObject.builder().fail(ErrorType.PIS_400, TppMessageInformation.of(MessageErrorCode.PAYMENT_FAILED)).build();
        }
        InitialSpiAspspConsentDataProvider aspspConsentDataProvider = response.getAspspConsentDataProvider();
        aspspConsentDataProvider.saveWith(externalPaymentId);
        bulkPayment.setTransactionStatus(response.getTransactionStatus());
        bulkPayment.setPaymentId(response.getPaymentId());
        BulkPayment bulkPaymentUpdated = this.setRandomIdsToPaymentListInBulkPayment(bulkPayment);
        this.pisCommonPaymentService.updateBulkPaymentInCommonPayment(bulkPaymentUpdated, paymentInitiationParameters, pisCommonPayment.getPaymentId());
        response.setPaymentId(externalPaymentId);
        boolean implicitMethod = this.authorisationMethodDecider.isImplicitMethod(paymentInitiationParameters.isTppExplicitAuthorisationPreferred(), response.isMultilevelScaRequired());
        if (implicitMethod) {
            PisScaAuthorisationService pisScaAuthorisationService = (PisScaAuthorisationService)this.pisScaAuthorisationServiceResolver.getService();
            Optional<Xs2aCreatePisAuthorisationResponse> consentAuthorisation = pisScaAuthorisationService.createCommonPaymentAuthorisation(externalPaymentId, PaymentType.BULK, paymentInitiationParameters.getPsuData());
            if (!consentAuthorisation.isPresent()) {
                return ResponseObject.builder().fail(ErrorType.PIS_400, TppMessageInformation.of(MessageErrorCode.PAYMENT_FAILED)).build();
            }
            Xs2aCreatePisAuthorisationResponse authorisationResponse = consentAuthorisation.get();
            response.setAuthorizationId(authorisationResponse.getAuthorisationId());
            response.setScaStatus(authorisationResponse.getScaStatus());
        }
        return ResponseObject.builder().body(response).build();
    }

    private BulkPayment setRandomIdsToPaymentListInBulkPayment(BulkPayment bulkPayment) {
        List<SinglePayment> payments = bulkPayment.getPayments();
        for (SinglePayment payment : payments) {
            payment.setPaymentId(UUID.randomUUID().toString());
        }
        bulkPayment.setPayments(payments);
        return bulkPayment;
    }

    @ConstructorProperties(value={"scaPaymentServiceResolver", "pisCommonPaymentService", "authorisationMethodDecider", "pisScaAuthorisationServiceResolver", "xs2aPisCommonPaymentMapper", "xs2aToCmsPisCommonPaymentRequestMapper"})
    public CreateBulkPaymentService(ScaPaymentServiceResolver scaPaymentServiceResolver, Xs2aPisCommonPaymentService pisCommonPaymentService, AuthorisationMethodDecider authorisationMethodDecider, PisScaAuthorisationServiceResolver pisScaAuthorisationServiceResolver, Xs2aPisCommonPaymentMapper xs2aPisCommonPaymentMapper, Xs2aToCmsPisCommonPaymentRequestMapper xs2aToCmsPisCommonPaymentRequestMapper) {
        this.scaPaymentServiceResolver = scaPaymentServiceResolver;
        this.pisCommonPaymentService = pisCommonPaymentService;
        this.authorisationMethodDecider = authorisationMethodDecider;
        this.pisScaAuthorisationServiceResolver = pisScaAuthorisationServiceResolver;
        this.xs2aPisCommonPaymentMapper = xs2aPisCommonPaymentMapper;
        this.xs2aToCmsPisCommonPaymentRequestMapper = xs2aToCmsPisCommonPaymentRequestMapper;
    }
}

