/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper;

import de.adorsys.psd2.model.AccountDetails;
import de.adorsys.psd2.model.AccountList;
import de.adorsys.psd2.model.AccountReference;
import de.adorsys.psd2.model.AccountReport;
import de.adorsys.psd2.model.Balance;
import de.adorsys.psd2.model.BalanceList;
import de.adorsys.psd2.model.BalanceType;
import de.adorsys.psd2.model.ReadAccountBalanceResponse200;
import de.adorsys.psd2.model.ReportExchangeRate;
import de.adorsys.psd2.model.ReportExchangeRateList;
import de.adorsys.psd2.model.TransactionDetails;
import de.adorsys.psd2.model.TransactionList;
import de.adorsys.psd2.model.TransactionsResponse200Json;
import de.adorsys.psd2.xs2a.domain.Transactions;
import de.adorsys.psd2.xs2a.domain.Xs2aBalance;
import de.adorsys.psd2.xs2a.domain.Xs2aExchangeRate;
import de.adorsys.psd2.xs2a.domain.account.Xs2aAccountDetails;
import de.adorsys.psd2.xs2a.domain.account.Xs2aAccountDetailsHolder;
import de.adorsys.psd2.xs2a.domain.account.Xs2aAccountListHolder;
import de.adorsys.psd2.xs2a.domain.account.Xs2aAccountReport;
import de.adorsys.psd2.xs2a.domain.account.Xs2aBalancesReport;
import de.adorsys.psd2.xs2a.domain.account.Xs2aTransactionsReport;
import de.adorsys.psd2.xs2a.service.mapper.AmountModelMapper;
import de.adorsys.psd2.xs2a.web.mapper.HrefLinkMapper;
import de.adorsys.psd2.xs2a.web.mapper.PurposeCodeMapper;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.Nullable;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;
import org.springframework.beans.factory.annotation.Autowired;

@Mapper(componentModel="spring", uses={AmountModelMapper.class, PurposeCodeMapper.class})
public abstract class AccountModelMapper {
    @Autowired
    protected HrefLinkMapper hrefLinkMapper;

    @Mapping(target="currency", source="currency.currencyCode")
    public abstract AccountReference mapToAccountReference(de.adorsys.psd2.xs2a.core.profile.AccountReference var1);

    public abstract List<AccountReference> mapToAccountReferences(List<de.adorsys.psd2.xs2a.core.profile.AccountReference> var1);

    public AccountList mapToAccountList(Xs2aAccountListHolder xs2aAccountListHolder) {
        List<Xs2aAccountDetails> accountDetailsList = xs2aAccountListHolder.getAccountDetails();
        List details = accountDetailsList.stream().map(this::mapToAccountDetails).collect(Collectors.toList());
        return new AccountList().accounts(details);
    }

    public AccountDetails mapToAccountDetails(Xs2aAccountDetailsHolder xs2aAccountDetailsHolder) {
        return this.mapToAccountDetails(xs2aAccountDetailsHolder.getAccountDetails());
    }

    @Mappings(value={@Mapping(target="links", expression="java(hrefLinkMapper.mapToLinksMap(accountDetails.getLinks()))"), @Mapping(target="status", source="accountStatus"), @Mapping(target="usage", source="usageType")})
    public abstract AccountDetails mapToAccountDetails(Xs2aAccountDetails var1);

    @Mappings(value={@Mapping(target="balanceType", expression="java(mapToBalanceType(balance.getBalanceType()))"), @Mapping(target="lastChangeDateTime", expression="java(mapToOffsetDateTime(balance.getLastChangeDateTime()))")})
    public abstract Balance mapToBalance(Xs2aBalance var1);

    @Mapping(target="account", source="xs2aAccountReference")
    public abstract ReadAccountBalanceResponse200 mapToBalance(Xs2aBalancesReport var1);

    @Mapping(target="links", expression="java(hrefLinkMapper.mapToLinksMap(accountReport.getLinks()))")
    public abstract AccountReport mapToAccountReport(Xs2aAccountReport var1);

    @Mappings(value={@Mapping(target="links", expression="java(hrefLinkMapper.mapToLinksMap(transactionsReport.getLinks()))"), @Mapping(target="transactions", source="accountReport"), @Mapping(target="account", source="accountReference")})
    public abstract TransactionsResponse200Json mapToTransactionsResponse200Json(Xs2aTransactionsReport var1);

    public byte[] mapToTransactionsResponseRaw(Xs2aTransactionsReport transactionsReport) {
        return transactionsReport.getAccountReport().getTransactionsRaw();
    }

    @Mappings(value={@Mapping(target="currencyExchange", expression="java(mapToReportExchanges(transactions.getExchangeRate()))"), @Mapping(target="bankTransactionCode", source="bankTransactionCodeCode.code"), @Mapping(target="transactionAmount", source="amount"), @Mapping(target="links", ignore=true)})
    public abstract TransactionDetails mapToTransaction(Transactions var1);

    public Map<String, TransactionDetails> mapToTransactionDetails(Transactions transactions) {
        HashMap<String, TransactionDetails> transactionDetails = new HashMap<String, TransactionDetails>();
        transactionDetails.put("transactionsDetails", this.mapToTransaction(transactions));
        return transactionDetails;
    }

    protected OffsetDateTime mapToOffsetDateTime(LocalDateTime localDateTime) {
        if (localDateTime == null) {
            return null;
        }
        List<ZoneOffset> validOffsets = ZoneId.systemDefault().getRules().getValidOffsets(localDateTime);
        return localDateTime.atOffset(validOffsets.get(0));
    }

    protected BalanceType mapToBalanceType(de.adorsys.psd2.xs2a.domain.BalanceType balanceType) {
        if (balanceType == null) {
            return null;
        }
        return BalanceType.fromValue((String)balanceType.getValue());
    }

    protected BalanceList mapToBalanceList(List<Xs2aBalance> balances) {
        BalanceList balanceList = null;
        if (CollectionUtils.isNotEmpty(balances)) {
            balanceList = new BalanceList();
            balanceList.addAll((Collection)balances.stream().map(this::mapToBalance).collect(Collectors.toList()));
        }
        return balanceList;
    }

    @Nullable
    protected TransactionList mapToTransactionList(@Nullable List<Transactions> transactions) {
        if (CollectionUtils.isEmpty(transactions)) {
            return null;
        }
        List transactionDetails = transactions.stream().map(this::mapToTransaction).collect(Collectors.toList());
        TransactionList transactionList = new TransactionList();
        transactionList.addAll(transactionDetails);
        return transactionList;
    }

    protected ReportExchangeRateList mapToReportExchanges(List<Xs2aExchangeRate> xs2aExchangeRates) {
        if (CollectionUtils.isEmpty(xs2aExchangeRates)) {
            return null;
        }
        return xs2aExchangeRates.stream().map(this::mapToReportExchangeRate).collect(Collectors.toCollection(ReportExchangeRateList::new));
    }

    protected abstract ReportExchangeRate mapToReportExchangeRate(Xs2aExchangeRate var1);
}

