/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.authorization.ais.stage.embedded;

import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.domain.consent.AccountConsent;
import de.adorsys.psd2.xs2a.domain.consent.UpdateConsentPsuDataReq;
import de.adorsys.psd2.xs2a.domain.consent.UpdateConsentPsuDataResponse;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.authorization.ais.stage.AisScaStage;
import de.adorsys.psd2.xs2a.service.consent.Xs2aAisConsentService;
import de.adorsys.psd2.xs2a.service.context.SpiContextDataProvider;
import de.adorsys.psd2.xs2a.service.mapper.consent.Xs2aAisConsentMapper;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ErrorType;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ServiceType;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiErrorMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aAuthenticationObjectMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.Xs2aToSpiPsuDataMapper;
import de.adorsys.psd2.xs2a.service.spi.SpiAspspConsentDataProviderFactory;
import de.adorsys.psd2.xs2a.spi.domain.consent.SpiVerifyScaAuthorisationResponse;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.AisConsentSpi;
import java.util.Collections;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="AIS_SCAMETHODSELECTED")
public class AisScaAuthenticatedStage
extends AisScaStage<UpdateConsentPsuDataReq, UpdateConsentPsuDataResponse> {
    private static final Logger log = LoggerFactory.getLogger(AisScaAuthenticatedStage.class);
    private final SpiContextDataProvider spiContextDataProvider;
    private final RequestProviderService requestProviderService;

    public AisScaAuthenticatedStage(Xs2aAisConsentService aisConsentService, SpiAspspConsentDataProviderFactory aspspConsentDataProviderFactory, RequestProviderService requestProviderService, AisConsentSpi aisConsentSpi, Xs2aAisConsentMapper aisConsentMapper, Xs2aToSpiPsuDataMapper psuDataMapper, SpiToXs2aAuthenticationObjectMapper spiToXs2aAuthenticationObjectMapper, SpiContextDataProvider spiContextDataProvider, SpiErrorMapper spiErrorMapper) {
        super(aisConsentService, aspspConsentDataProviderFactory, aisConsentSpi, aisConsentMapper, psuDataMapper, spiToXs2aAuthenticationObjectMapper, spiErrorMapper);
        this.spiContextDataProvider = spiContextDataProvider;
        this.requestProviderService = requestProviderService;
    }

    @Override
    public UpdateConsentPsuDataResponse apply(UpdateConsentPsuDataReq request) {
        String consentId = request.getConsentId();
        Optional<AccountConsent> accountConsentOptional = this.aisConsentService.getAccountConsentById(consentId);
        if (!accountConsentOptional.isPresent()) {
            log.warn("InR-ID: [{}], X-Request-ID: [{}], Consent-ID [{}]. AIS_SCAMETHODSELECTED stage. Apply authorisation when update consent PSU data has failed. Consent not found by id.", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), consentId});
            MessageError messageError = new MessageError(ErrorType.AIS_400, TppMessageInformation.of(MessageErrorCode.CONSENT_UNKNOWN_400));
            return this.createFailedResponse(messageError, Collections.emptyList(), request);
        }
        AccountConsent accountConsent = accountConsentOptional.get();
        PsuIdData psuData = this.extractPsuIdData(request);
        SpiResponse spiResponse = this.aisConsentSpi.verifyScaAuthorisation(this.spiContextDataProvider.provideWithPsuIdData(psuData), this.aisConsentMapper.mapToSpiScaConfirmation(request, psuData), this.aisConsentMapper.mapToSpiAccountConsent(accountConsent), this.aspspConsentDataProviderFactory.getSpiAspspDataProviderFor(consentId));
        if (spiResponse.hasError()) {
            MessageError messageError = new MessageError(this.spiErrorMapper.mapToErrorHolder(spiResponse, ServiceType.AIS));
            log.warn("InR-ID: [{}], X-Request-ID: [{}], Consent-ID [{}], Authorisation-ID [{}], PSU-ID [{}]. AIS_SCAMETHODSELECTED stage. Verify SCA authorisation failed when update PSU data. Error msg: [{}]", new Object[]{this.requestProviderService.getInternalRequestId(), this.requestProviderService.getRequestId(), consentId, request.getAuthorizationId(), psuData.getPsuId(), messageError});
            return this.createFailedResponse(messageError, spiResponse.getMessages(), request);
        }
        ConsentStatus responseConsentStatus = ((SpiVerifyScaAuthorisationResponse)spiResponse.getPayload()).getConsentStatus();
        if (ConsentStatus.PARTIALLY_AUTHORISED == responseConsentStatus && !accountConsent.isMultilevelScaRequired()) {
            this.aisConsentService.updateMultilevelScaRequired(consentId, true);
        }
        if (accountConsent.getConsentStatus() != responseConsentStatus) {
            this.aisConsentService.updateConsentStatus(consentId, responseConsentStatus);
        }
        this.aisConsentService.findAndTerminateOldConsentsByNewConsentId(consentId);
        UpdateConsentPsuDataResponse response = new UpdateConsentPsuDataResponse(ScaStatus.FINALISED, consentId, request.getAuthorizationId());
        response.setScaAuthenticationData(request.getScaAuthenticationData());
        return response;
    }
}

