/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.domain;

import de.adorsys.psd2.xs2a.domain.BalanceType;
import de.adorsys.psd2.xs2a.domain.Xs2aAmount;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.time.LocalDateTime;
import javax.validation.constraints.Size;

@ApiModel(description="Balance Information", value="Balance")
public class Xs2aBalance {
    @ApiModelProperty(value="balance amount", required=true)
    private Xs2aAmount balanceAmount;
    @ApiModelProperty(value="balance type", required=true)
    private BalanceType balanceType;
    @ApiModelProperty(value="This data element might be used to indicate e.g. with the expected or booked balance that no action is known on the account, which is not yet booked.", example="2017-10-25T15:30:35.035")
    private LocalDateTime lastChangeDateTime;
    @ApiModelProperty(value="Reference date of the balance", example="2017-03-26")
    private LocalDate referenceDate;
    @ApiModelProperty(value="entryReference of the last commited transaction to support the TPP in identifying whether all PSU transactions are already known.")
    @Size(max=35)
    private @Size(max=35) String lastCommittedTransaction;

    public Xs2aAmount getBalanceAmount() {
        return this.balanceAmount;
    }

    public BalanceType getBalanceType() {
        return this.balanceType;
    }

    public LocalDateTime getLastChangeDateTime() {
        return this.lastChangeDateTime;
    }

    public LocalDate getReferenceDate() {
        return this.referenceDate;
    }

    public String getLastCommittedTransaction() {
        return this.lastCommittedTransaction;
    }

    public void setBalanceAmount(Xs2aAmount balanceAmount) {
        this.balanceAmount = balanceAmount;
    }

    public void setBalanceType(BalanceType balanceType) {
        this.balanceType = balanceType;
    }

    public void setLastChangeDateTime(LocalDateTime lastChangeDateTime) {
        this.lastChangeDateTime = lastChangeDateTime;
    }

    public void setReferenceDate(LocalDate referenceDate) {
        this.referenceDate = referenceDate;
    }

    public void setLastCommittedTransaction(String lastCommittedTransaction) {
        this.lastCommittedTransaction = lastCommittedTransaction;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Xs2aBalance)) {
            return false;
        }
        Xs2aBalance other = (Xs2aBalance)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Xs2aAmount this$balanceAmount = this.getBalanceAmount();
        Xs2aAmount other$balanceAmount = other.getBalanceAmount();
        if (this$balanceAmount == null ? other$balanceAmount != null : !((Object)this$balanceAmount).equals(other$balanceAmount)) {
            return false;
        }
        BalanceType this$balanceType = this.getBalanceType();
        BalanceType other$balanceType = other.getBalanceType();
        if (this$balanceType == null ? other$balanceType != null : !((Object)((Object)this$balanceType)).equals((Object)other$balanceType)) {
            return false;
        }
        LocalDateTime this$lastChangeDateTime = this.getLastChangeDateTime();
        LocalDateTime other$lastChangeDateTime = other.getLastChangeDateTime();
        if (this$lastChangeDateTime == null ? other$lastChangeDateTime != null : !((Object)this$lastChangeDateTime).equals(other$lastChangeDateTime)) {
            return false;
        }
        LocalDate this$referenceDate = this.getReferenceDate();
        LocalDate other$referenceDate = other.getReferenceDate();
        if (this$referenceDate == null ? other$referenceDate != null : !((Object)this$referenceDate).equals(other$referenceDate)) {
            return false;
        }
        String this$lastCommittedTransaction = this.getLastCommittedTransaction();
        String other$lastCommittedTransaction = other.getLastCommittedTransaction();
        return !(this$lastCommittedTransaction == null ? other$lastCommittedTransaction != null : !this$lastCommittedTransaction.equals(other$lastCommittedTransaction));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Xs2aBalance;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Xs2aAmount $balanceAmount = this.getBalanceAmount();
        result = result * 59 + ($balanceAmount == null ? 43 : ((Object)$balanceAmount).hashCode());
        BalanceType $balanceType = this.getBalanceType();
        result = result * 59 + ($balanceType == null ? 43 : ((Object)((Object)$balanceType)).hashCode());
        LocalDateTime $lastChangeDateTime = this.getLastChangeDateTime();
        result = result * 59 + ($lastChangeDateTime == null ? 43 : ((Object)$lastChangeDateTime).hashCode());
        LocalDate $referenceDate = this.getReferenceDate();
        result = result * 59 + ($referenceDate == null ? 43 : ((Object)$referenceDate).hashCode());
        String $lastCommittedTransaction = this.getLastCommittedTransaction();
        result = result * 59 + ($lastCommittedTransaction == null ? 43 : $lastCommittedTransaction.hashCode());
        return result;
    }

    public String toString() {
        return "Xs2aBalance(balanceAmount=" + this.getBalanceAmount() + ", balanceType=" + (Object)((Object)this.getBalanceType()) + ", lastChangeDateTime=" + this.getLastChangeDateTime() + ", referenceDate=" + this.getReferenceDate() + ", lastCommittedTransaction=" + this.getLastCommittedTransaction() + ")";
    }
}

