/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.validator.body.payment;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.psd2.xs2a.component.JsonConverter;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.service.profile.StandardPaymentProductsResolver;
import de.adorsys.psd2.xs2a.web.validator.ErrorBuildingService;
import de.adorsys.psd2.xs2a.web.validator.body.AbstractBodyValidatorImpl;
import de.adorsys.psd2.xs2a.web.validator.body.payment.PaymentBodyValidator;
import de.adorsys.psd2.xs2a.web.validator.body.payment.type.PaymentTypeValidator;
import de.adorsys.psd2.xs2a.web.validator.body.payment.type.PaymentTypeValidatorContext;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerMapping;

@Component
public class PaymentBodyValidatorImpl
extends AbstractBodyValidatorImpl
implements PaymentBodyValidator {
    private static final String PAYMENT_SERVICE_PATH_VAR = "payment-service";
    private static final String PAYMENT_PRODUCT_PATH_VAR = "payment-product";
    private static final String DAY_OF_EXECUTION_FIELD_NAME = "dayOfExecution";
    private static final String DAY_OF_MONTH_REGEX = "(0?[1-9]|[12]\\d|3[01])";
    private static final String DAY_OF_EXECUTION_WRONG_VALUE_ERROR = "Value 'dayOfExecution' should be a number of day in month";
    private static final String BODY_DESERIALIZATION_ERROR = "Cannot deserialize the request body";
    private PaymentTypeValidatorContext paymentTypeValidatorContext;
    private final JsonConverter jsonConverter;
    private final StandardPaymentProductsResolver standardPaymentProductsResolver;

    @Autowired
    public PaymentBodyValidatorImpl(ErrorBuildingService errorBuildingService, ObjectMapper objectMapper, PaymentTypeValidatorContext paymentTypeValidatorContext, StandardPaymentProductsResolver standardPaymentProductsResolver, JsonConverter jsonConverter) {
        super(errorBuildingService, objectMapper);
        this.paymentTypeValidatorContext = paymentTypeValidatorContext;
        this.standardPaymentProductsResolver = standardPaymentProductsResolver;
        this.jsonConverter = jsonConverter;
    }

    @Override
    public void validate(HttpServletRequest request, MessageError messageError) {
        Map pathParametersMap = (Map)request.getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE);
        if (this.isRawPaymentProduct(pathParametersMap)) {
            return;
        }
        Optional<Object> bodyOptional = this.mapBodyToInstance(request, messageError, Object.class);
        if (!bodyOptional.isPresent()) {
            return;
        }
        this.validateRawData(request, messageError);
        this.validateInitiatePaymentBody(bodyOptional.get(), pathParametersMap, messageError);
    }

    private void validateInitiatePaymentBody(Object body, Map<String, String> pathParametersMap, MessageError messageError) {
        String paymentService = pathParametersMap.get(PAYMENT_SERVICE_PATH_VAR);
        Optional<PaymentTypeValidator> validator = this.paymentTypeValidatorContext.getValidator(paymentService);
        if (!validator.isPresent()) {
            throw new IllegalArgumentException("Unsupported payment service");
        }
        validator.get().validate(body, messageError);
    }

    private boolean isRawPaymentProduct(Map<String, String> pathParametersMap) {
        String paymentProduct = pathParametersMap.get(PAYMENT_PRODUCT_PATH_VAR);
        return this.standardPaymentProductsResolver.isRawPaymentProduct(paymentProduct);
    }

    private void validateRawData(HttpServletRequest request, MessageError messageError) {
        String dayOfExecution = this.extractDayOfExecution(request, messageError);
        this.validateDayOfExecutionValue(dayOfExecution, messageError);
    }

    private void validateDayOfExecutionValue(String value, MessageError messageError) {
        if (value == null) {
            return;
        }
        if (!this.isNumberADayOfMonth(value)) {
            this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of(MessageErrorCode.FORMAT_ERROR, DAY_OF_EXECUTION_WRONG_VALUE_ERROR));
        }
    }

    private boolean isNumberADayOfMonth(@NotNull String value) {
        return value.matches(DAY_OF_MONTH_REGEX);
    }

    private String extractDayOfExecution(HttpServletRequest request, MessageError messageError) {
        Optional<Object> dayOfExecutionOptional = Optional.empty();
        try {
            dayOfExecutionOptional = this.jsonConverter.toJsonField((InputStream)request.getInputStream(), DAY_OF_EXECUTION_FIELD_NAME, new TypeReference<String>(){});
        }
        catch (IOException e) {
            this.errorBuildingService.enrichMessageError(messageError, BODY_DESERIALIZATION_ERROR);
        }
        return dayOfExecutionOptional.orElse(null);
    }
}

