/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.mapper;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.psd2.model.BulkPaymentInitiationJson;
import de.adorsys.psd2.model.PaymentInitiationJson;
import de.adorsys.psd2.model.PeriodicPaymentInitiationJson;
import de.adorsys.psd2.model.PeriodicPaymentInitiationXmlPart2StandingorderTypeJson;
import de.adorsys.psd2.xs2a.component.JsonConverter;
import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.domain.pis.PaymentInitiationParameters;
import de.adorsys.psd2.xs2a.service.validator.ValueValidatorService;
import de.adorsys.psd2.xs2a.web.mapper.PaymentModelMapper;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PaymentModelMapperXs2a {
    private static final Logger log = LoggerFactory.getLogger(PaymentModelMapperXs2a.class);
    private final ObjectMapper mapper;
    private final ValueValidatorService validationService;
    private final HttpServletRequest httpServletRequest;
    private final JsonConverter jsonConverter;
    private final PaymentModelMapper paymentModelMapper;

    public Object mapToXs2aPayment(Object payment, PaymentInitiationParameters requestParameters) {
        if (requestParameters.getPaymentType() == PaymentType.SINGLE) {
            return this.paymentModelMapper.mapToXs2aPayment(this.validatePayment(payment, PaymentInitiationJson.class));
        }
        if (requestParameters.getPaymentType() == PaymentType.PERIODIC) {
            return this.paymentModelMapper.mapToXs2aPayment(this.validatePayment(payment, PeriodicPaymentInitiationJson.class));
        }
        return this.paymentModelMapper.mapToXs2aPayment(this.validatePayment(payment, BulkPaymentInitiationJson.class));
    }

    public Object mapToXs2aRawPayment(PaymentInitiationParameters requestParameters, Object xmlSct, PeriodicPaymentInitiationXmlPart2StandingorderTypeJson jsonStandingOrderType) {
        if (requestParameters.getPaymentType() == PaymentType.PERIODIC) {
            return this.buildPeriodicBinaryBodyData(xmlSct, jsonStandingOrderType);
        }
        return this.buildBinaryBodyData(this.httpServletRequest);
    }

    private <R> R validatePayment(Object payment, Class<R> clazz) {
        Object result = this.mapper.convertValue(payment, clazz);
        this.validationService.validate(result, new Class[0]);
        return (R)result;
    }

    private byte[] buildBinaryBodyData(HttpServletRequest httpServletRequest) {
        try {
            return IOUtils.toByteArray((InputStream)httpServletRequest.getInputStream());
        }
        catch (IOException e) {
            log.warn("Cannot deserialize httpServletRequest body!", (Throwable)e);
            return null;
        }
    }

    private byte[] buildPeriodicBinaryBodyData(Object xmlPart, PeriodicPaymentInitiationXmlPart2StandingorderTypeJson jsonPart) {
        Optional<String> serialisedJsonPart = this.jsonConverter.toJson(jsonPart);
        if (xmlPart == null || !serialisedJsonPart.isPresent()) {
            throw new IllegalArgumentException("Invalid body of the multipart request!");
        }
        String body = xmlPart + "\n" + serialisedJsonPart.get();
        return body.getBytes(Charset.forName("UTF-8"));
    }

    @ConstructorProperties(value={"mapper", "validationService", "httpServletRequest", "jsonConverter", "paymentModelMapper"})
    public PaymentModelMapperXs2a(ObjectMapper mapper, ValueValidatorService validationService, HttpServletRequest httpServletRequest, JsonConverter jsonConverter, PaymentModelMapper paymentModelMapper) {
        this.mapper = mapper;
        this.validationService = validationService;
        this.httpServletRequest = httpServletRequest;
        this.jsonConverter = jsonConverter;
        this.paymentModelMapper = paymentModelMapper;
    }
}

