/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.controller;

import de.adorsys.psd2.api.PaymentApi;
import de.adorsys.psd2.model.PaymentInitationRequestResponse201;
import de.adorsys.psd2.model.PaymentInitiationCancelResponse202;
import de.adorsys.psd2.model.PeriodicPaymentInitiationXmlPart2StandingorderTypeJson;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import de.adorsys.psd2.xs2a.domain.HrefType;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.domain.authorisation.AuthorisationResponse;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aAuthorisationSubResources;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aCreatePisAuthorisationRequest;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aCreatePisCancellationAuthorisationResponse;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aPaymentCancellationAuthorisationSubResource;
import de.adorsys.psd2.xs2a.domain.consent.pis.Xs2aUpdatePisCommonPaymentPsuDataRequest;
import de.adorsys.psd2.xs2a.domain.consent.pis.Xs2aUpdatePisCommonPaymentPsuDataResponse;
import de.adorsys.psd2.xs2a.domain.pis.CancelPaymentResponse;
import de.adorsys.psd2.xs2a.domain.pis.PaymentInitiationParameters;
import de.adorsys.psd2.xs2a.domain.pis.PaymentInitiationResponse;
import de.adorsys.psd2.xs2a.service.PaymentAuthorisationService;
import de.adorsys.psd2.xs2a.service.PaymentCancellationAuthorisationService;
import de.adorsys.psd2.xs2a.service.PaymentService;
import de.adorsys.psd2.xs2a.service.mapper.ResponseMapper;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ErrorType;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ResponseErrorMapper;
import de.adorsys.psd2.xs2a.web.header.PaymentCancellationHeadersBuilder;
import de.adorsys.psd2.xs2a.web.header.PaymentInitiationHeadersBuilder;
import de.adorsys.psd2.xs2a.web.header.ResponseHeaders;
import de.adorsys.psd2.xs2a.web.mapper.AuthorisationMapper;
import de.adorsys.psd2.xs2a.web.mapper.ConsentModelMapper;
import de.adorsys.psd2.xs2a.web.mapper.PaymentModelMapperPsd2;
import de.adorsys.psd2.xs2a.web.mapper.PaymentModelMapperXs2a;
import io.swagger.annotations.Api;
import java.beans.ConstructorProperties;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.validation.Valid;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(value="v1", description="Provides access to the payment initiation", tags={"Payment Initiation Service (PIS)"})
public class PaymentController
implements PaymentApi {
    private final PaymentService xs2aPaymentService;
    private final ResponseMapper responseMapper;
    private final ResponseErrorMapper responseErrorMapper;
    private final PaymentModelMapperPsd2 paymentModelMapperPsd2;
    private final PaymentModelMapperXs2a paymentModelMapperXs2a;
    private final ConsentModelMapper consentModelMapper;
    private final PaymentAuthorisationService paymentAuthorisationService;
    private final PaymentCancellationAuthorisationService paymentCancellationAuthorisationService;
    private final AuthorisationMapper authorisationMapper;
    private final PaymentInitiationHeadersBuilder paymentInitiationHeadersBuilder;
    private final PaymentCancellationHeadersBuilder paymentCancellationHeadersBuilder;

    public ResponseEntity getPaymentInitiationStatus(String paymentService, String paymentProduct, String paymentId, UUID xRequestID, String digest, String signature, byte[] tpPSignatureCertificate, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        ResponseObject serviceResponse = PaymentType.getByValue((String)paymentService).map(pt -> this.xs2aPaymentService.getPaymentStatusById((PaymentType)pt, paymentProduct, paymentId)).orElseGet(ResponseObject.builder().fail(ErrorType.PIS_404, TppMessageInformation.of(MessageErrorCode.RESOURCE_UNKNOWN_404))::build);
        return serviceResponse.hasError() ? this.responseErrorMapper.generateErrorResponse(serviceResponse.getError()) : this.responseMapper.ok(serviceResponse, PaymentModelMapperPsd2::mapToStatusResponse);
    }

    public ResponseEntity getPaymentInformation(String paymentService, String paymentProduct, String paymentId, UUID xRequestID, String digest, String signature, byte[] tpPSignatureCertificate, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        ResponseObject serviceResponse = PaymentType.getByValue((String)paymentService).map(pt -> this.xs2aPaymentService.getPaymentById((PaymentType)pt, paymentProduct, paymentId)).orElseGet(ResponseObject.builder().fail(ErrorType.PIS_404, TppMessageInformation.of(MessageErrorCode.RESOURCE_UNKNOWN_404))::build);
        return serviceResponse.hasError() ? this.responseErrorMapper.generateErrorResponse(serviceResponse.getError()) : this.responseMapper.ok(ResponseObject.builder().body(this.paymentModelMapperPsd2.mapToGetPaymentResponse(serviceResponse.getBody(), (PaymentType)PaymentType.getByValue((String)paymentService).get(), paymentProduct)).build());
    }

    public ResponseEntity initiatePayment(@Valid Object body, UUID xRequestID, String psUIPAddress, String paymentService, String paymentProduct, String digest, String signature, byte[] tpPSignatureCertificate, String PSU_ID, String psUIDType, String psUCorporateID, String psUCorporateIDType, String consentID, Boolean tpPRedirectPreferred, String tpPRedirectURI, String tpPNokRedirectURI, Boolean tpPExplicitAuthorisationPreferred, String tpPRejectionNoFundsPreferred, String tpPNotificationURI, String tpPNotificationContentPreferred, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        if (!PaymentType.getByValue((String)paymentService).isPresent()) {
            ResponseObject responseObject = ResponseObject.builder().fail(ErrorType.PIS_404, TppMessageInformation.of(MessageErrorCode.RESOURCE_UNKNOWN_404)).build();
            return this.responseErrorMapper.generateErrorResponse(responseObject.getError());
        }
        PsuIdData psuData = new PsuIdData(PSU_ID, psUIDType, psUCorporateID, psUCorporateIDType);
        PaymentInitiationParameters paymentInitiationParameters = this.paymentModelMapperPsd2.mapToPaymentRequestParameters(paymentProduct, paymentService, tpPSignatureCertificate, tpPRedirectURI, tpPNokRedirectURI, BooleanUtils.isTrue((Boolean)tpPExplicitAuthorisationPreferred), psuData);
        ResponseObject<PaymentInitiationResponse> serviceResponse = this.xs2aPaymentService.createPayment(this.paymentModelMapperXs2a.mapToXs2aPayment(body, paymentInitiationParameters), paymentInitiationParameters);
        if (serviceResponse.hasError()) {
            return this.responseErrorMapper.generateErrorResponse(serviceResponse.getError(), this.paymentInitiationHeadersBuilder.buildErrorInitiatePaymentHeaders());
        }
        PaymentInitiationResponse serviceResponseBody = serviceResponse.getBody();
        ResponseHeaders responseHeaders = this.buildPaymentInitiationResponseHeaders(serviceResponseBody);
        return this.responseMapper.created(ResponseObject.builder().body(this.paymentModelMapperPsd2.mapToPaymentInitiationResponse(serviceResponseBody)).build(), responseHeaders);
    }

    public ResponseEntity<PaymentInitationRequestResponse201> initiatePayment(UUID xRequestID, String psUIPAddress, String paymentService, String paymentProduct, Object xmlSct, PeriodicPaymentInitiationXmlPart2StandingorderTypeJson jsonStandingorderType, String digest, String signature, byte[] tpPSignatureCertificate, String PSU_ID, String psUIDType, String psUCorporateID, String psUCorporateIDType, String consentID, Boolean tpPRedirectPreferred, String tpPRedirectURI, String tpPNokRedirectURI, Boolean tpPExplicitAuthorisationPreferred, String tpPRejectionNoFundsPreferred, String tpPNotificationURI, String tpPNotificationContentPreferred, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        if (!PaymentType.getByValue((String)paymentService).isPresent()) {
            ResponseObject responseObject = ResponseObject.builder().fail(ErrorType.PIS_404, TppMessageInformation.of(MessageErrorCode.RESOURCE_UNKNOWN_404)).build();
            return this.responseErrorMapper.generateErrorResponse(responseObject.getError());
        }
        PsuIdData psuData = new PsuIdData(PSU_ID, psUIDType, psUCorporateID, psUCorporateIDType);
        PaymentInitiationParameters paymentInitiationParameters = this.paymentModelMapperPsd2.mapToPaymentRequestParameters(paymentProduct, paymentService, tpPSignatureCertificate, tpPRedirectURI, tpPNokRedirectURI, BooleanUtils.isTrue((Boolean)tpPExplicitAuthorisationPreferred), psuData);
        ResponseObject<PaymentInitiationResponse> serviceResponse = this.xs2aPaymentService.createPayment(this.paymentModelMapperXs2a.mapToXs2aRawPayment(paymentInitiationParameters, xmlSct, jsonStandingorderType), paymentInitiationParameters);
        if (serviceResponse.hasError()) {
            return this.responseErrorMapper.generateErrorResponse(serviceResponse.getError(), this.paymentInitiationHeadersBuilder.buildErrorInitiatePaymentHeaders());
        }
        PaymentInitiationResponse serviceResponseBody = serviceResponse.getBody();
        ResponseHeaders responseHeaders = this.buildPaymentInitiationResponseHeaders(serviceResponseBody);
        return this.responseMapper.created(ResponseObject.builder().body(this.paymentModelMapperPsd2.mapToPaymentInitiationResponse(serviceResponseBody)).build(), responseHeaders);
    }

    public ResponseEntity<PaymentInitationRequestResponse201> initiatePayment(String body, UUID xRequestID, String psUIPAddress, String paymentService, String paymentProduct, String digest, String signature, byte[] tpPSignatureCertificate, String PSU_ID, String psUIDType, String psUCorporateID, String psUCorporateIDType, String consentID, Boolean tpPRedirectPreferred, String tpPRedirectURI, String tpPNokRedirectURI, Boolean tpPExplicitAuthorisationPreferred, String tpPRejectionNoFundsPreferred, String tpPNotificationURI, String tpPNotificationContentPreferred, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        if (!PaymentType.getByValue((String)paymentService).isPresent()) {
            ResponseObject responseObject = ResponseObject.builder().fail(ErrorType.PIS_404, TppMessageInformation.of(MessageErrorCode.RESOURCE_UNKNOWN_404)).build();
            return this.responseErrorMapper.generateErrorResponse(responseObject.getError());
        }
        PsuIdData psuData = new PsuIdData(PSU_ID, psUIDType, psUCorporateID, psUCorporateIDType);
        PaymentInitiationParameters paymentInitiationParameters = this.paymentModelMapperPsd2.mapToPaymentRequestParameters(paymentProduct, paymentService, tpPSignatureCertificate, tpPRedirectURI, tpPNokRedirectURI, BooleanUtils.isTrue((Boolean)tpPExplicitAuthorisationPreferred), psuData);
        ResponseObject<PaymentInitiationResponse> serviceResponse = this.xs2aPaymentService.createPayment(body.getBytes(), paymentInitiationParameters);
        if (serviceResponse.hasError()) {
            return this.responseErrorMapper.generateErrorResponse(serviceResponse.getError(), this.paymentInitiationHeadersBuilder.buildErrorInitiatePaymentHeaders());
        }
        PaymentInitiationResponse serviceResponseBody = serviceResponse.getBody();
        ResponseHeaders responseHeaders = this.buildPaymentInitiationResponseHeaders(serviceResponseBody);
        return this.responseMapper.created(ResponseObject.builder().body(this.paymentModelMapperPsd2.mapToPaymentInitiationResponse(serviceResponseBody)).build(), responseHeaders);
    }

    public ResponseEntity cancelPayment(String paymentService, String paymentProduct, String paymentId, UUID xRequestID, String digest, String signature, byte[] tpPSignatureCertificate, Boolean tpPRedirectPreferred, String tpPRedirectURI, String tpPNokRedirectURI, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation, Boolean tppExplicitAuthorisationPreferred) {
        ResponseObject serviceResponse = PaymentType.getByValue((String)paymentService).map(type -> this.xs2aPaymentService.cancelPayment((PaymentType)type, paymentProduct, paymentId, BooleanUtils.isTrue((Boolean)tppExplicitAuthorisationPreferred))).orElseGet(ResponseObject.builder().fail(ErrorType.PIS_400, TppMessageInformation.of(MessageErrorCode.FORMAT_ERROR))::build);
        if (serviceResponse.hasError()) {
            return this.responseErrorMapper.generateErrorResponse(serviceResponse.getError());
        }
        CancelPaymentResponse cancelPayment = (CancelPaymentResponse)serviceResponse.getBody();
        PaymentInitiationCancelResponse202 response = this.paymentModelMapperPsd2.mapToPaymentInitiationCancelResponse(cancelPayment);
        return cancelPayment.isStartAuthorisationRequired() ? this.responseMapper.accepted(ResponseObject.builder().body(response).build()) : this.responseMapper.delete(serviceResponse);
    }

    public ResponseEntity getPaymentCancellationScaStatus(String paymentService, String paymentProduct, String paymentId, String cancellationId, UUID xRequestID, String digest, String signature, byte[] tpPSignatureCertificate, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        ResponseObject<ScaStatus> serviceResponse = this.paymentCancellationAuthorisationService.getPaymentCancellationAuthorisationScaStatus(paymentId, cancellationId);
        return serviceResponse.hasError() ? this.responseErrorMapper.generateErrorResponse(serviceResponse.getError()) : this.responseMapper.ok(serviceResponse, this.authorisationMapper::mapToScaStatusResponse);
    }

    public ResponseEntity getPaymentInitiationAuthorisation(String paymentService, String paymentProduct, String paymentId, UUID xRequestID, String digest, String signature, byte[] tpPSignatureCertificate, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        ResponseObject<Xs2aAuthorisationSubResources> serviceResponse = this.paymentAuthorisationService.getPaymentInitiationAuthorisations(paymentId);
        return serviceResponse.hasError() ? this.responseErrorMapper.generateErrorResponse(serviceResponse.getError()) : this.responseMapper.ok(serviceResponse, this.authorisationMapper::mapToAuthorisations);
    }

    public ResponseEntity getPaymentInitiationCancellationAuthorisationInformation(String paymentService, String paymentProduct, String paymentId, UUID xRequestID, String digest, String signature, byte[] tpPSignatureCertificate, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        ResponseObject<Xs2aPaymentCancellationAuthorisationSubResource> serviceResponse = this.paymentCancellationAuthorisationService.getPaymentInitiationCancellationAuthorisationInformation(paymentId);
        return serviceResponse.hasError() ? this.responseErrorMapper.generateErrorResponse(serviceResponse.getError()) : this.responseMapper.ok(serviceResponse, this.consentModelMapper::mapToCancellations);
    }

    public ResponseEntity getPaymentInitiationScaStatus(String paymentService, String paymentProduct, String paymentId, String authorisationId, UUID xRequestID, String digest, String signature, byte[] tpPSignatureCertificate, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        ResponseObject<ScaStatus> serviceResponse = this.paymentAuthorisationService.getPaymentInitiationAuthorisationScaStatus(paymentId, authorisationId);
        return serviceResponse.hasError() ? this.responseErrorMapper.generateErrorResponse(serviceResponse.getError()) : this.responseMapper.ok(serviceResponse, this.authorisationMapper::mapToScaStatusResponse);
    }

    public ResponseEntity startPaymentAuthorisation(UUID xRequestID, String paymentService, String paymentProduct, String paymentId, Object body, String PSU_ID, String psUIDType, String psUCorporateID, String psUCorporateIDType, Boolean tpPRedirectPreferred, String tpPRedirectURI, String tpPNokRedirectURI, String tpPNotificationURI, String tpPNotificationContentPreferred, String digest, String signature, byte[] tpPSignatureCertificate, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        PsuIdData psuData = new PsuIdData(PSU_ID, psUIDType, psUCorporateID, psUCorporateIDType);
        Xs2aCreatePisAuthorisationRequest createRequest = this.authorisationMapper.mapToXs2aCreatePisAuthorisationRequest(psuData, paymentId, paymentService, paymentProduct, (Map)body);
        ResponseObject<AuthorisationResponse> createAuthResponse = this.paymentAuthorisationService.createPisAuthorisation(createRequest);
        if (createAuthResponse.hasError()) {
            return this.responseErrorMapper.generateErrorResponse(createAuthResponse.getError(), this.paymentInitiationHeadersBuilder.buildErrorStartPaymentAuthorisationHeaders());
        }
        AuthorisationResponse authResponse = createAuthResponse.getBody();
        ResponseHeaders responseHeaders = this.paymentInitiationHeadersBuilder.buildStartPaymentAuthorisationHeaders(authResponse.getAuthorisationId());
        return this.responseMapper.created(ResponseObject.builder().body(this.authorisationMapper.mapToPisCreateOrUpdateAuthorisationResponse(createAuthResponse)).build(), responseHeaders);
    }

    public ResponseEntity startPaymentInitiationCancellationAuthorisation(String paymentService, String paymentProduct, String paymentId, UUID xRequestID, String digest, String signature, byte[] tpPSignatureCertificate, String PSU_ID, String psUIDType, String psUCorporateID, String psUCorporateIDType, Boolean tpPRedirectPreferred, String tpPRedirectURI, String tpPNokRedirectURI, String tpPNotificationURI, String tpPNotificationContentPreferred, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        PsuIdData psuData = new PsuIdData(PSU_ID, psUIDType, psUCorporateID, psUCorporateIDType);
        ResponseObject<Xs2aCreatePisCancellationAuthorisationResponse> serviceResponse = this.paymentCancellationAuthorisationService.createPisCancellationAuthorization(paymentId, psuData, (PaymentType)PaymentType.getByValue((String)paymentService).get(), paymentProduct);
        if (serviceResponse.hasError()) {
            return this.responseErrorMapper.generateErrorResponse(serviceResponse.getError(), this.paymentCancellationHeadersBuilder.buildErrorStartPaymentCancellationAuthorisationHeaders());
        }
        Xs2aCreatePisCancellationAuthorisationResponse body = serviceResponse.getBody();
        ResponseHeaders responseHeaders = this.paymentCancellationHeadersBuilder.buildStartPaymentCancellationAuthorisationHeaders(body.getAuthorisationId());
        return this.responseMapper.created(serviceResponse, this.consentModelMapper::mapToStartScaProcessResponse, responseHeaders);
    }

    public ResponseEntity updatePaymentCancellationPsuData(UUID xRequestID, String paymentService, String paymentProduct, String paymentId, String cancellationId, Object body, String digest, String signature, byte[] tpPSignatureCertificate, String PSU_ID, String psUIDType, String psUCorporateID, String psUCorporateIDType, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        PsuIdData psuData = new PsuIdData(PSU_ID, psUIDType, psUCorporateID, psUCorporateIDType);
        ResponseObject<Xs2aUpdatePisCommonPaymentPsuDataResponse> serviceResponse = this.paymentCancellationAuthorisationService.updatePisCancellationPsuData(this.consentModelMapper.mapToPisUpdatePsuData(psuData, paymentId, cancellationId, paymentService, paymentProduct, (Map)body));
        if (serviceResponse.hasError()) {
            return this.responseErrorMapper.generateErrorResponse(serviceResponse.getError(), this.paymentCancellationHeadersBuilder.buildErrorUpdatePaymentCancellationPsuDataHeaders(cancellationId));
        }
        ResponseHeaders responseHeaders = this.paymentCancellationHeadersBuilder.buildUpdatePaymentCancellationPsuDataHeaders(cancellationId);
        return this.responseMapper.ok(serviceResponse, this.authorisationMapper::mapToPisUpdatePsuAuthenticationResponse, responseHeaders);
    }

    public ResponseEntity updatePaymentPsuData(UUID xRequestID, String paymentService, String paymentProduct, String paymentId, String authorisationId, Object body, String digest, String signature, byte[] tpPSignatureCertificate, String PSU_ID, String psUIDType, String psUCorporateID, String psUCorporateIDType, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        PsuIdData psuData = new PsuIdData(PSU_ID, psUIDType, psUCorporateID, psUCorporateIDType);
        return this.updatePisAuthorisation(psuData, authorisationId, paymentService, paymentProduct, paymentId, body);
    }

    private ResponseEntity updatePisAuthorisation(PsuIdData psuData, String authorisationId, String paymentService, String paymentProduct, String paymentId, Object body) {
        Xs2aUpdatePisCommonPaymentPsuDataRequest request = this.consentModelMapper.mapToPisUpdatePsuData(psuData, paymentId, authorisationId, paymentService, paymentProduct, (Map)body);
        ResponseObject<Xs2aUpdatePisCommonPaymentPsuDataResponse> serviceResponse = this.paymentAuthorisationService.updatePisCommonPaymentPsuData(request);
        if (serviceResponse.hasError()) {
            return this.responseErrorMapper.generateErrorResponse(serviceResponse.getError(), this.paymentInitiationHeadersBuilder.buildErrorUpdatePaymentInitiationPsuDataHeaders(authorisationId));
        }
        ResponseHeaders responseHeaders = this.paymentInitiationHeadersBuilder.buildUpdatePaymentInitiationPsuDataHeaders(authorisationId);
        return this.responseMapper.ok(serviceResponse, this.authorisationMapper::mapToPisUpdatePsuAuthenticationResponse, responseHeaders);
    }

    private ResponseHeaders buildPaymentInitiationResponseHeaders(PaymentInitiationResponse paymentInitiationResponse) {
        return this.paymentInitiationHeadersBuilder.buildInitiatePaymentHeaders(paymentInitiationResponse.getAuthorizationId(), Optional.ofNullable(paymentInitiationResponse.getLinks().getSelf()).map(HrefType::getHref).orElse(null));
    }

    @ConstructorProperties(value={"xs2aPaymentService", "responseMapper", "responseErrorMapper", "paymentModelMapperPsd2", "paymentModelMapperXs2a", "consentModelMapper", "paymentAuthorisationService", "paymentCancellationAuthorisationService", "authorisationMapper", "paymentInitiationHeadersBuilder", "paymentCancellationHeadersBuilder"})
    public PaymentController(PaymentService xs2aPaymentService, ResponseMapper responseMapper, ResponseErrorMapper responseErrorMapper, PaymentModelMapperPsd2 paymentModelMapperPsd2, PaymentModelMapperXs2a paymentModelMapperXs2a, ConsentModelMapper consentModelMapper, PaymentAuthorisationService paymentAuthorisationService, PaymentCancellationAuthorisationService paymentCancellationAuthorisationService, AuthorisationMapper authorisationMapper, PaymentInitiationHeadersBuilder paymentInitiationHeadersBuilder, PaymentCancellationHeadersBuilder paymentCancellationHeadersBuilder) {
        this.xs2aPaymentService = xs2aPaymentService;
        this.responseMapper = responseMapper;
        this.responseErrorMapper = responseErrorMapper;
        this.paymentModelMapperPsd2 = paymentModelMapperPsd2;
        this.paymentModelMapperXs2a = paymentModelMapperXs2a;
        this.consentModelMapper = consentModelMapper;
        this.paymentAuthorisationService = paymentAuthorisationService;
        this.paymentCancellationAuthorisationService = paymentCancellationAuthorisationService;
        this.authorisationMapper = authorisationMapper;
        this.paymentInitiationHeadersBuilder = paymentInitiationHeadersBuilder;
        this.paymentCancellationHeadersBuilder = paymentCancellationHeadersBuilder;
    }
}

