/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator.ais.account;

import de.adorsys.psd2.xs2a.domain.consent.AccountConsent;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.service.validator.ais.AbstractAisTppValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.account.common.AccountAccessValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.account.common.AccountConsentValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.account.common.AccountReferenceAccessValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.account.common.PermittedAccountReferenceValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.account.dto.CommonAccountRequestObject;
import java.beans.ConstructorProperties;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class GetAccountDetailsValidator
extends AbstractAisTppValidator<CommonAccountRequestObject> {
    private final PermittedAccountReferenceValidator permittedAccountReferenceValidator;
    private final AccountConsentValidator accountConsentValidator;
    private final AccountAccessValidator accountAccessValidator;
    private final AccountReferenceAccessValidator accountReferenceAccessValidator;

    @Override
    @NotNull
    protected ValidationResult executeBusinessValidation(CommonAccountRequestObject commonAccountRequestObject) {
        AccountConsent accountConsent = commonAccountRequestObject.getAccountConsent();
        ValidationResult accountReferenceValidationResult = this.accountReferenceAccessValidator.validate(accountConsent.getAccess(), commonAccountRequestObject.getAccounts(), commonAccountRequestObject.getAccountId());
        if (accountReferenceValidationResult.isNotValid()) {
            return accountReferenceValidationResult;
        }
        ValidationResult permittedAccountReferenceValidationResult = this.permittedAccountReferenceValidator.validate(accountConsent, commonAccountRequestObject.getAccountId(), commonAccountRequestObject.isWithBalance());
        if (permittedAccountReferenceValidationResult.isNotValid()) {
            return permittedAccountReferenceValidationResult;
        }
        ValidationResult accountAccessValidationResult = this.accountAccessValidator.validate(commonAccountRequestObject.getAccountConsent(), commonAccountRequestObject.isWithBalance());
        if (accountAccessValidationResult.isNotValid()) {
            return accountAccessValidationResult;
        }
        return this.accountConsentValidator.validate(accountConsent, commonAccountRequestObject.getRequestUri());
    }

    @ConstructorProperties(value={"permittedAccountReferenceValidator", "accountConsentValidator", "accountAccessValidator", "accountReferenceAccessValidator"})
    public GetAccountDetailsValidator(PermittedAccountReferenceValidator permittedAccountReferenceValidator, AccountConsentValidator accountConsentValidator, AccountAccessValidator accountAccessValidator, AccountReferenceAccessValidator accountReferenceAccessValidator) {
        this.permittedAccountReferenceValidator = permittedAccountReferenceValidator;
        this.accountConsentValidator = accountConsentValidator;
        this.accountAccessValidator = accountAccessValidator;
        this.accountReferenceAccessValidator = accountReferenceAccessValidator;
    }
}

