/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.payment;

import de.adorsys.psd2.xs2a.core.consent.AspspConsentData;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aCreatePisCancellationAuthorisationResponse;
import de.adorsys.psd2.xs2a.domain.pis.CancelPaymentResponse;
import de.adorsys.psd2.xs2a.service.PaymentCancellationAuthorisationService;
import de.adorsys.psd2.xs2a.service.authorization.AuthorisationMethodDecider;
import de.adorsys.psd2.xs2a.service.authorization.PaymentCancellationAuthorisationNeededDecider;
import de.adorsys.psd2.xs2a.service.consent.PisAspspDataService;
import de.adorsys.psd2.xs2a.service.context.SpiContextDataProvider;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ErrorType;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ServiceType;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiErrorMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aCancelPaymentMapper;
import de.adorsys.psd2.xs2a.service.payment.Xs2aUpdatePaymentStatusAfterSpiService;
import de.adorsys.psd2.xs2a.spi.domain.SpiContextData;
import de.adorsys.psd2.xs2a.spi.domain.payment.response.SpiPaymentCancellationResponse;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.PaymentCancellationSpi;
import de.adorsys.psd2.xs2a.spi.service.SpiPayment;
import java.beans.ConstructorProperties;
import org.springframework.stereotype.Service;

@Service
public class CancelPaymentService {
    private final PaymentCancellationSpi paymentCancellationSpi;
    private final PisAspspDataService pisAspspDataService;
    private final Xs2aUpdatePaymentStatusAfterSpiService updatePaymentStatusAfterSpiService;
    private final PaymentCancellationAuthorisationNeededDecider cancellationScaNeededDecider;
    private final SpiContextDataProvider spiContextDataProvider;
    private final SpiErrorMapper spiErrorMapper;
    private final SpiToXs2aCancelPaymentMapper spiToXs2aCancelPaymentMapper;
    private final AuthorisationMethodDecider authorisationMethodDecider;
    private final PaymentCancellationAuthorisationService paymentCancellationAuthorisationService;

    public ResponseObject<CancelPaymentResponse> initiatePaymentCancellation(PsuIdData psuData, SpiPayment payment, String encryptedPaymentId, Boolean tppExplicitAuthorisationPreferred) {
        SpiContextData spiContextData = this.spiContextDataProvider.provideWithPsuIdData(psuData);
        AspspConsentData aspspConsentData = this.pisAspspDataService.getAspspConsentData(encryptedPaymentId);
        SpiResponse spiResponse = this.paymentCancellationSpi.initiatePaymentCancellation(spiContextData, payment, aspspConsentData);
        this.pisAspspDataService.updateAspspConsentData(spiResponse.getAspspConsentData());
        if (spiResponse.hasError()) {
            return ResponseObject.builder().fail(this.spiErrorMapper.mapToErrorHolder(spiResponse, ServiceType.PIS)).build();
        }
        CancelPaymentResponse cancelPaymentResponse = this.spiToXs2aCancelPaymentMapper.mapToCancelPaymentResponse((SpiPaymentCancellationResponse)spiResponse.getPayload(), payment, psuData);
        TransactionStatus resultStatus = cancelPaymentResponse.getTransactionStatus();
        if (resultStatus != null) {
            this.updatePaymentStatusAfterSpiService.updatePaymentStatus(encryptedPaymentId, resultStatus);
        } else {
            resultStatus = payment.getPaymentStatus();
            cancelPaymentResponse.setTransactionStatus(resultStatus);
        }
        if (resultStatus == TransactionStatus.CANC) {
            return ResponseObject.builder().body(cancelPaymentResponse).build();
        }
        if (resultStatus.isFinalisedStatus()) {
            return ResponseObject.builder().fail(ErrorType.PIS_CANC_405, TppMessageInformation.of(MessageErrorCode.CANCELLATION_INVALID)).build();
        }
        if (resultStatus == TransactionStatus.RCVD || this.cancellationScaNeededDecider.isNoScaRequired(cancelPaymentResponse.isStartAuthorisationRequired())) {
            payment.setPaymentStatus(resultStatus);
            return this.proceedNoScaCancellation(payment, spiContextData, aspspConsentData, encryptedPaymentId);
        }
        boolean implicitMethod = this.authorisationMethodDecider.isImplicitMethod(tppExplicitAuthorisationPreferred, false);
        if (implicitMethod) {
            ResponseObject<Xs2aCreatePisCancellationAuthorisationResponse> authorizationResponse = this.paymentCancellationAuthorisationService.createPisCancellationAuthorization(encryptedPaymentId, psuData, payment.getPaymentType(), payment.getPaymentProduct());
            if (authorizationResponse.hasError()) {
                return ResponseObject.builder().fail(ErrorType.PIS_CANC_405, TppMessageInformation.of(MessageErrorCode.CANCELLATION_INVALID)).build();
            }
            Xs2aCreatePisCancellationAuthorisationResponse authorisationResponse = authorizationResponse.getBody();
            cancelPaymentResponse.setAuthorizationId(authorisationResponse.getAuthorisationId());
            cancelPaymentResponse.setScaStatus(authorisationResponse.getScaStatus());
        }
        return ResponseObject.builder().body(cancelPaymentResponse).build();
    }

    private ResponseObject<CancelPaymentResponse> proceedNoScaCancellation(SpiPayment payment, SpiContextData spiContextData, AspspConsentData aspspConsentData, String encryptedPaymentId) {
        SpiResponse spiResponse = this.paymentCancellationSpi.cancelPaymentWithoutSca(spiContextData, payment, aspspConsentData);
        this.pisAspspDataService.updateAspspConsentData(spiResponse.getAspspConsentData());
        if (spiResponse.hasError()) {
            return ResponseObject.builder().fail(this.spiErrorMapper.mapToErrorHolder(spiResponse, ServiceType.PIS)).build();
        }
        this.updatePaymentStatusAfterSpiService.updatePaymentStatus(encryptedPaymentId, TransactionStatus.CANC);
        CancelPaymentResponse cancelPaymentResponse = new CancelPaymentResponse();
        cancelPaymentResponse.setTransactionStatus(TransactionStatus.CANC);
        return ResponseObject.builder().body(cancelPaymentResponse).build();
    }

    @ConstructorProperties(value={"paymentCancellationSpi", "pisAspspDataService", "updatePaymentStatusAfterSpiService", "cancellationScaNeededDecider", "spiContextDataProvider", "spiErrorMapper", "spiToXs2aCancelPaymentMapper", "authorisationMethodDecider", "paymentCancellationAuthorisationService"})
    public CancelPaymentService(PaymentCancellationSpi paymentCancellationSpi, PisAspspDataService pisAspspDataService, Xs2aUpdatePaymentStatusAfterSpiService updatePaymentStatusAfterSpiService, PaymentCancellationAuthorisationNeededDecider cancellationScaNeededDecider, SpiContextDataProvider spiContextDataProvider, SpiErrorMapper spiErrorMapper, SpiToXs2aCancelPaymentMapper spiToXs2aCancelPaymentMapper, AuthorisationMethodDecider authorisationMethodDecider, PaymentCancellationAuthorisationService paymentCancellationAuthorisationService) {
        this.paymentCancellationSpi = paymentCancellationSpi;
        this.pisAspspDataService = pisAspspDataService;
        this.updatePaymentStatusAfterSpiService = updatePaymentStatusAfterSpiService;
        this.cancellationScaNeededDecider = cancellationScaNeededDecider;
        this.spiContextDataProvider = spiContextDataProvider;
        this.spiErrorMapper = spiErrorMapper;
        this.spiToXs2aCancelPaymentMapper = spiToXs2aCancelPaymentMapper;
        this.authorisationMethodDecider = authorisationMethodDecider;
        this.paymentCancellationAuthorisationService = paymentCancellationAuthorisationService;
    }
}

