/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers;

import de.adorsys.psd2.xs2a.domain.Transactions;
import de.adorsys.psd2.xs2a.domain.code.BankTransactionCode;
import de.adorsys.psd2.xs2a.domain.code.Xs2aPurposeCode;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aAccountReferenceMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aAmountMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aExchangeRateMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aTransactionMapper;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiTransaction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SpiToXs2aTransactionMapperImpl
implements SpiToXs2aTransactionMapper {
    @Autowired
    private SpiToXs2aAmountMapper spiToXs2aAmountMapper;
    @Autowired
    private SpiToXs2aExchangeRateMapper spiToXs2aExchangeRateMapper;
    @Autowired
    private SpiToXs2aAccountReferenceMapper spiToXs2aAccountReferenceMapper;

    @Override
    public Transactions mapToXs2aTransaction(SpiTransaction spiTransaction) {
        if (spiTransaction == null) {
            return null;
        }
        Transactions transactions = new Transactions();
        transactions.setAmount(this.spiToXs2aAmountMapper.mapToXs2aAmount(spiTransaction.getSpiAmount()));
        transactions.setTransactionId(spiTransaction.getTransactionId());
        transactions.setEntryReference(spiTransaction.getEntryReference());
        transactions.setEndToEndId(spiTransaction.getEndToEndId());
        transactions.setMandateId(spiTransaction.getMandateId());
        transactions.setCheckId(spiTransaction.getCheckId());
        transactions.setCreditorId(spiTransaction.getCreditorId());
        transactions.setBookingDate(spiTransaction.getBookingDate());
        transactions.setValueDate(spiTransaction.getValueDate());
        transactions.setExchangeRate(this.spiToXs2aExchangeRateMapper.mapToExchangeRateList(spiTransaction.getExchangeRate()));
        transactions.setCreditorName(spiTransaction.getCreditorName());
        transactions.setCreditorAccount(this.spiToXs2aAccountReferenceMapper.mapToXs2aAccountReference(spiTransaction.getCreditorAccount()));
        transactions.setUltimateCreditor(spiTransaction.getUltimateCreditor());
        transactions.setDebtorName(spiTransaction.getDebtorName());
        transactions.setDebtorAccount(this.spiToXs2aAccountReferenceMapper.mapToXs2aAccountReference(spiTransaction.getDebtorAccount()));
        transactions.setUltimateDebtor(spiTransaction.getUltimateDebtor());
        transactions.setRemittanceInformationUnstructured(spiTransaction.getRemittanceInformationUnstructured());
        transactions.setRemittanceInformationStructured(spiTransaction.getRemittanceInformationStructured());
        transactions.setProprietaryBankTransactionCode(spiTransaction.getProprietaryBankTransactionCode());
        transactions.setBankTransactionCodeCode(new BankTransactionCode(spiTransaction.getBankTransactionCodeCode()));
        transactions.setPurposeCode(new Xs2aPurposeCode(spiTransaction.getPurposeCode()));
        return transactions;
    }
}

