/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers;

import de.adorsys.psd2.xs2a.domain.pis.SinglePayment;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aAccountReferenceMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aAddressMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aAmountMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aSinglePaymentMapper;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiSinglePayment;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SpiToXs2aSinglePaymentMapperImpl
implements SpiToXs2aSinglePaymentMapper {
    @Autowired
    private SpiToXs2aAccountReferenceMapper spiToXs2aAccountReferenceMapper;
    @Autowired
    private SpiToXs2aAmountMapper spiToXs2aAmountMapper;
    @Autowired
    private SpiToXs2aAddressMapper spiToXs2aAddressMapper;

    @Override
    public SinglePayment mapToXs2aSinglePayment(SpiSinglePayment payment) {
        if (payment == null) {
            return null;
        }
        SinglePayment singlePayment = new SinglePayment();
        singlePayment.setTransactionStatus(payment.getPaymentStatus());
        singlePayment.setPaymentId(payment.getPaymentId());
        singlePayment.setEndToEndIdentification(payment.getEndToEndIdentification());
        singlePayment.setDebtorAccount(this.spiToXs2aAccountReferenceMapper.mapToXs2aAccountReference(payment.getDebtorAccount()));
        singlePayment.setInstructedAmount(this.spiToXs2aAmountMapper.mapToXs2aAmount(payment.getInstructedAmount()));
        singlePayment.setCreditorAccount(this.spiToXs2aAccountReferenceMapper.mapToXs2aAccountReference(payment.getCreditorAccount()));
        singlePayment.setCreditorAgent(payment.getCreditorAgent());
        singlePayment.setCreditorName(payment.getCreditorName());
        singlePayment.setCreditorAddress(this.spiToXs2aAddressMapper.mapToAddress(payment.getCreditorAddress()));
        singlePayment.setRemittanceInformationUnstructured(payment.getRemittanceInformationUnstructured());
        singlePayment.setRequestedExecutionDate(payment.getRequestedExecutionDate());
        singlePayment.setRequestedExecutionTime(payment.getRequestedExecutionTime());
        singlePayment.setStatusChangeTimestamp(payment.getStatusChangeTimestamp());
        return singlePayment;
    }

    @Override
    public List<SinglePayment> mapToXs2aSinglePaymentList(List<SpiSinglePayment> payments) {
        if (payments == null) {
            return new ArrayList<SinglePayment>();
        }
        ArrayList<SinglePayment> list = new ArrayList<SinglePayment>(payments.size());
        for (SpiSinglePayment spiSinglePayment : payments) {
            list.add(this.mapToXs2aSinglePayment(spiSinglePayment));
        }
        return list;
    }
}

