/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper;

import de.adorsys.psd2.model.AccountDetails;
import de.adorsys.psd2.model.AccountList;
import de.adorsys.psd2.model.AccountReference;
import de.adorsys.psd2.model.AccountReport;
import de.adorsys.psd2.model.AccountStatus;
import de.adorsys.psd2.model.Address;
import de.adorsys.psd2.model.Balance;
import de.adorsys.psd2.model.BalanceList;
import de.adorsys.psd2.model.BalanceType;
import de.adorsys.psd2.model.PurposeCode;
import de.adorsys.psd2.model.ReadAccountBalanceResponse200;
import de.adorsys.psd2.model.ReportExchangeRate;
import de.adorsys.psd2.model.ReportExchangeRateList;
import de.adorsys.psd2.model.TransactionDetails;
import de.adorsys.psd2.model.TransactionList;
import de.adorsys.psd2.model.TransactionsResponse200Json;
import de.adorsys.psd2.xs2a.domain.Transactions;
import de.adorsys.psd2.xs2a.domain.Xs2aAmount;
import de.adorsys.psd2.xs2a.domain.Xs2aBalance;
import de.adorsys.psd2.xs2a.domain.Xs2aExchangeRate;
import de.adorsys.psd2.xs2a.domain.account.Xs2aAccountDetails;
import de.adorsys.psd2.xs2a.domain.account.Xs2aAccountDetailsHolder;
import de.adorsys.psd2.xs2a.domain.account.Xs2aAccountListHolder;
import de.adorsys.psd2.xs2a.domain.account.Xs2aAccountReport;
import de.adorsys.psd2.xs2a.domain.account.Xs2aBalancesReport;
import de.adorsys.psd2.xs2a.domain.account.Xs2aTransactionsReport;
import de.adorsys.psd2.xs2a.domain.account.Xs2aUsageType;
import de.adorsys.psd2.xs2a.domain.address.Xs2aAddress;
import de.adorsys.psd2.xs2a.domain.address.Xs2aCountryCode;
import de.adorsys.psd2.xs2a.domain.code.Xs2aPurposeCode;
import de.adorsys.psd2.xs2a.service.mapper.AmountModelMapper;
import de.adorsys.psd2.xs2a.web.mapper.HrefLinkMapper;
import java.beans.ConstructorProperties;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;

@Component
public class AccountModelMapper {
    private static final Logger log = LoggerFactory.getLogger(AccountModelMapper.class);
    private final AmountModelMapper amountModelMapper;
    private final HrefLinkMapper hrefLinkMapper;

    public AccountList mapToAccountList(Xs2aAccountListHolder xs2aAccountListHolder) {
        List<Xs2aAccountDetails> accountDetailsList = xs2aAccountListHolder.getAccountDetails();
        List details = accountDetailsList.stream().map(this::mapToAccountDetails).collect(Collectors.toList());
        return new AccountList().accounts(details);
    }

    public AccountDetails mapToAccountDetails(Xs2aAccountDetailsHolder xs2aAccountDetailsHolder) {
        return this.mapToAccountDetails(xs2aAccountDetailsHolder.getAccountDetails());
    }

    private AccountDetails mapToAccountDetails(Xs2aAccountDetails accountDetails) {
        AccountDetails target = new AccountDetails();
        BeanUtils.copyProperties((Object)accountDetails, (Object)target);
        target.resourceId(accountDetails.getResourceId()).currency(accountDetails.getCurrency() != null ? accountDetails.getCurrency().getCurrencyCode() : null).cashAccountType((String)Optional.ofNullable(accountDetails.getCashAccountType()).map(Enum::name).orElse(null)).usage(this.mapToAccountDetailsUsageEnum(accountDetails.getUsageType())).status(this.mapToAccountStatus(accountDetails.getAccountStatus()));
        return target.balances(this.mapToBalanceList(accountDetails.getBalances()))._links(this.hrefLinkMapper.mapToLinksMap(accountDetails.getLinks()));
    }

    private BalanceList mapToBalanceList(List<Xs2aBalance> balances) {
        BalanceList balanceList = null;
        if (CollectionUtils.isNotEmpty(balances)) {
            balanceList = new BalanceList();
            balanceList.addAll((Collection)balances.stream().map(this::mapToBalance).collect(Collectors.toList()));
        }
        return balanceList;
    }

    private AccountDetails.UsageEnum mapToAccountDetailsUsageEnum(Xs2aUsageType usageType) {
        return Optional.ofNullable(usageType).map(Xs2aUsageType::getValue).map(AccountDetails.UsageEnum::fromValue).orElse(null);
    }

    private AccountStatus mapToAccountStatus(de.adorsys.psd2.xs2a.domain.account.AccountStatus accountStatus) {
        return Optional.ofNullable(accountStatus).map(de.adorsys.psd2.xs2a.domain.account.AccountStatus::getValue).map(AccountStatus::fromValue).orElse(null);
    }

    public ReadAccountBalanceResponse200 mapToBalance(Xs2aBalancesReport balancesReport) {
        BalanceList balanceList = new BalanceList();
        balancesReport.getBalances().forEach(balance -> balanceList.add((Object)this.mapToBalance((Xs2aBalance)balance)));
        return new ReadAccountBalanceResponse200().balances(balanceList).account(this.mapToAccountReference(balancesReport.getXs2aAccountReference()));
    }

    public Balance mapToBalance(Xs2aBalance balance) {
        Balance target = new Balance();
        BeanUtils.copyProperties((Object)balance, (Object)target);
        target.setBalanceAmount(this.amountModelMapper.mapToAmount(balance.getBalanceAmount()));
        Optional.ofNullable(balance.getBalanceType()).ifPresent(balanceType -> target.setBalanceType(BalanceType.fromValue((String)balanceType.getValue())));
        Optional.ofNullable(balance.getLastChangeDateTime()).ifPresent(lastChangeDateTime -> {
            List<ZoneOffset> validOffsets = ZoneId.systemDefault().getRules().getValidOffsets((LocalDateTime)lastChangeDateTime);
            target.setLastChangeDateTime(lastChangeDateTime.atOffset(validOffsets.get(0)));
        });
        return target;
    }

    public AccountReport mapToAccountReport(Xs2aAccountReport accountReport) {
        TransactionList booked = this.mapToTransactionList(accountReport.getBooked());
        TransactionList pending = this.mapToTransactionList(accountReport.getPending());
        return new AccountReport().booked(booked).pending(pending)._links(this.hrefLinkMapper.mapToLinksMap(accountReport.getLinks()));
    }

    public TransactionDetails mapToTransaction(Transactions transactions) {
        TransactionDetails target = new TransactionDetails();
        BeanUtils.copyProperties((Object)transactions, (Object)target);
        target.setCreditorAccount(this.mapToAccountReference(transactions.getCreditorAccount()));
        target.setDebtorAccount(this.mapToAccountReference(transactions.getDebtorAccount()));
        Optional.ofNullable(transactions.getExchangeRate()).ifPresent(xs2aExchangeRates -> {
            ReportExchangeRateList exchangeRates = xs2aExchangeRates.stream().map(this::mapToReportExchangeRate).collect(Collectors.toCollection(ReportExchangeRateList::new));
            target.setCurrencyExchange(exchangeRates);
        });
        Optional.ofNullable(transactions.getAmount()).ifPresent(amount -> target.setTransactionAmount(this.amountModelMapper.mapToAmount((Xs2aAmount)amount)));
        target.setPurposeCode(PurposeCode.fromValue((String)Optional.ofNullable(transactions.getPurposeCode()).map(Xs2aPurposeCode::getCode).orElse(null)));
        Optional.ofNullable(transactions.getBankTransactionCodeCode()).ifPresent(transactionCode -> target.setBankTransactionCode(transactionCode.getCode()));
        return target;
    }

    public AccountReference mapToAccountReference12(de.adorsys.psd2.xs2a.core.profile.AccountReference reference) {
        if (reference == null) {
            return null;
        }
        AccountReference accountReference = new AccountReference();
        accountReference.setIban(reference.getIban());
        accountReference.setBban(reference.getBban());
        if (reference.getCurrency() != null) {
            accountReference.setCurrency(reference.getCurrency().getCurrencyCode());
        }
        accountReference.setMaskedPan(reference.getMaskedPan());
        accountReference.setMsisdn(reference.getMsisdn());
        accountReference.setPan(reference.getPan());
        return accountReference;
    }

    public Address mapToAddress12(Xs2aAddress address) {
        Address targetAddress = new Address().street(address.getStreet());
        targetAddress.setStreet(address.getStreet());
        targetAddress.setBuildingNumber(address.getBuildingNumber());
        targetAddress.setCity(address.getCity());
        targetAddress.setPostalCode(address.getPostalCode());
        targetAddress.setCountry((String)Optional.ofNullable(address.getCountry()).map(Xs2aCountryCode::getCode).orElse(null));
        return targetAddress;
    }

    public TransactionsResponse200Json mapToTransactionsResponse200Json(Xs2aTransactionsReport transactionsReport) {
        TransactionsResponse200Json transactionsResponse200Json = new TransactionsResponse200Json();
        transactionsResponse200Json.setTransactions(this.mapToAccountReport(transactionsReport.getAccountReport()));
        transactionsResponse200Json.setBalances(this.mapToBalanceList(transactionsReport.getBalances()));
        transactionsResponse200Json.setAccount(this.mapToAccountReference12(transactionsReport.getAccountReference()));
        transactionsResponse200Json.setLinks(this.hrefLinkMapper.mapToLinksMap(transactionsReport.getLinks()));
        return transactionsResponse200Json;
    }

    public byte[] mapToTransactionsResponseRaw(Xs2aTransactionsReport transactionsReport) {
        return transactionsReport.getAccountReport().getTransactionsRaw();
    }

    public Map<String, TransactionDetails> mapToTransactionDetails(Transactions transactions) {
        HashMap<String, TransactionDetails> transactionDetails = new HashMap<String, TransactionDetails>();
        transactionDetails.put("transactionsDetails", this.mapToTransaction(transactions));
        return transactionDetails;
    }

    public List<AccountReference> mapToAccountReferences(List<de.adorsys.psd2.xs2a.core.profile.AccountReference> accountReferences) {
        if (CollectionUtils.isEmpty(accountReferences)) {
            return Collections.emptyList();
        }
        return accountReferences.stream().map(this::mapToAccountReference).collect(Collectors.toList());
    }

    public AccountReference mapToAccountReference(de.adorsys.psd2.xs2a.core.profile.AccountReference accountReference) {
        return Optional.ofNullable(accountReference).map(account -> {
            AccountReference reference = new AccountReference();
            reference.setIban(account.getIban());
            reference.setBban(account.getBban());
            if (account.getCurrency() != null) {
                reference.setCurrency(account.getCurrency().getCurrencyCode());
            }
            reference.setMaskedPan(account.getMaskedPan());
            reference.setMsisdn(account.getMsisdn());
            reference.setPan(account.getPan());
            return reference;
        }).orElse(null);
    }

    private ReportExchangeRate mapToReportExchangeRate(Xs2aExchangeRate xs2aExchangeRate) {
        ReportExchangeRate exchangeRate = new ReportExchangeRate();
        exchangeRate.setContractIdentification(xs2aExchangeRate.getContractIdentification());
        exchangeRate.setUnitCurrency(xs2aExchangeRate.getUnitCurrency());
        exchangeRate.setExchangeRate(xs2aExchangeRate.getExchangeRate());
        exchangeRate.setSourceCurrency(xs2aExchangeRate.getSourceCurrency());
        exchangeRate.setTargetCurrency(xs2aExchangeRate.getTargetCurrency());
        exchangeRate.quotationDate(xs2aExchangeRate.getQuotationDate());
        return exchangeRate;
    }

    @Nullable
    private TransactionList mapToTransactionList(@Nullable List<Transactions> transactions) {
        if (CollectionUtils.isEmpty(transactions)) {
            return null;
        }
        List transactionDetails = transactions.stream().map(this::mapToTransaction).collect(Collectors.toList());
        TransactionList transactionList = new TransactionList();
        transactionList.addAll(transactionDetails);
        return transactionList;
    }

    @ConstructorProperties(value={"amountModelMapper", "hrefLinkMapper"})
    public AccountModelMapper(AmountModelMapper amountModelMapper, HrefLinkMapper hrefLinkMapper) {
        this.amountModelMapper = amountModelMapper;
        this.hrefLinkMapper = hrefLinkMapper;
    }
}

