/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.consent;

import de.adorsys.psd2.xs2a.core.profile.AccountReference;
import de.adorsys.psd2.xs2a.domain.account.Xs2aAccountDetails;
import de.adorsys.psd2.xs2a.domain.consent.AccountConsent;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aAccountAccess;
import de.adorsys.psd2.xs2a.service.consent.Xs2aAisConsentService;
import de.adorsys.psd2.xs2a.service.mapper.consent.Xs2aAisConsentMapper;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
public class AccountReferenceInConsentUpdater {
    private final Xs2aAisConsentService aisConsentService;
    private final Xs2aAisConsentMapper consentMapper;

    public void rewriteAccountAccess(@NotNull String consentId, @NotNull Xs2aAccountAccess newAccountAccess) {
        this.aisConsentService.updateAspspAccountAccess(consentId, this.consentMapper.mapToAisAccountAccessInfo(newAccountAccess));
    }

    public Optional<AccountConsent> updateAccountReferences(@NotNull String consentId, @NotNull Xs2aAccountAccess existingAccess, @NotNull List<Xs2aAccountDetails> accountDetails) {
        ArrayList<AccountReference> accounts = new ArrayList<AccountReference>();
        ArrayList<AccountReference> transactions = new ArrayList<AccountReference>();
        ArrayList<AccountReference> balances = new ArrayList<AccountReference>();
        for (Xs2aAccountDetails accountDetail : accountDetails) {
            accounts.addAll(this.enrichAccountReferences(accountDetail, existingAccess.getAccounts()));
            balances.addAll(this.enrichAccountReferences(accountDetail, existingAccess.getBalances()));
            transactions.addAll(this.enrichAccountReferences(accountDetail, existingAccess.getTransactions()));
        }
        Xs2aAccountAccess xs2aAccountAccess = new Xs2aAccountAccess(accounts, balances, transactions, existingAccess.getAvailableAccounts(), existingAccess.getAllPsd2(), existingAccess.getAvailableAccountsWithBalances());
        return this.aisConsentService.updateAspspAccountAccess(consentId, this.consentMapper.mapToAisAccountAccessInfo(xs2aAccountAccess));
    }

    private List<AccountReference> enrichAccountReferences(Xs2aAccountDetails xs2aAccountDetails, List<AccountReference> accountReferenceList) {
        return accountReferenceList.stream().filter(ar -> ar.getUsedAccountReferenceSelector().equals((Object)xs2aAccountDetails.getAccountSelector())).map(ar -> new AccountReference(ar.getUsedAccountReferenceSelector().getAccountReferenceType(), ar.getUsedAccountReferenceSelector().getAccountValue(), ar.getCurrency(), xs2aAccountDetails.getResourceId(), xs2aAccountDetails.getAspspAccountId())).collect(Collectors.toList());
    }

    @ConstructorProperties(value={"aisConsentService", "consentMapper"})
    public AccountReferenceInConsentUpdater(Xs2aAisConsentService aisConsentService, Xs2aAisConsentMapper consentMapper) {
        this.aisConsentService = aisConsentService;
        this.consentMapper = consentMapper;
    }
}

