/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.authorization.ais.stage;

import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import de.adorsys.psd2.xs2a.domain.consent.AccountConsentAuthorization;
import de.adorsys.psd2.xs2a.domain.consent.UpdateConsentPsuDataReq;
import de.adorsys.psd2.xs2a.domain.consent.UpdateConsentPsuDataResponse;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.service.consent.AisConsentDataService;
import de.adorsys.psd2.xs2a.service.consent.Xs2aAisConsentService;
import de.adorsys.psd2.xs2a.service.mapper.consent.Xs2aAisConsentMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiErrorMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aAuthenticationObjectMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.Xs2aToSpiPsuDataMapper;
import de.adorsys.psd2.xs2a.spi.service.AisConsentSpi;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

public abstract class AisScaStage<T, R>
implements Function<T, R> {
    protected final Xs2aAisConsentService aisConsentService;
    protected final AisConsentDataService aisConsentDataService;
    protected final AisConsentSpi aisConsentSpi;
    protected final Xs2aAisConsentMapper aisConsentMapper;
    protected final Xs2aToSpiPsuDataMapper psuDataMapper;
    protected final SpiToXs2aAuthenticationObjectMapper spiToXs2aAuthenticationObjectMapper;
    protected final SpiErrorMapper spiErrorMapper;

    protected UpdateConsentPsuDataResponse createFailedResponse(MessageError messageError, List<String> messages, UpdateConsentPsuDataReq updateConsentPsuDataReq) {
        UpdateConsentPsuDataResponse response = new UpdateConsentPsuDataResponse(ScaStatus.FAILED, updateConsentPsuDataReq.getConsentId(), updateConsentPsuDataReq.getAuthorizationId());
        response.setMessageError(messageError);
        response.setPsuMessage(this.buildPsuMessage(messages));
        return response;
    }

    private String buildPsuMessage(List<String> messages) {
        return String.join((CharSequence)", ", messages);
    }

    protected PsuIdData extractPsuIdData(UpdateConsentPsuDataReq request) {
        PsuIdData psuDataInRequest = request.getPsuData();
        if (this.isPsuExist(psuDataInRequest)) {
            return psuDataInRequest;
        }
        return this.aisConsentService.getAccountConsentAuthorizationById(request.getAuthorizationId(), request.getConsentId()).map(AccountConsentAuthorization::getPsuIdData).orElse(psuDataInRequest);
    }

    protected boolean isPsuExist(PsuIdData psuIdData) {
        return Optional.ofNullable(psuIdData).map(PsuIdData::isNotEmpty).orElse(false);
    }

    @ConstructorProperties(value={"aisConsentService", "aisConsentDataService", "aisConsentSpi", "aisConsentMapper", "psuDataMapper", "spiToXs2aAuthenticationObjectMapper", "spiErrorMapper"})
    public AisScaStage(Xs2aAisConsentService aisConsentService, AisConsentDataService aisConsentDataService, AisConsentSpi aisConsentSpi, Xs2aAisConsentMapper aisConsentMapper, Xs2aToSpiPsuDataMapper psuDataMapper, SpiToXs2aAuthenticationObjectMapper spiToXs2aAuthenticationObjectMapper, SpiErrorMapper spiErrorMapper) {
        this.aisConsentService = aisConsentService;
        this.aisConsentDataService = aisConsentDataService;
        this.aisConsentSpi = aisConsentSpi;
        this.aisConsentMapper = aisConsentMapper;
        this.psuDataMapper = psuDataMapper;
        this.spiToXs2aAuthenticationObjectMapper = spiToXs2aAuthenticationObjectMapper;
        this.spiErrorMapper = spiErrorMapper;
    }
}

