/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.authorization;

import de.adorsys.psd2.xs2a.core.profile.StartAuthorisationMode;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import java.beans.ConstructorProperties;
import org.springframework.stereotype.Service;

@Service
public class AuthorisationMethodDecider {
    private final AspspProfileServiceWrapper aspspProfileService;

    public boolean isExplicitMethod(boolean tppExplicitAuthorisationPreferred, boolean multilevelScaRequired) {
        StartAuthorisationMode startAuthorisationMode = this.aspspProfileService.getStartAuthorisationMode();
        if (StartAuthorisationMode.AUTO.equals((Object)startAuthorisationMode)) {
            return multilevelScaRequired || this.isSigningBasketModeActive(tppExplicitAuthorisationPreferred);
        }
        return StartAuthorisationMode.EXPLICIT.equals((Object)startAuthorisationMode);
    }

    public boolean isImplicitMethod(boolean tppExplicitAuthorisationPreferred, boolean multilevelScaRequired) {
        return !this.isExplicitMethod(tppExplicitAuthorisationPreferred, multilevelScaRequired);
    }

    public boolean isSigningBasketModeActive(boolean tppExplicitAuthorisationPreferred) {
        return tppExplicitAuthorisationPreferred && this.aspspProfileService.isSigningBasketSupported();
    }

    @ConstructorProperties(value={"aspspProfileService"})
    public AuthorisationMethodDecider(AspspProfileServiceWrapper aspspProfileService) {
        this.aspspProfileService = aspspProfileService;
    }
}

