/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.domain;

import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ErrorType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public class ErrorHolder {
    private final List<TppMessageInformation> tppMessageInformationList;
    private final ErrorType errorType;

    private ErrorHolder(ErrorHolderBuilder builder) {
        this.tppMessageInformationList = builder.tppMessageInformationList;
        this.errorType = builder.errorType;
    }

    @Deprecated
    public String getMessage() {
        return this.tppMessageInformationList.stream().map(TppMessageInformation::getText).collect(Collectors.joining(", "));
    }

    @Deprecated
    public MessageErrorCode getErrorCode() {
        return this.getFirstTppMessage().getMessageErrorCode();
    }

    public ErrorType getErrorType() {
        return this.errorType;
    }

    public List<TppMessageInformation> getTppMessageInformationList() {
        return this.tppMessageInformationList;
    }

    public static ErrorHolderBuilder builder(ErrorType errorType) {
        return new ErrorHolderBuilder(errorType);
    }

    @Deprecated
    public static ErrorHolderBuilder builder(MessageErrorCode errorCode) {
        return new ErrorHolderBuilder(errorCode);
    }

    private TppMessageInformation getFirstTppMessage() {
        return this.tppMessageInformationList.get(0);
    }

    public static class ErrorHolderBuilder {
        private List<TppMessageInformation> tppMessageInformationList = new ArrayList<TppMessageInformation>();
        private ErrorType errorType;
        private List<String> messages;
        private MessageErrorCode errorCode;

        private ErrorHolderBuilder(ErrorType errorType) {
            this.errorType = errorType;
        }

        private ErrorHolderBuilder(MessageErrorCode errorCode) {
            this.errorCode = errorCode;
        }

        @Deprecated
        public ErrorHolderBuilder messages(List<String> messages) {
            this.messages = messages;
            return this;
        }

        public ErrorHolderBuilder tppMessages(TppMessageInformation ... tppMessages) {
            this.tppMessageInformationList = Arrays.asList(tppMessages);
            return this;
        }

        @Deprecated
        public ErrorHolderBuilder errorType(ErrorType errorType) {
            this.errorType = errorType;
            return this;
        }

        public ErrorHolder build() {
            if (this.tppMessageInformationList.isEmpty()) {
                this.tppMessageInformationList = this.generateTppMessages(this.messages);
            }
            return new ErrorHolder(this);
        }

        @Deprecated
        private List<TppMessageInformation> generateTppMessages(List<String> messages) {
            if (CollectionUtils.isEmpty(messages)) {
                return Collections.singletonList(TppMessageInformation.of(this.errorCode));
            }
            return messages.stream().map(m -> TppMessageInformation.of(this.errorCode, m)).collect(Collectors.toList());
        }
    }
}

