package de.adorsys.psd2.xs2a.web.mapper;

import de.adorsys.psd2.model.AccountReference;
import de.adorsys.psd2.model.Amount;
import de.adorsys.psd2.model.BulkPaymentInitiationJson;
import de.adorsys.psd2.model.DayOfExecution;
import de.adorsys.psd2.model.ExecutionRule;
import de.adorsys.psd2.model.FrequencyCode;
import de.adorsys.psd2.model.PaymentInitiationBulkElementJson;
import de.adorsys.psd2.model.PaymentInitiationJson;
import de.adorsys.psd2.model.PeriodicPaymentInitiationJson;
import de.adorsys.psd2.xs2a.core.pis.PisDayOfExecution;
import de.adorsys.psd2.xs2a.core.pis.PisExecutionRule;
import de.adorsys.psd2.xs2a.domain.Xs2aAmount;
import de.adorsys.psd2.xs2a.domain.code.Xs2aFrequencyCode;
import de.adorsys.psd2.xs2a.domain.pis.BulkPayment;
import de.adorsys.psd2.xs2a.domain.pis.PeriodicPayment;
import de.adorsys.psd2.xs2a.domain.pis.SinglePayment;
import java.util.ArrayList;
import java.util.Currency;
import java.util.List;
import javax.annotation.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2019-06-07T07:06:51+0000",
    comments = "version: 1.3.0.Final, compiler: javac, environment: Java 1.8.0_151 (Oracle Corporation)"
)
@Component
public class PaymentModelMapperImpl implements PaymentModelMapper {

    @Autowired
    private Xs2aAddressMapper xs2aAddressMapper;

    @Override
    public PeriodicPayment mapToXs2aPayment(PeriodicPaymentInitiationJson paymentRequest) {
        if ( paymentRequest == null ) {
            return null;
        }

        PeriodicPayment periodicPayment = new PeriodicPayment();

        periodicPayment.setEndToEndIdentification( paymentRequest.getEndToEndIdentification() );
        periodicPayment.setDebtorAccount( mapToAccountReference( paymentRequest.getDebtorAccount() ) );
        periodicPayment.setInstructedAmount( mapToXs2aAmount( paymentRequest.getInstructedAmount() ) );
        periodicPayment.setCreditorAccount( mapToAccountReference( paymentRequest.getCreditorAccount() ) );
        periodicPayment.setCreditorAgent( paymentRequest.getCreditorAgent() );
        periodicPayment.setCreditorName( paymentRequest.getCreditorName() );
        periodicPayment.setCreditorAddress( xs2aAddressMapper.mapToXs2aAddress( paymentRequest.getCreditorAddress() ) );
        periodicPayment.setRemittanceInformationUnstructured( paymentRequest.getRemittanceInformationUnstructured() );
        periodicPayment.setStartDate( paymentRequest.getStartDate() );
        periodicPayment.setExecutionRule( executionRuleToPisExecutionRule( paymentRequest.getExecutionRule() ) );
        periodicPayment.setEndDate( paymentRequest.getEndDate() );
        periodicPayment.setFrequency( frequencyCodeToXs2aFrequencyCode( paymentRequest.getFrequency() ) );
        periodicPayment.setDayOfExecution( dayOfExecutionToPisDayOfExecution( paymentRequest.getDayOfExecution() ) );

        return periodicPayment;
    }

    @Override
    public SinglePayment mapToXs2aPayment(PaymentInitiationJson paymentRequest) {
        if ( paymentRequest == null ) {
            return null;
        }

        SinglePayment singlePayment = new SinglePayment();

        singlePayment.setEndToEndIdentification( paymentRequest.getEndToEndIdentification() );
        singlePayment.setDebtorAccount( mapToAccountReference( paymentRequest.getDebtorAccount() ) );
        singlePayment.setInstructedAmount( mapToXs2aAmount( paymentRequest.getInstructedAmount() ) );
        singlePayment.setCreditorAccount( mapToAccountReference( paymentRequest.getCreditorAccount() ) );
        singlePayment.setCreditorAgent( paymentRequest.getCreditorAgent() );
        singlePayment.setCreditorName( paymentRequest.getCreditorName() );
        singlePayment.setCreditorAddress( xs2aAddressMapper.mapToXs2aAddress( paymentRequest.getCreditorAddress() ) );
        singlePayment.setRemittanceInformationUnstructured( paymentRequest.getRemittanceInformationUnstructured() );
        singlePayment.setRequestedExecutionDate( paymentRequest.getRequestedExecutionDate() );

        return singlePayment;
    }

    @Override
    public BulkPayment mapToXs2aPayment(BulkPaymentInitiationJson paymentRequest) {
        if ( paymentRequest == null ) {
            return null;
        }

        BulkPayment bulkPayment = new BulkPayment();

        bulkPayment.setBatchBookingPreferred( paymentRequest.getBatchBookingPreferred() );
        bulkPayment.setDebtorAccount( mapToAccountReference( paymentRequest.getDebtorAccount() ) );
        bulkPayment.setRequestedExecutionDate( paymentRequest.getRequestedExecutionDate() );
        bulkPayment.setRequestedExecutionTime( paymentRequest.getRequestedExecutionTime() );
        bulkPayment.setPayments( paymentInitiationBulkElementJsonListToSinglePaymentList( paymentRequest.getPayments() ) );

        mapToXs2aPaymentAfterMapping( paymentRequest, bulkPayment );

        return bulkPayment;
    }

    @Override
    public Xs2aAmount mapToXs2aAmount(Amount amount) {
        if ( amount == null ) {
            return null;
        }

        Xs2aAmount xs2aAmount = new Xs2aAmount();

        if ( amount.getCurrency() != null ) {
            xs2aAmount.setCurrency( Currency.getInstance( amount.getCurrency() ) );
        }
        xs2aAmount.setAmount( amount.getAmount() );

        return xs2aAmount;
    }

    @Override
    public de.adorsys.psd2.xs2a.core.profile.AccountReference mapToAccountReference(AccountReference accountReference) {
        if ( accountReference == null ) {
            return null;
        }

        de.adorsys.psd2.xs2a.core.profile.AccountReference accountReference1 = new de.adorsys.psd2.xs2a.core.profile.AccountReference();

        accountReference1.setIban( accountReference.getIban() );
        accountReference1.setBban( accountReference.getBban() );
        accountReference1.setPan( accountReference.getPan() );
        accountReference1.setMaskedPan( accountReference.getMaskedPan() );
        accountReference1.setMsisdn( accountReference.getMsisdn() );
        if ( accountReference.getCurrency() != null ) {
            accountReference1.setCurrency( Currency.getInstance( accountReference.getCurrency() ) );
        }

        return accountReference1;
    }

    protected PisExecutionRule executionRuleToPisExecutionRule(ExecutionRule executionRule) {
        if ( executionRule == null ) {
            return null;
        }

        PisExecutionRule pisExecutionRule;

        switch ( executionRule ) {
            case FOLLOWING: pisExecutionRule = PisExecutionRule.FOLLOWING;
            break;
            case PRECEDING: pisExecutionRule = PisExecutionRule.PRECEDING;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + executionRule );
        }

        return pisExecutionRule;
    }

    protected Xs2aFrequencyCode frequencyCodeToXs2aFrequencyCode(FrequencyCode frequencyCode) {
        if ( frequencyCode == null ) {
            return null;
        }

        Xs2aFrequencyCode xs2aFrequencyCode;

        switch ( frequencyCode ) {
            case DAILY: xs2aFrequencyCode = Xs2aFrequencyCode.DAILY;
            break;
            case WEEKLY: xs2aFrequencyCode = Xs2aFrequencyCode.WEEKLY;
            break;
            case EVERYTWOWEEKS: xs2aFrequencyCode = Xs2aFrequencyCode.EVERYTWOWEEKS;
            break;
            case MONTHLY: xs2aFrequencyCode = Xs2aFrequencyCode.MONTHLY;
            break;
            case EVERYTWOMONTHS: xs2aFrequencyCode = Xs2aFrequencyCode.EVERYTWOMONTHS;
            break;
            case QUARTERLY: xs2aFrequencyCode = Xs2aFrequencyCode.QUARTERLY;
            break;
            case SEMIANNUAL: xs2aFrequencyCode = Xs2aFrequencyCode.SEMIANNUAL;
            break;
            case ANNUAL: xs2aFrequencyCode = Xs2aFrequencyCode.ANNUAL;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + frequencyCode );
        }

        return xs2aFrequencyCode;
    }

    protected PisDayOfExecution dayOfExecutionToPisDayOfExecution(DayOfExecution dayOfExecution) {
        if ( dayOfExecution == null ) {
            return null;
        }

        PisDayOfExecution pisDayOfExecution;

        switch ( dayOfExecution ) {
            case _1: pisDayOfExecution = PisDayOfExecution._1;
            break;
            case _2: pisDayOfExecution = PisDayOfExecution._2;
            break;
            case _3: pisDayOfExecution = PisDayOfExecution._3;
            break;
            case _4: pisDayOfExecution = PisDayOfExecution._4;
            break;
            case _5: pisDayOfExecution = PisDayOfExecution._5;
            break;
            case _6: pisDayOfExecution = PisDayOfExecution._6;
            break;
            case _7: pisDayOfExecution = PisDayOfExecution._7;
            break;
            case _8: pisDayOfExecution = PisDayOfExecution._8;
            break;
            case _9: pisDayOfExecution = PisDayOfExecution._9;
            break;
            case _10: pisDayOfExecution = PisDayOfExecution._10;
            break;
            case _11: pisDayOfExecution = PisDayOfExecution._11;
            break;
            case _12: pisDayOfExecution = PisDayOfExecution._12;
            break;
            case _13: pisDayOfExecution = PisDayOfExecution._13;
            break;
            case _14: pisDayOfExecution = PisDayOfExecution._14;
            break;
            case _15: pisDayOfExecution = PisDayOfExecution._15;
            break;
            case _16: pisDayOfExecution = PisDayOfExecution._16;
            break;
            case _17: pisDayOfExecution = PisDayOfExecution._17;
            break;
            case _18: pisDayOfExecution = PisDayOfExecution._18;
            break;
            case _19: pisDayOfExecution = PisDayOfExecution._19;
            break;
            case _20: pisDayOfExecution = PisDayOfExecution._20;
            break;
            case _21: pisDayOfExecution = PisDayOfExecution._21;
            break;
            case _22: pisDayOfExecution = PisDayOfExecution._22;
            break;
            case _23: pisDayOfExecution = PisDayOfExecution._23;
            break;
            case _24: pisDayOfExecution = PisDayOfExecution._24;
            break;
            case _25: pisDayOfExecution = PisDayOfExecution._25;
            break;
            case _26: pisDayOfExecution = PisDayOfExecution._26;
            break;
            case _27: pisDayOfExecution = PisDayOfExecution._27;
            break;
            case _28: pisDayOfExecution = PisDayOfExecution._28;
            break;
            case _29: pisDayOfExecution = PisDayOfExecution._29;
            break;
            case _30: pisDayOfExecution = PisDayOfExecution._30;
            break;
            case _31: pisDayOfExecution = PisDayOfExecution._31;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + dayOfExecution );
        }

        return pisDayOfExecution;
    }

    protected SinglePayment paymentInitiationBulkElementJsonToSinglePayment(PaymentInitiationBulkElementJson paymentInitiationBulkElementJson) {
        if ( paymentInitiationBulkElementJson == null ) {
            return null;
        }

        SinglePayment singlePayment = new SinglePayment();

        singlePayment.setEndToEndIdentification( paymentInitiationBulkElementJson.getEndToEndIdentification() );
        singlePayment.setInstructedAmount( mapToXs2aAmount( paymentInitiationBulkElementJson.getInstructedAmount() ) );
        singlePayment.setCreditorAccount( mapToAccountReference( paymentInitiationBulkElementJson.getCreditorAccount() ) );
        singlePayment.setCreditorAgent( paymentInitiationBulkElementJson.getCreditorAgent() );
        singlePayment.setCreditorName( paymentInitiationBulkElementJson.getCreditorName() );
        singlePayment.setCreditorAddress( xs2aAddressMapper.mapToXs2aAddress( paymentInitiationBulkElementJson.getCreditorAddress() ) );
        singlePayment.setRemittanceInformationUnstructured( paymentInitiationBulkElementJson.getRemittanceInformationUnstructured() );

        return singlePayment;
    }

    protected List<SinglePayment> paymentInitiationBulkElementJsonListToSinglePaymentList(List<PaymentInitiationBulkElementJson> list) {
        if ( list == null ) {
            return null;
        }

        List<SinglePayment> list1 = new ArrayList<SinglePayment>( list.size() );
        for ( PaymentInitiationBulkElementJson paymentInitiationBulkElementJson : list ) {
            list1.add( paymentInitiationBulkElementJsonToSinglePayment( paymentInitiationBulkElementJson ) );
        }

        return list1;
    }
}
