/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.validator.body.consent;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.psd2.model.AccountAccess;
import de.adorsys.psd2.model.Consents;
import de.adorsys.psd2.xs2a.component.JsonConverter;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.web.validator.ErrorBuildingService;
import de.adorsys.psd2.xs2a.web.validator.body.AbstractBodyValidatorImpl;
import de.adorsys.psd2.xs2a.web.validator.body.consent.ConsentBodyValidator;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDate;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.servlet.http.HttpServletRequest;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConsentBodyFieldsValidatorImpl
extends AbstractBodyValidatorImpl
implements ConsentBodyValidator {
    private static final String ACCESS_FIELD_NAME = "access";
    private static final String ALL_PSD2_FIELD_NAME = "allPsd2";
    private static final String AVAILABLE_ACCOUNTS_FIELD_NAME = "availableAccounts";
    private static final String ALL_PSD2_WRONG_VALUE_ERROR = "Wrong value for allPsd2";
    private static final String AVAILABLE_ACCOUNTS_WRONG_VALUE_ERROR = "Wrong value for availableAccounts";
    private static final String BODY_DESERIALIZATION_ERROR = "Cannot deserialize the request body";
    private final JsonConverter jsonConverter;

    @Autowired
    public ConsentBodyFieldsValidatorImpl(ErrorBuildingService errorBuildingService, ObjectMapper objectMapper, JsonConverter jsonConverter) {
        super(errorBuildingService, objectMapper);
        this.jsonConverter = jsonConverter;
    }

    @Override
    public void validate(HttpServletRequest request, MessageError messageError) {
        this.validateRawAccess(request, messageError);
        Optional<Consents> consentsOptional = this.mapBodyToInstance(request, messageError, Consents.class);
        if (!consentsOptional.isPresent()) {
            return;
        }
        Consents consents = consentsOptional.get();
        if (Objects.isNull(consents.getRecurringIndicator())) {
            this.errorBuildingService.enrichMessageError(messageError, "Value 'recurringIndicator' should not be null");
        }
        if (Objects.isNull(consents.getValidUntil())) {
            this.errorBuildingService.enrichMessageError(messageError, "Value 'validUntil' should not be null");
        } else {
            this.validateValidUntil(consents.getValidUntil(), messageError);
        }
        if (Objects.isNull(consents.getFrequencyPerDay())) {
            this.errorBuildingService.enrichMessageError(messageError, "Value 'frequencyPerDay' should not be null");
        } else {
            this.validateFrequencyPerDay(consents.getFrequencyPerDay(), messageError);
        }
    }

    private void validateValidUntil(LocalDate validUntil, MessageError messageError) {
        if (validUntil.isBefore(LocalDate.now())) {
            this.errorBuildingService.enrichMessageError(messageError, "Value 'validUntil' should not be in the past");
        }
    }

    private void validateFrequencyPerDay(Integer frequencyPerDay, MessageError messageError) {
        if (frequencyPerDay < 1) {
            this.errorBuildingService.enrichMessageError(messageError, "Value 'frequencyPerDay' should not be lower than 1");
        }
    }

    private void validateRawAccess(HttpServletRequest request, MessageError messageError) {
        Map<String, Object> access = this.extractConsentAccessMap(request, messageError);
        Object allPsd2 = access.get(ALL_PSD2_FIELD_NAME);
        this.validateEnumValue(allPsd2, AccountAccess.AllPsd2Enum::fromValue, messageError, ALL_PSD2_WRONG_VALUE_ERROR);
        Object availableAccounts = access.get(AVAILABLE_ACCOUNTS_FIELD_NAME);
        this.validateEnumValue(availableAccounts, AccountAccess.AvailableAccountsEnum::fromValue, messageError, AVAILABLE_ACCOUNTS_WRONG_VALUE_ERROR);
    }

    private void validateEnumValue(Object value, Function<String, Enum> mapperToEnum, MessageError messageError, String errorText) {
        if (value == null || this.isValidEnumValue(value, mapperToEnum)) {
            return;
        }
        this.errorBuildingService.enrichMessageError(messageError, errorText);
    }

    private boolean isValidEnumValue(@NotNull Object value, Function<String, Enum> mapperToEnum) {
        return value instanceof String && mapperToEnum.apply((String)value) != null;
    }

    private Map<String, Object> extractConsentAccessMap(HttpServletRequest request, MessageError messageError) {
        Optional<Map<Object, Object>> access = Optional.empty();
        try {
            access = this.jsonConverter.toJsonField((InputStream)request.getInputStream(), ACCESS_FIELD_NAME, new TypeReference<Map<String, Object>>(){});
        }
        catch (IOException e) {
            this.errorBuildingService.enrichMessageError(messageError, BODY_DESERIALIZATION_ERROR);
        }
        return access.orElseGet(Collections::emptyMap);
    }
}

