/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.validator.body.consent;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.psd2.model.AccountAccess;
import de.adorsys.psd2.model.AccountReference;
import de.adorsys.psd2.model.Consents;
import de.adorsys.psd2.xs2a.core.ais.AccountAccessType;
import de.adorsys.psd2.xs2a.domain.consent.CreateConsentReq;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aAccountAccess;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.web.validator.ErrorBuildingService;
import de.adorsys.psd2.xs2a.web.validator.body.AbstractBodyValidatorImpl;
import de.adorsys.psd2.xs2a.web.validator.body.consent.ConsentBodyValidator;
import java.util.Collection;
import java.util.Collections;
import java.util.Currency;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.validator.routines.IBANValidator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AccountAccessValidatorImpl
extends AbstractBodyValidatorImpl
implements ConsentBodyValidator {
    @Autowired
    public AccountAccessValidatorImpl(ErrorBuildingService errorBuildingService, ObjectMapper objectMapper) {
        super(errorBuildingService, objectMapper);
    }

    @Override
    public void validate(HttpServletRequest request, MessageError messageError) {
        Optional<Consents> consentsOptional = this.mapBodyToInstance(request, messageError, Consents.class);
        if (!consentsOptional.isPresent()) {
            return;
        }
        Consents consents = consentsOptional.get();
        if (Objects.isNull(consents.getAccess())) {
            this.errorBuildingService.enrichMessageError(messageError, "Value 'access' should not be null");
        } else {
            this.validateAccountAccess(consents, messageError);
        }
    }

    private void validateAccountAccess(Consents consents, MessageError messageError) {
        AccountAccess accountAccess = consents.getAccess();
        if (Objects.nonNull(accountAccess.getAccounts())) {
            Stream allReferences = Stream.of(accountAccess.getAccounts(), accountAccess.getBalances(), accountAccess.getTransactions()).filter(Objects::nonNull).flatMap(Collection::stream);
            allReferences.distinct().filter(Objects::nonNull).forEach(ar -> this.validateAccountReference((AccountReference)ar, messageError));
            CreateConsentReq createConsent = this.mapToCreateConsentReq(consents, messageError);
            if (this.areFlagsAndAccountsInvalid(createConsent)) {
                this.errorBuildingService.enrichMessageError(messageError, "Consent object can not contain both list of accounts and the flag allPsd2 or availableAccounts");
            }
        }
    }

    private boolean areFlagsAndAccountsInvalid(CreateConsentReq request) {
        Xs2aAccountAccess access = request.getAccess();
        if (access.isNotEmpty()) {
            return !CollectionUtils.isEmpty(request.getAccountReferences()) && !this.areFlagsEmpty(access);
        }
        return false;
    }

    private boolean areFlagsEmpty(Xs2aAccountAccess access) {
        return Objects.isNull(access.getAvailableAccounts()) && Objects.isNull(access.getAllPsd2());
    }

    private void validateAccountReference(AccountReference accountReference, MessageError messageError) {
        if (StringUtils.isNotBlank((CharSequence)accountReference.getIban()) && !this.isValidIban(accountReference.getIban())) {
            this.errorBuildingService.enrichMessageError(messageError, "Invalid IBAN format");
        }
        if (StringUtils.isNotBlank((CharSequence)accountReference.getBban()) && !this.isValidBban(accountReference.getBban())) {
            this.errorBuildingService.enrichMessageError(messageError, "Invalid BBAN format");
        }
        this.checkOptionalFieldForMaxLength(accountReference.getPan(), "PAN", 35, messageError);
        this.checkOptionalFieldForMaxLength(accountReference.getMaskedPan(), "Masked PAN", 35, messageError);
        this.checkOptionalFieldForMaxLength(accountReference.getMsisdn(), "MSISDN", 35, messageError);
        if (Objects.nonNull(accountReference.getCurrency())) {
            this.validateCurrency(accountReference.getCurrency(), messageError);
        }
    }

    private void validateCurrency(String currency, MessageError messageError) {
        if (!this.isValidCurrency(currency)) {
            this.errorBuildingService.enrichMessageError(messageError, "Invalid currency code format");
        }
    }

    private boolean isValidIban(String iban) {
        IBANValidator validator = IBANValidator.getInstance();
        return validator.isValid(iban);
    }

    private boolean isValidBban(String bban) {
        return this.normalizeString(bban).length() >= 11 && this.normalizeString(bban).length() <= 28;
    }

    private boolean isValidCurrency(String currency) {
        try {
            Currency.getInstance(currency);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    private String normalizeString(String string) {
        return string.replaceAll("[^a-zA-Z0-9]", "");
    }

    private CreateConsentReq mapToCreateConsentReq(Consents consent, MessageError messageError) {
        return Optional.ofNullable(consent).map(cnst -> {
            CreateConsentReq createAisConsentRequest = new CreateConsentReq();
            createAisConsentRequest.setAccess(this.mapToAccountAccessInner(cnst.getAccess(), messageError));
            return createAisConsentRequest;
        }).orElse(null);
    }

    private Xs2aAccountAccess mapToAccountAccessInner(AccountAccess accountAccess, MessageError messageError) {
        return Optional.ofNullable(accountAccess).map(acs -> new Xs2aAccountAccess(this.mapToXs2aAccountReferences(acs.getAccounts(), messageError), this.mapToXs2aAccountReferences(acs.getBalances(), messageError), this.mapToXs2aAccountReferences(acs.getTransactions(), messageError), this.mapToAccountAccessTypeFromAvailableAccounts(acs.getAvailableAccounts()), this.mapToAccountAccessTypeFromAllPsd2Enum(acs.getAllPsd2()))).orElse(null);
    }

    private List<de.adorsys.psd2.xs2a.core.profile.AccountReference> mapToXs2aAccountReferences(List<AccountReference> references, MessageError messageError) {
        return Optional.ofNullable(references).map(ref -> ref.stream().map(reference -> this.mapToAccountReference(reference, messageError)).collect(Collectors.toList())).orElseGet(Collections::emptyList);
    }

    private AccountAccessType mapToAccountAccessTypeFromAvailableAccounts(AccountAccess.AvailableAccountsEnum accountsEnum) {
        return Optional.ofNullable(accountsEnum).flatMap(en -> AccountAccessType.getByDescription((String)en.toString())).orElse(null);
    }

    private AccountAccessType mapToAccountAccessTypeFromAllPsd2Enum(AccountAccess.AllPsd2Enum allPsd2Enum) {
        return Optional.ofNullable(allPsd2Enum).flatMap(en -> AccountAccessType.getByDescription((String)en.toString())).orElse(null);
    }

    private de.adorsys.psd2.xs2a.core.profile.AccountReference mapToAccountReference(Object reference, MessageError messageError) {
        try {
            return (de.adorsys.psd2.xs2a.core.profile.AccountReference)this.objectMapper.convertValue(reference, de.adorsys.psd2.xs2a.core.profile.AccountReference.class);
        }
        catch (IllegalArgumentException e) {
            this.errorBuildingService.enrichMessageError(messageError, "Invalid currency code format");
            return null;
        }
    }
}

