/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.link;

import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aAuthenticationObject;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aCreatePisAuthorisationRequest;
import de.adorsys.psd2.xs2a.domain.consent.pis.Xs2aUpdatePisCommonPaymentPsuDataResponse;
import de.adorsys.psd2.xs2a.service.ScaApproachResolver;
import de.adorsys.psd2.xs2a.web.link.AbstractLinks;

public class UpdatePisAuthorisationLinks
extends AbstractLinks {
    public UpdatePisAuthorisationLinks(String httpUrl, ScaApproachResolver scaApproachResolver, Xs2aUpdatePisCommonPaymentPsuDataResponse response, Xs2aCreatePisAuthorisationRequest createRequest) {
        super(httpUrl);
        ScaStatus scaStatus = response.getScaStatus();
        String paymentId = createRequest.getPaymentId();
        String paymentService = createRequest.getPaymentService();
        String paymentProduct = createRequest.getPaymentProduct();
        this.setSelf(this.buildPath("/v1/{payment-service}/{payment-product}/{payment-id}", paymentService, paymentProduct, paymentId));
        this.setStatus(this.buildPath("/v1/{payment-service}/{payment-product}/{payment-id}/status", paymentService, paymentProduct, paymentId));
        if (this.isScaStatusMethodAuthenticated(scaStatus)) {
            this.setSelectAuthenticationMethod(this.buildAuthorisationLink(response, createRequest));
        } else if (this.isScaStatusMethodSelected(response.getChosenScaMethod(), scaStatus) && scaApproachResolver.getInitiationScaApproach(response.getAuthorisationId()) == ScaApproach.EMBEDDED) {
            this.setAuthoriseTransaction(this.buildAuthorisationLink(response, createRequest));
        } else if (this.isScaStatusFinalised(scaStatus)) {
            this.setScaStatus(this.buildAuthorisationLink(response, createRequest));
        } else if (this.isScaStatusMethodIdentified(scaStatus)) {
            this.setUpdatePsuAuthentication(this.buildAuthorisationLink(response, createRequest));
        }
    }

    private String buildAuthorisationLink(Xs2aUpdatePisCommonPaymentPsuDataResponse response, Xs2aCreatePisAuthorisationRequest createRequest) {
        return this.buildPath("/v1/{payment-service}/{payment-product}/{payment-id}/authorisations/{authorisation-id}", createRequest.getPaymentService(), createRequest.getPaymentProduct(), createRequest.getPaymentId(), response.getAuthorisationId());
    }

    private boolean isScaStatusFinalised(ScaStatus scaStatus) {
        return scaStatus == ScaStatus.FINALISED;
    }

    private boolean isScaStatusMethodSelected(Xs2aAuthenticationObject chosenScaMethod, ScaStatus scaStatus) {
        return chosenScaMethod != null && scaStatus == ScaStatus.SCAMETHODSELECTED;
    }

    private boolean isScaStatusMethodAuthenticated(ScaStatus scaStatus) {
        return scaStatus == ScaStatus.PSUAUTHENTICATED;
    }

    private boolean isScaStatusMethodIdentified(ScaStatus scaStatus) {
        return scaStatus == ScaStatus.PSUIDENTIFIED;
    }
}

