/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.link;

import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.domain.pis.CancelPaymentResponse;
import de.adorsys.psd2.xs2a.service.ScaApproachResolver;
import de.adorsys.psd2.xs2a.web.RedirectLinkBuilder;
import de.adorsys.psd2.xs2a.web.link.AbstractLinks;
import java.util.EnumSet;

public class PaymentCancellationLinks
extends AbstractLinks {
    private ScaApproachResolver scaApproachResolver;
    private RedirectLinkBuilder redirectLinkBuilder;
    private boolean isExplicitMethod;

    public PaymentCancellationLinks(String httpUrl, ScaApproachResolver scaApproachResolver, RedirectLinkBuilder redirectLinkBuilder, CancelPaymentResponse response, boolean isExplicitMethod) {
        super(httpUrl);
        this.scaApproachResolver = scaApproachResolver;
        this.redirectLinkBuilder = redirectLinkBuilder;
        this.isExplicitMethod = isExplicitMethod;
        this.buildCancellationLinks(response);
    }

    private void buildCancellationLinks(CancelPaymentResponse body) {
        if (TransactionStatus.RJCT == body.getTransactionStatus()) {
            return;
        }
        String paymentId = body.getPaymentId();
        String paymentService = body.getPaymentType().getValue();
        String paymentProduct = body.getPaymentProduct();
        this.setSelf(this.buildPath("/v1/{payment-service}/{payment-product}/{payment-id}", paymentService, paymentProduct, paymentId));
        this.setStatus(this.buildPath("/v1/{payment-service}/{payment-product}/{payment-id}/status", paymentService, paymentProduct, paymentId));
        ScaApproach scaApproach = this.scaApproachResolver.resolveScaApproach();
        if (EnumSet.of(ScaApproach.EMBEDDED, ScaApproach.DECOUPLED).contains(scaApproach)) {
            this.addEmbeddedDecoupledRelatedLinks(body);
        } else if (scaApproach == ScaApproach.REDIRECT) {
            this.addRedirectRelatedLinks(body);
        } else if (scaApproach == ScaApproach.OAUTH) {
            this.setScaOAuth("scaOAuth");
        }
    }

    private void addEmbeddedDecoupledRelatedLinks(CancelPaymentResponse body) {
        String paymentId = body.getPaymentId();
        String paymentService = body.getPaymentType().getValue();
        String paymentProduct = body.getPaymentProduct();
        String authorisationId = body.getAuthorizationId();
        if (this.isExplicitMethod) {
            this.setStartAuthorisationWithPsuAuthentication(this.buildPath("/v1/{payment-service}/{payment-product}/{payment-id}/cancellation-authorisations", paymentService, paymentProduct, paymentId));
        } else {
            this.setScaStatus(this.buildPath("/v1/{payment-service}/{payment-product}/{payment-id}/cancellation-authorisations/{authorisation-id}", paymentService, paymentProduct, paymentId, authorisationId));
            this.setUpdatePsuAuthentication(this.buildPath("/v1/{payment-service}/{payment-product}/{payment-id}/cancellation-authorisations/{authorisation-id}", paymentService, paymentProduct, paymentId, authorisationId));
        }
    }

    private void addRedirectRelatedLinks(CancelPaymentResponse body) {
        String paymentId = body.getPaymentId();
        String paymentService = body.getPaymentType().getValue();
        String paymentProduct = body.getPaymentProduct();
        String authorisationId = body.getAuthorizationId();
        if (this.isExplicitMethod) {
            this.setStartAuthorisation(this.buildPath("/v1/{payment-service}/{payment-product}/{payment-id}/cancellation-authorisations", paymentService, paymentProduct, paymentId));
        } else {
            String scaRedirectLink = this.redirectLinkBuilder.buildPaymentScaRedirectLink(paymentId, authorisationId);
            this.setScaRedirect(scaRedirectLink);
            this.setScaStatus(this.buildPath("/v1/{payment-service}/{payment-product}/{payment-id}/cancellation-authorisations/{authorisation-id}", paymentService, paymentProduct, paymentId, authorisationId));
        }
    }
}

