/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.interceptor;

import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.web.validator.ErrorBuildingService;
import de.adorsys.psd2.xs2a.web.validator.MethodValidator;
import de.adorsys.psd2.xs2a.web.validator.MethodValidatorController;
import java.beans.ConstructorProperties;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Component
public class RequestValidationInterceptor
extends HandlerInterceptorAdapter {
    private final ErrorBuildingService errorBuildingService;
    private final MethodValidatorController methodValidatorController;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws IOException {
        return this.isRequestValid(request, response, handler);
    }

    private boolean isRequestValid(HttpServletRequest request, HttpServletResponse response, Object handler) throws IOException {
        MessageError initialMessageError = new MessageError();
        if (handler instanceof HandlerMethod) {
            HandlerMethod handlerMethod = (HandlerMethod)handler;
            String methodName = handlerMethod.getMethod().getName();
            MethodValidator methodValidator = this.methodValidatorController.getMethod(methodName);
            methodValidator.validate(request, initialMessageError);
            if (!initialMessageError.getTppMessages().isEmpty()) {
                this.errorBuildingService.buildErrorResponse(response, initialMessageError);
                return false;
            }
        }
        return true;
    }

    @ConstructorProperties(value={"errorBuildingService", "methodValidatorController"})
    public RequestValidationInterceptor(ErrorBuildingService errorBuildingService, MethodValidatorController methodValidatorController) {
        this.errorBuildingService = errorBuildingService;
        this.methodValidatorController = methodValidatorController;
    }
}

