/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator.pis.authorisation.initiation;

import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.domain.pis.PaymentAuthorisationType;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ErrorType;
import de.adorsys.psd2.xs2a.service.validator.PisEndpointAccessCheckerService;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.service.validator.pis.AbstractPisTppValidator;
import de.adorsys.psd2.xs2a.service.validator.pis.authorisation.initiation.UpdatePisCommonPaymentPsuDataPO;
import java.beans.ConstructorProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class UpdatePisCommonPaymentPsuDataValidator
extends AbstractPisTppValidator<UpdatePisCommonPaymentPsuDataPO> {
    private static final Logger log = LoggerFactory.getLogger(UpdatePisCommonPaymentPsuDataValidator.class);
    private final PisEndpointAccessCheckerService pisEndpointAccessCheckerService;
    private final RequestProviderService requestProviderService;

    @Override
    protected ValidationResult executeBusinessValidation(UpdatePisCommonPaymentPsuDataPO paymentObject) {
        String authorisationId = paymentObject.getAuthorisationId();
        if (!this.pisEndpointAccessCheckerService.isEndpointAccessible(authorisationId, PaymentAuthorisationType.INITIATION)) {
            log.info("X-Request-ID: [{}], Authorisation ID: [{}]. Updating PIS initiation authorisation PSU Data  has failed: endpoint is not accessible for authorisation", (Object)this.requestProviderService.getRequestId(), (Object)authorisationId);
            return ValidationResult.invalid(ErrorType.PIS_403, TppMessageInformation.of(MessageErrorCode.SERVICE_BLOCKED));
        }
        if (paymentObject.getPisCommonPaymentResponse().getTransactionStatus() == TransactionStatus.RJCT) {
            log.info("X-Request-ID: [{}], Authorisation ID: [{}]. Updating PIS initiation authorisation PSU Data has failed: payment has been rejected", (Object)this.requestProviderService.getRequestId(), (Object)authorisationId);
            return ValidationResult.invalid(ErrorType.PIS_403, TppMessageInformation.of(MessageErrorCode.RESOURCE_EXPIRED_403));
        }
        return ValidationResult.valid();
    }

    @ConstructorProperties(value={"pisEndpointAccessCheckerService", "requestProviderService"})
    public UpdatePisCommonPaymentPsuDataValidator(PisEndpointAccessCheckerService pisEndpointAccessCheckerService, RequestProviderService requestProviderService) {
        this.pisEndpointAccessCheckerService = pisEndpointAccessCheckerService;
        this.requestProviderService = requestProviderService;
    }
}

