/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service;

import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.domain.RequestData;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class RequestProviderService {
    private static final String TPP_REDIRECT_PREFERRED_HEADER = "tpp-redirect-preferred";
    private static final String X_REQUEST_ID_HEADER = "x-request-id";
    private static final String PSU_ID_HEADER = "psu-id";
    private static final String PSU_ID_TYPE_HEADER = "psu-id-type";
    private static final String PSU_CORPORATE_ID_HEADER = "psu-corporate-id";
    private static final String PSU_CORPORATE_ID_TYPE_HEADER = "psu-corporate-id-type";
    private final HttpServletRequest httpServletRequest;

    public Optional<Boolean> resolveTppRedirectPreferred() {
        Map<String, String> headers = this.getRequestData().getHeaders();
        if (headers == null || !headers.containsKey(TPP_REDIRECT_PREFERRED_HEADER)) {
            return Optional.empty();
        }
        return Optional.of(Boolean.valueOf(headers.get(TPP_REDIRECT_PREFERRED_HEADER)));
    }

    public RequestData getRequestData() {
        String uri = this.httpServletRequest.getRequestURI();
        UUID requestId = UUID.fromString(this.getHeader(X_REQUEST_ID_HEADER));
        String ip = this.httpServletRequest.getRemoteAddr();
        Map<String, String> headers = this.getRequestHeaders(this.httpServletRequest);
        PsuIdData psuIdData = this.getPsuIdData();
        return new RequestData(uri, requestId, ip, headers, psuIdData);
    }

    public PsuIdData getPsuIdData() {
        return new PsuIdData(this.getHeader(PSU_ID_HEADER), this.getHeader(PSU_ID_TYPE_HEADER), this.getHeader(PSU_CORPORATE_ID_HEADER), this.getHeader(PSU_CORPORATE_ID_TYPE_HEADER));
    }

    private String getHeader(String headerName) {
        return this.httpServletRequest.getHeader(headerName);
    }

    public UUID getRequestId() {
        return this.getRequestData().getRequestId();
    }

    public boolean isRequestFromPsu() {
        return StringUtils.isNotBlank((CharSequence)this.getPsuIpAddress());
    }

    public boolean isRequestFromTPP() {
        return !this.isRequestFromPsu();
    }

    public String getPsuIpAddress() {
        return this.getHeader("psu-ip-address");
    }

    private Map<String, String> getRequestHeaders(HttpServletRequest request) {
        return Collections.list(request.getHeaderNames()).stream().collect(Collectors.toMap(Function.identity(), arg_0 -> ((HttpServletRequest)request).getHeader(arg_0)));
    }

    @ConstructorProperties(value={"httpServletRequest"})
    public RequestProviderService(HttpServletRequest httpServletRequest) {
        this.httpServletRequest = httpServletRequest;
    }
}

