/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service;

import de.adorsys.psd2.xs2a.core.consent.AspspConsentData;
import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.event.EventType;
import de.adorsys.psd2.xs2a.core.profile.AccountReference;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import de.adorsys.psd2.xs2a.core.tpp.TppInfo;
import de.adorsys.psd2.xs2a.core.tpp.TppRedirectUri;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.domain.authorisation.AuthorisationResponse;
import de.adorsys.psd2.xs2a.domain.consent.AccountConsent;
import de.adorsys.psd2.xs2a.domain.consent.AccountConsentAuthorization;
import de.adorsys.psd2.xs2a.domain.consent.ConsentStatusResponse;
import de.adorsys.psd2.xs2a.domain.consent.CreateConsentAuthorizationResponse;
import de.adorsys.psd2.xs2a.domain.consent.CreateConsentReq;
import de.adorsys.psd2.xs2a.domain.consent.CreateConsentResponse;
import de.adorsys.psd2.xs2a.domain.consent.UpdateConsentPsuDataReq;
import de.adorsys.psd2.xs2a.domain.consent.UpdateConsentPsuDataResponse;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aAccountAccess;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aAuthorisationSubResources;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.service.ScaApproachResolver;
import de.adorsys.psd2.xs2a.service.TppService;
import de.adorsys.psd2.xs2a.service.authorization.AuthorisationMethodDecider;
import de.adorsys.psd2.xs2a.service.authorization.ais.AisAuthorizationService;
import de.adorsys.psd2.xs2a.service.authorization.ais.AisScaAuthorisationServiceResolver;
import de.adorsys.psd2.xs2a.service.consent.AccountReferenceInConsentUpdater;
import de.adorsys.psd2.xs2a.service.consent.AisConsentDataService;
import de.adorsys.psd2.xs2a.service.consent.Xs2aAisConsentService;
import de.adorsys.psd2.xs2a.service.context.SpiContextDataProvider;
import de.adorsys.psd2.xs2a.service.event.Xs2aEventService;
import de.adorsys.psd2.xs2a.service.mapper.consent.Xs2aAisConsentMapper;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ErrorType;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ServiceType;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiErrorMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aAccountAccessMapper;
import de.adorsys.psd2.xs2a.service.validator.AisEndpointAccessCheckerService;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.service.validator.ais.CommonConsentObject;
import de.adorsys.psd2.xs2a.service.validator.ais.consent.CreateConsentAuthorisationValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.consent.CreateConsentRequestValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.consent.DeleteAccountConsentsByIdValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.consent.GetAccountConsentByIdValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.consent.GetAccountConsentsStatusByIdValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.consent.GetConsentAuthorisationScaStatusValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.consent.GetConsentAuthorisationsValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.consent.UpdateConsentPsuDataValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.consent.dto.CreateConsentRequestObject;
import de.adorsys.psd2.xs2a.spi.domain.SpiContextData;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountConsent;
import de.adorsys.psd2.xs2a.spi.domain.consent.SpiAisConsentStatusResponse;
import de.adorsys.psd2.xs2a.spi.domain.consent.SpiInitiateAisConsentResponse;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.AisConsentSpi;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class ConsentService {
    private final Xs2aAisConsentMapper aisConsentMapper;
    private final SpiToXs2aAccountAccessMapper spiToXs2aAccountAccessMapper;
    private final Xs2aAisConsentService aisConsentService;
    private final AisConsentDataService aisConsentDataService;
    private final AisScaAuthorisationServiceResolver aisScaAuthorisationServiceResolver;
    private final TppService tppService;
    private final AisEndpointAccessCheckerService endpointAccessCheckerService;
    private final SpiContextDataProvider spiContextDataProvider;
    private final AuthorisationMethodDecider authorisationMethodDecider;
    private final AisConsentSpi aisConsentSpi;
    private final Xs2aEventService xs2aEventService;
    private final AccountReferenceInConsentUpdater accountReferenceUpdater;
    private final SpiErrorMapper spiErrorMapper;
    private final ScaApproachResolver scaApproachResolver;
    private final CreateConsentRequestValidator createConsentRequestValidator;
    private final GetAccountConsentsStatusByIdValidator getAccountConsentsStatusByIdValidator;
    private final GetAccountConsentByIdValidator getAccountConsentByIdValidator;
    private final DeleteAccountConsentsByIdValidator deleteAccountConsentsByIdValidator;
    private final CreateConsentAuthorisationValidator createConsentAuthorisationValidator;
    private final UpdateConsentPsuDataValidator updateConsentPsuDataValidator;
    private final GetConsentAuthorisationsValidator getConsentAuthorisationsValidator;
    private final GetConsentAuthorisationScaStatusValidator getConsentAuthorisationScaStatusValidator;

    public ResponseObject<CreateConsentResponse> createAccountConsentsWithResponse(CreateConsentReq request, PsuIdData psuData, boolean explicitPreferred, TppRedirectUri tppRedirectUri) {
        this.xs2aEventService.recordTppRequest(EventType.CREATE_AIS_CONSENT_REQUEST_RECEIVED, request);
        ValidationResult validationResult = this.createConsentRequestValidator.validate(new CreateConsentRequestObject(request, psuData));
        if (validationResult.isNotValid()) {
            return ResponseObject.builder().fail(validationResult.getMessageError()).build();
        }
        if (request.isGlobalOrAllAccountsAccessConsent()) {
            request.setAccess(this.getAccessForGlobalOrAllAvailableAccountsConsent(request));
        }
        TppInfo tppInfo = this.tppService.getTppInfo();
        tppInfo.setTppRedirectUri(tppRedirectUri);
        String consentId = this.aisConsentService.createConsent(request, psuData, tppInfo);
        if (StringUtils.isBlank((CharSequence)consentId)) {
            return ResponseObject.builder().fail(ErrorType.AIS_400, TppMessageInformation.of(MessageErrorCode.RESOURCE_UNKNOWN_400)).build();
        }
        Optional<AccountConsent> accountConsentOptional = this.aisConsentService.getInitialAccountConsentById(consentId);
        if (!accountConsentOptional.isPresent()) {
            return ResponseObject.builder().fail(ErrorType.AIS_400, TppMessageInformation.of(MessageErrorCode.CONSENT_UNKNOWN_400)).build();
        }
        SpiContextData contextData = this.spiContextDataProvider.provide(psuData, tppInfo);
        SpiResponse initiateAisConsentSpiResponse = this.aisConsentSpi.initiateAisConsent(contextData, this.aisConsentMapper.mapToSpiAccountConsent(accountConsentOptional.get()), AspspConsentData.emptyConsentData());
        AspspConsentData aspspConsentData = initiateAisConsentSpiResponse.getAspspConsentData();
        this.aisConsentDataService.updateAspspConsentData(new AspspConsentData(aspspConsentData.getAspspConsentData(), consentId));
        if (initiateAisConsentSpiResponse.hasError()) {
            this.aisConsentService.updateConsentStatus(consentId, ConsentStatus.REJECTED);
            return ResponseObject.builder().fail(new MessageError(this.spiErrorMapper.mapToErrorHolder(initiateAisConsentSpiResponse, ServiceType.AIS))).build();
        }
        SpiInitiateAisConsentResponse spiResponsePayload = (SpiInitiateAisConsentResponse)initiateAisConsentSpiResponse.getPayload();
        boolean multilevelScaRequired = spiResponsePayload.isMultilevelScaRequired();
        this.updateMultilevelSca(consentId, multilevelScaRequired);
        Optional<Xs2aAccountAccess> xs2aAccountAccess = this.spiToXs2aAccountAccessMapper.mapToAccountAccess(spiResponsePayload.getAccountAccess());
        xs2aAccountAccess.ifPresent(accountAccess -> this.accountReferenceUpdater.rewriteAccountAccess(consentId, (Xs2aAccountAccess)accountAccess));
        CreateConsentResponse createConsentResponse = new CreateConsentResponse(ConsentStatus.RECEIVED.getValue(), consentId, null, null, null, spiResponsePayload.getPsuMessage(), multilevelScaRequired);
        ResponseObject<CreateConsentResponse> createConsentResponseObject = ResponseObject.builder().body(createConsentResponse).build();
        if (this.authorisationMethodDecider.isImplicitMethod(explicitPreferred, multilevelScaRequired)) {
            this.proceedImplicitCaseForCreateConsent(createConsentResponseObject.getBody(), psuData, consentId);
        }
        return createConsentResponseObject;
    }

    private void updateMultilevelSca(String consentId, boolean multilevelScaRequired) {
        if (multilevelScaRequired) {
            this.aisConsentService.updateMultilevelScaRequired(consentId, multilevelScaRequired);
        }
    }

    public ResponseObject<ConsentStatusResponse> getAccountConsentsStatusById(String consentId) {
        this.xs2aEventService.recordAisTppRequest(consentId, EventType.GET_AIS_CONSENT_STATUS_REQUEST_RECEIVED);
        ResponseObject.ResponseBuilder<ConsentStatusResponse> responseBuilder = ResponseObject.builder();
        Optional<AccountConsent> validatedAccountConsentOptional = this.aisConsentService.getAccountConsentById(consentId);
        if (!validatedAccountConsentOptional.isPresent()) {
            return responseBuilder.fail(ErrorType.AIS_403, TppMessageInformation.of(MessageErrorCode.CONSENT_UNKNOWN_403)).build();
        }
        AccountConsent validatedAccountConsent = validatedAccountConsentOptional.get();
        ValidationResult validationResult = this.getAccountConsentsStatusByIdValidator.validate(new CommonConsentObject(validatedAccountConsent));
        if (validationResult.isNotValid()) {
            return ResponseObject.builder().fail(validationResult.getMessageError()).build();
        }
        ConsentStatus consentStatus = validatedAccountConsent.getConsentStatus();
        if (consentStatus.isFinalisedStatus()) {
            return responseBuilder.body(new ConsentStatusResponse(consentStatus)).build();
        }
        SpiResponse<SpiAisConsentStatusResponse> spiResponse = this.getConsentStatusFromSpi(validatedAccountConsent, consentId);
        if (spiResponse.hasError()) {
            return responseBuilder.fail(new MessageError(this.spiErrorMapper.mapToErrorHolder(spiResponse, ServiceType.AIS))).build();
        }
        ConsentStatus spiConsentStatus = ((SpiAisConsentStatusResponse)spiResponse.getPayload()).getConsentStatus();
        this.aisConsentService.updateConsentStatus(consentId, spiConsentStatus);
        return responseBuilder.body(new ConsentStatusResponse(spiConsentStatus)).build();
    }

    public ResponseObject<Void> deleteAccountConsentsById(String consentId) {
        this.xs2aEventService.recordAisTppRequest(consentId, EventType.DELETE_AIS_CONSENT_REQUEST_RECEIVED);
        Optional<AccountConsent> accountConsentOptional = this.aisConsentService.getAccountConsentById(consentId);
        if (accountConsentOptional.isPresent()) {
            AccountConsent accountConsent = accountConsentOptional.get();
            ValidationResult validationResult = this.deleteAccountConsentsByIdValidator.validate(new CommonConsentObject(accountConsent));
            if (validationResult.isNotValid()) {
                return ResponseObject.builder().fail(validationResult.getMessageError()).build();
            }
            SpiContextData contextData = this.getSpiContextData(accountConsent.getPsuIdDataList());
            SpiResponse revokeAisConsentResponse = this.aisConsentSpi.revokeAisConsent(contextData, this.aisConsentMapper.mapToSpiAccountConsent(accountConsent), this.aisConsentDataService.getAspspConsentDataByConsentId(consentId));
            this.aisConsentDataService.updateAspspConsentData(revokeAisConsentResponse.getAspspConsentData());
            if (revokeAisConsentResponse.hasError()) {
                return ResponseObject.builder().fail(new MessageError(this.spiErrorMapper.mapToErrorHolder(revokeAisConsentResponse, ServiceType.AIS))).build();
            }
            ConsentStatus newConsentStatus = accountConsent.getConsentStatus() == ConsentStatus.RECEIVED ? ConsentStatus.REJECTED : ConsentStatus.TERMINATED_BY_TPP;
            this.aisConsentService.updateConsentStatus(consentId, newConsentStatus);
            return ResponseObject.builder().build();
        }
        return ResponseObject.builder().fail(ErrorType.AIS_403, TppMessageInformation.of(MessageErrorCode.CONSENT_UNKNOWN_403)).build();
    }

    public ResponseObject<AccountConsent> getAccountConsentById(String consentId) {
        this.xs2aEventService.recordAisTppRequest(consentId, EventType.GET_AIS_CONSENT_REQUEST_RECEIVED);
        Optional<AccountConsent> consentOptional = this.aisConsentService.getInitialAccountConsentById(consentId);
        if (!consentOptional.isPresent()) {
            return ResponseObject.builder().fail(ErrorType.AIS_403, TppMessageInformation.of(MessageErrorCode.CONSENT_UNKNOWN_403)).build();
        }
        AccountConsent consent = consentOptional.get();
        ValidationResult validationResult = this.getAccountConsentByIdValidator.validate(new CommonConsentObject(consent));
        if (validationResult.isNotValid()) {
            return ResponseObject.builder().fail(validationResult.getMessageError()).build();
        }
        if (Objects.nonNull(consent.getConsentStatus()) && consent.getConsentStatus().isFinalisedStatus()) {
            return ResponseObject.builder().body(consent).build();
        }
        SpiResponse<SpiAisConsentStatusResponse> spiConsentStatus = this.getConsentStatusFromSpi(consent, consentId);
        if (spiConsentStatus.hasError()) {
            return ResponseObject.builder().fail(new MessageError(this.spiErrorMapper.mapToErrorHolder(spiConsentStatus, ServiceType.AIS))).build();
        }
        ConsentStatus consentStatus = ((SpiAisConsentStatusResponse)spiConsentStatus.getPayload()).getConsentStatus();
        this.aisConsentService.updateConsentStatus(consentId, consentStatus);
        return ResponseObject.builder().body(this.aisConsentMapper.mapToAccountConsentWithNewStatus(consent, consentStatus)).build();
    }

    public ResponseObject<AuthorisationResponse> createAisAuthorisation(PsuIdData psuData, String consentId, String password) {
        ResponseObject<CreateConsentAuthorizationResponse> createAisAuthorizationResponse = this.createConsentAuthorizationWithResponse(psuData, consentId);
        if (createAisAuthorizationResponse.hasError()) {
            return ResponseObject.builder().fail(createAisAuthorizationResponse.getError()).build();
        }
        if (psuData.isEmpty() || StringUtils.isBlank((CharSequence)password)) {
            return ResponseObject.builder().body(createAisAuthorizationResponse.getBody()).build();
        }
        String authorisationId = createAisAuthorizationResponse.getBody().getAuthorisationId();
        UpdateConsentPsuDataReq updatePsuData = new UpdateConsentPsuDataReq();
        updatePsuData.setPsuData(psuData);
        updatePsuData.setConsentId(consentId);
        updatePsuData.setAuthorizationId(authorisationId);
        updatePsuData.setPassword(password);
        ResponseObject<UpdateConsentPsuDataResponse> updatePsuDataResponse = this.updateConsentPsuData(updatePsuData);
        if (updatePsuDataResponse.hasError()) {
            return ResponseObject.builder().fail(updatePsuDataResponse.getError()).build();
        }
        return ResponseObject.builder().body(updatePsuDataResponse.getBody()).build();
    }

    private ResponseObject<CreateConsentAuthorizationResponse> createConsentAuthorizationWithResponse(PsuIdData psuData, String consentId) {
        this.xs2aEventService.recordAisTppRequest(consentId, EventType.START_AIS_CONSENT_AUTHORISATION_REQUEST_RECEIVED);
        Optional<AccountConsent> accountConsent = this.aisConsentService.getAccountConsentById(consentId);
        if (!accountConsent.isPresent()) {
            return ResponseObject.builder().fail(ErrorType.AIS_403, TppMessageInformation.of(MessageErrorCode.CONSENT_UNKNOWN_403)).build();
        }
        ValidationResult validationResult = this.createConsentAuthorisationValidator.validate(new CommonConsentObject(accountConsent.get()));
        if (validationResult.isNotValid()) {
            return ResponseObject.builder().fail(validationResult.getMessageError()).build();
        }
        if (accountConsent.get().isExpired()) {
            return ResponseObject.builder().fail(ErrorType.AIS_401, TppMessageInformation.of(MessageErrorCode.CONSENT_EXPIRED)).build();
        }
        AisAuthorizationService service = (AisAuthorizationService)this.aisScaAuthorisationServiceResolver.getService();
        return service.createConsentAuthorization(psuData, consentId).map(resp -> ResponseObject.builder().body((CreateConsentAuthorizationResponse)resp).build()).orElseGet(ResponseObject.builder().fail(ErrorType.AIS_403, TppMessageInformation.of(MessageErrorCode.CONSENT_UNKNOWN_403))::build);
    }

    public ResponseObject<UpdateConsentPsuDataResponse> updateConsentPsuData(UpdateConsentPsuDataReq updatePsuData) {
        this.xs2aEventService.recordAisTppRequest(updatePsuData.getConsentId(), EventType.UPDATE_AIS_CONSENT_PSU_DATA_REQUEST_RECEIVED, updatePsuData);
        if (!this.endpointAccessCheckerService.isEndpointAccessible(updatePsuData.getAuthorizationId(), updatePsuData.getConsentId())) {
            return ResponseObject.builder().fail(ErrorType.AIS_403, TppMessageInformation.of(MessageErrorCode.SERVICE_BLOCKED)).build();
        }
        Optional<AccountConsent> accountConsent = this.aisConsentService.getAccountConsentById(updatePsuData.getConsentId());
        if (!accountConsent.isPresent()) {
            return ResponseObject.builder().fail(ErrorType.AIS_403, TppMessageInformation.of(MessageErrorCode.CONSENT_UNKNOWN_403)).build();
        }
        ValidationResult validationResult = this.updateConsentPsuDataValidator.validate(new CommonConsentObject(accountConsent.get()));
        if (validationResult.isNotValid()) {
            return ResponseObject.builder().fail(validationResult.getMessageError()).build();
        }
        if (accountConsent.get().isExpired()) {
            return ResponseObject.builder().fail(ErrorType.AIS_401, TppMessageInformation.of(MessageErrorCode.CONSENT_EXPIRED)).build();
        }
        return ((AisAuthorizationService)this.aisScaAuthorisationServiceResolver.getServiceInitiation(updatePsuData.getAuthorizationId())).getAccountConsentAuthorizationById(updatePsuData.getAuthorizationId(), updatePsuData.getConsentId()).map(conAuth -> this.getUpdateConsentPsuDataResponse(updatePsuData, (AccountConsentAuthorization)conAuth)).orElseGet(ResponseObject.builder().fail(ErrorType.AIS_404, TppMessageInformation.of(MessageErrorCode.RESOURCE_UNKNOWN_404))::build);
    }

    private ResponseObject<UpdateConsentPsuDataResponse> getUpdateConsentPsuDataResponse(UpdateConsentPsuDataReq updatePsuData, AccountConsentAuthorization consentAuthorization) {
        UpdateConsentPsuDataResponse response = ((AisAuthorizationService)this.aisScaAuthorisationServiceResolver.getServiceInitiation(updatePsuData.getAuthorizationId())).updateConsentPsuData(updatePsuData, consentAuthorization);
        return Optional.ofNullable(response).map(s -> Optional.ofNullable(s.getMessageError()).map(e -> ResponseObject.builder().fail((MessageError)e).build()).orElseGet(ResponseObject.builder().body(response)::build)).orElseGet(ResponseObject.builder().fail(ErrorType.AIS_400, TppMessageInformation.of(MessageErrorCode.FORMAT_ERROR))::build);
    }

    public ResponseObject<Xs2aAuthorisationSubResources> getConsentInitiationAuthorisations(String consentId) {
        this.xs2aEventService.recordAisTppRequest(consentId, EventType.GET_CONSENT_AUTHORISATION_REQUEST_RECEIVED);
        Optional<AccountConsent> accountConsent = this.aisConsentService.getAccountConsentById(consentId);
        if (!accountConsent.isPresent()) {
            return ResponseObject.builder().fail(ErrorType.AIS_403, TppMessageInformation.of(MessageErrorCode.CONSENT_UNKNOWN_403)).build();
        }
        ValidationResult validationResult = this.getConsentAuthorisationsValidator.validate(new CommonConsentObject(accountConsent.get()));
        if (validationResult.isNotValid()) {
            return ResponseObject.builder().fail(validationResult.getMessageError()).build();
        }
        return this.getAuthorisationSubResources(consentId).map(resp -> ResponseObject.builder().body((Xs2aAuthorisationSubResources)resp).build()).orElseGet(ResponseObject.builder().fail(ErrorType.AIS_404, TppMessageInformation.of(MessageErrorCode.RESOURCE_UNKNOWN_404))::build);
    }

    public ResponseObject<ScaStatus> getConsentAuthorisationScaStatus(String consentId, String authorisationId) {
        this.xs2aEventService.recordAisTppRequest(consentId, EventType.GET_CONSENT_SCA_STATUS_REQUEST_RECEIVED);
        Optional<AccountConsent> accountConsent = this.aisConsentService.getAccountConsentById(consentId);
        if (!accountConsent.isPresent()) {
            return ResponseObject.builder().fail(ErrorType.AIS_403, TppMessageInformation.of(MessageErrorCode.CONSENT_UNKNOWN_403)).build();
        }
        ValidationResult validationResult = this.getConsentAuthorisationScaStatusValidator.validate(new CommonConsentObject(accountConsent.get()));
        if (validationResult.isNotValid()) {
            return ResponseObject.builder().fail(validationResult.getMessageError()).build();
        }
        Optional<ScaStatus> scaStatus = ((AisAuthorizationService)this.aisScaAuthorisationServiceResolver.getServiceInitiation(authorisationId)).getAuthorisationScaStatus(consentId, authorisationId);
        if (!scaStatus.isPresent()) {
            return ResponseObject.builder().fail(ErrorType.AIS_403, TppMessageInformation.of(MessageErrorCode.RESOURCE_UNKNOWN_403)).build();
        }
        return ResponseObject.builder().body(scaStatus.get()).build();
    }

    private SpiResponse<SpiAisConsentStatusResponse> getConsentStatusFromSpi(AccountConsent accountConsent, String consentId) {
        SpiAccountConsent spiAccountConsent = this.aisConsentMapper.mapToSpiAccountConsent(accountConsent);
        SpiResponse spiResponse = this.aisConsentSpi.getConsentStatus(this.spiContextDataProvider.provide(), spiAccountConsent, this.aisConsentDataService.getAspspConsentDataByConsentId(consentId));
        this.aisConsentDataService.updateAspspConsentData(spiResponse.getAspspConsentData());
        return spiResponse;
    }

    private Xs2aAccountAccess getAccessForGlobalOrAllAvailableAccountsConsent(CreateConsentReq request) {
        return new Xs2aAccountAccess(new ArrayList<AccountReference>(), new ArrayList<AccountReference>(), new ArrayList<AccountReference>(), request.getAccess().getAvailableAccounts(), request.getAccess().getAllPsd2());
    }

    private void proceedImplicitCaseForCreateConsent(CreateConsentResponse response, PsuIdData psuData, String consentId) {
        ((AisAuthorizationService)this.aisScaAuthorisationServiceResolver.getService()).createConsentAuthorization(psuData, consentId).ifPresent(a -> response.setAuthorizationId(a.getAuthorisationId()));
    }

    private SpiContextData getSpiContextData(List<PsuIdData> psuIdDataList) {
        return this.spiContextDataProvider.provideWithPsuIdData(CollectionUtils.isNotEmpty(psuIdDataList) ? psuIdDataList.get(0) : null);
    }

    private Optional<Xs2aAuthorisationSubResources> getAuthorisationSubResources(String consentId) {
        return this.aisConsentService.getAuthorisationSubResources(consentId).map(Xs2aAuthorisationSubResources::new);
    }

    @ConstructorProperties(value={"aisConsentMapper", "spiToXs2aAccountAccessMapper", "aisConsentService", "aisConsentDataService", "aisScaAuthorisationServiceResolver", "tppService", "endpointAccessCheckerService", "spiContextDataProvider", "authorisationMethodDecider", "aisConsentSpi", "xs2aEventService", "accountReferenceUpdater", "spiErrorMapper", "scaApproachResolver", "createConsentRequestValidator", "getAccountConsentsStatusByIdValidator", "getAccountConsentByIdValidator", "deleteAccountConsentsByIdValidator", "createConsentAuthorisationValidator", "updateConsentPsuDataValidator", "getConsentAuthorisationsValidator", "getConsentAuthorisationScaStatusValidator"})
    public ConsentService(Xs2aAisConsentMapper aisConsentMapper, SpiToXs2aAccountAccessMapper spiToXs2aAccountAccessMapper, Xs2aAisConsentService aisConsentService, AisConsentDataService aisConsentDataService, AisScaAuthorisationServiceResolver aisScaAuthorisationServiceResolver, TppService tppService, AisEndpointAccessCheckerService endpointAccessCheckerService, SpiContextDataProvider spiContextDataProvider, AuthorisationMethodDecider authorisationMethodDecider, AisConsentSpi aisConsentSpi, Xs2aEventService xs2aEventService, AccountReferenceInConsentUpdater accountReferenceUpdater, SpiErrorMapper spiErrorMapper, ScaApproachResolver scaApproachResolver, CreateConsentRequestValidator createConsentRequestValidator, GetAccountConsentsStatusByIdValidator getAccountConsentsStatusByIdValidator, GetAccountConsentByIdValidator getAccountConsentByIdValidator, DeleteAccountConsentsByIdValidator deleteAccountConsentsByIdValidator, CreateConsentAuthorisationValidator createConsentAuthorisationValidator, UpdateConsentPsuDataValidator updateConsentPsuDataValidator, GetConsentAuthorisationsValidator getConsentAuthorisationsValidator, GetConsentAuthorisationScaStatusValidator getConsentAuthorisationScaStatusValidator) {
        this.aisConsentMapper = aisConsentMapper;
        this.spiToXs2aAccountAccessMapper = spiToXs2aAccountAccessMapper;
        this.aisConsentService = aisConsentService;
        this.aisConsentDataService = aisConsentDataService;
        this.aisScaAuthorisationServiceResolver = aisScaAuthorisationServiceResolver;
        this.tppService = tppService;
        this.endpointAccessCheckerService = endpointAccessCheckerService;
        this.spiContextDataProvider = spiContextDataProvider;
        this.authorisationMethodDecider = authorisationMethodDecider;
        this.aisConsentSpi = aisConsentSpi;
        this.xs2aEventService = xs2aEventService;
        this.accountReferenceUpdater = accountReferenceUpdater;
        this.spiErrorMapper = spiErrorMapper;
        this.scaApproachResolver = scaApproachResolver;
        this.createConsentRequestValidator = createConsentRequestValidator;
        this.getAccountConsentsStatusByIdValidator = getAccountConsentsStatusByIdValidator;
        this.getAccountConsentByIdValidator = getAccountConsentByIdValidator;
        this.deleteAccountConsentsByIdValidator = deleteAccountConsentsByIdValidator;
        this.createConsentAuthorisationValidator = createConsentAuthorisationValidator;
        this.updateConsentPsuDataValidator = updateConsentPsuDataValidator;
        this.getConsentAuthorisationsValidator = getConsentAuthorisationsValidator;
        this.getConsentAuthorisationScaStatusValidator = getConsentAuthorisationScaStatusValidator;
    }
}

