/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.validator.header;

import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.web.validator.ErrorBuildingService;
import de.adorsys.psd2.xs2a.web.validator.constants.Xs2aHeaderConstant;
import de.adorsys.psd2.xs2a.web.validator.header.AbstractHeaderValidatorImpl;
import de.adorsys.psd2.xs2a.web.validator.header.ConsentHeaderValidator;
import de.adorsys.psd2.xs2a.web.validator.header.PaymentHeaderValidator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HeadersLengthValidatorImpl
extends AbstractHeaderValidatorImpl
implements ConsentHeaderValidator,
PaymentHeaderValidator {
    private static final String HEADER_LENGTH_ERROR_TEXT = "Header '%s' should not be more than %s symbols";

    @Autowired
    public HeadersLengthValidatorImpl(ErrorBuildingService errorBuildingService) {
        super(errorBuildingService);
    }

    @Override
    protected String getHeaderName() {
        return null;
    }

    @Override
    public void validate(Map<String, String> inputHeaders, MessageError messageError) {
        HashMap<Integer, List<String>> wrongLengthHeadersMap = new HashMap<Integer, List<String>>();
        Xs2aHeaderConstant.HEADERS_MAP.forEach((maxLength, listOfHeadersToValidate) -> this.validateByLength(inputHeaders, (String[])listOfHeadersToValidate, (Map<Integer, List<String>>)wrongLengthHeadersMap, (int)maxLength));
        if (MapUtils.isNotEmpty(wrongLengthHeadersMap)) {
            this.getResultWithError(messageError, wrongLengthHeadersMap);
        }
    }

    private void validateByLength(Map<String, String> headers, String[] headersToBeValidated, Map<Integer, List<String>> wrongLengthHeadersMap, int length) {
        headers.forEach((k, v) -> {
            if (Arrays.stream(headersToBeValidated).anyMatch(h -> h.equalsIgnoreCase((String)k)) && v.length() > length) {
                if (!wrongLengthHeadersMap.containsKey(length)) {
                    wrongLengthHeadersMap.put(length, new ArrayList<String>(){
                        {
                            this.add(k);
                        }
                    });
                } else {
                    ((List)wrongLengthHeadersMap.get(length)).add(k);
                }
            }
        });
    }

    private void getResultWithError(MessageError messageError, Map<Integer, List<String>> wrongLengthHeadersMap) {
        wrongLengthHeadersMap.forEach((length, listOfHeaders) -> listOfHeaders.forEach(h -> {
            String resultingMessage = String.format(HEADER_LENGTH_ERROR_TEXT, h, length);
            this.errorBuildingService.enrichMessageError(messageError, resultingMessage);
        }));
    }
}

