/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.validator.body.payment.type;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.profile.AccountReference;
import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.domain.Xs2aAmount;
import de.adorsys.psd2.xs2a.domain.address.Xs2aAddress;
import de.adorsys.psd2.xs2a.domain.pis.SinglePayment;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.web.validator.ErrorBuildingService;
import de.adorsys.psd2.xs2a.web.validator.body.AbstractBodyValidatorImpl;
import de.adorsys.psd2.xs2a.web.validator.body.payment.mapper.PaymentMapper;
import de.adorsys.psd2.xs2a.web.validator.body.payment.type.PaymentTypeValidator;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.validator.routines.IBANValidator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SinglePaymentTypeValidatorImpl
extends AbstractBodyValidatorImpl
implements PaymentTypeValidator {
    private PaymentMapper paymentMapper;

    @Autowired
    public SinglePaymentTypeValidatorImpl(ErrorBuildingService errorBuildingService, ObjectMapper objectMapper, PaymentMapper paymentMapper) {
        super(errorBuildingService, objectMapper);
        this.paymentMapper = paymentMapper;
    }

    @Override
    public PaymentType getPaymentType() {
        return PaymentType.SINGLE;
    }

    @Override
    public void validate(Object body, MessageError messageError) {
        try {
            this.doSingleValidation(this.paymentMapper.getSinglePayment(body), messageError);
        }
        catch (IllegalArgumentException e) {
            this.errorBuildingService.enrichMessageError(messageError, e.getMessage());
        }
    }

    void doSingleValidation(SinglePayment singlePayment, MessageError messageError) {
        this.checkOptionalFieldForMaxLength(singlePayment.getEndToEndIdentification(), "endToEndIdentification", 35, messageError);
        if (Objects.isNull(singlePayment.getDebtorAccount())) {
            this.errorBuildingService.enrichMessageError(messageError, "Value 'debtorAccount' should not be null");
        } else {
            this.validateAccount(singlePayment.getDebtorAccount(), messageError);
        }
        if (Objects.isNull(singlePayment.getInstructedAmount())) {
            this.errorBuildingService.enrichMessageError(messageError, "Value 'instructedAmount' should not be null");
        } else {
            this.validateInstructedAmount(singlePayment.getInstructedAmount(), messageError);
        }
        if (Objects.isNull(singlePayment.getCreditorAccount())) {
            this.errorBuildingService.enrichMessageError(messageError, "Value 'creditorAccount' should not be null");
        } else {
            this.validateAccount(singlePayment.getCreditorAccount(), messageError);
        }
        this.checkRequiredFieldForMaxLength(singlePayment.getCreditorName(), "creditorName", 70, messageError);
        if (Objects.nonNull(singlePayment.getCreditorAddress())) {
            this.validateAddress(singlePayment.getCreditorAddress(), messageError);
        }
        if (this.isDateInThePast(singlePayment.getRequestedExecutionDate())) {
            this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of(MessageErrorCode.EXECUTION_DATE_INVALID, "Value 'requestedExecutionDate' should not be in the past"));
        }
    }

    void validateAddress(Xs2aAddress address, MessageError messageError) {
        this.checkOptionalFieldForMaxLength(address.getStreet(), "street", 100, messageError);
        this.checkOptionalFieldForMaxLength(address.getBuildingNumber(), "buildingNumber", 20, messageError);
        this.checkOptionalFieldForMaxLength(address.getCity(), "city", 100, messageError);
        this.checkOptionalFieldForMaxLength(address.getPostalCode(), "postalCode", 5, messageError);
        if (Objects.isNull(address.getCountry()) || StringUtils.isBlank((CharSequence)address.getCountry().getCode())) {
            this.errorBuildingService.enrichMessageError(messageError, "Value 'address.country' is required");
        } else if (!Arrays.asList(Locale.getISOCountries()).contains(address.getCountry().getCode())) {
            this.errorBuildingService.enrichMessageError(messageError, "Value 'address.country' should be ISO 3166 ALPHA2 country code");
        }
    }

    private void validateInstructedAmount(Xs2aAmount instructedAmount, MessageError messageError) {
        if (Objects.isNull(instructedAmount.getCurrency())) {
            this.errorBuildingService.enrichMessageError(messageError, "Value 'currency' has wrong format");
        }
        if (Objects.isNull(instructedAmount.getAmount())) {
            this.errorBuildingService.enrichMessageError(messageError, "Value 'amount' should not be null");
        } else {
            this.validateAmount(instructedAmount.getAmount(), messageError);
        }
    }

    private void validateAmount(String amount, MessageError messageError) {
        if (!Pattern.matches("-?[0-9]{1,14}(.[0-9]{1,3})?", amount)) {
            this.errorBuildingService.enrichMessageError(messageError, "Value 'amount' has wrong format");
        }
    }

    void validateAccount(AccountReference accountReference, MessageError messageError) {
        if (StringUtils.isNotBlank((CharSequence)accountReference.getIban()) && !this.isValidIban(accountReference.getIban())) {
            this.errorBuildingService.enrichMessageError(messageError, "Invalid IBAN format");
        }
        if (StringUtils.isNotBlank((CharSequence)accountReference.getBban()) && !this.isValidBban(accountReference.getBban())) {
            this.errorBuildingService.enrichMessageError(messageError, "Invalid BBAN format");
        }
        this.checkOptionalFieldForMaxLength(accountReference.getPan(), "PAN", 35, messageError);
        this.checkOptionalFieldForMaxLength(accountReference.getMaskedPan(), "Masked PAN", 35, messageError);
        this.checkOptionalFieldForMaxLength(accountReference.getMsisdn(), "MSISDN", 35, messageError);
    }

    private boolean isValidIban(String iban) {
        IBANValidator validator = IBANValidator.getInstance();
        return validator.isValid(iban);
    }

    private boolean isValidBban(String bban) {
        return this.normalizeString(bban).length() >= 11 && this.normalizeString(bban).length() <= 28;
    }

    private String normalizeString(String string) {
        return string.replaceAll("[^a-zA-Z0-9]", "");
    }

    boolean isDateInThePast(LocalDate dateToCheck) {
        return Optional.ofNullable(dateToCheck).map(date -> date.isBefore(LocalDate.now())).orElse(false);
    }
}

