/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.validator.body;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.web.validator.ErrorBuildingService;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;

public class AbstractBodyValidatorImpl {
    protected ErrorBuildingService errorBuildingService;
    protected ObjectMapper objectMapper;

    protected AbstractBodyValidatorImpl(ErrorBuildingService errorBuildingService, ObjectMapper objectMapper) {
        this.errorBuildingService = errorBuildingService;
        this.objectMapper = objectMapper;
    }

    protected void checkRequiredFieldForMaxLength(String fieldToCheck, String fieldName, int maxLength, MessageError messageError) {
        if (StringUtils.isBlank((CharSequence)fieldToCheck)) {
            String text = String.format("Value '%s' cannot be empty", fieldName);
            this.errorBuildingService.enrichMessageError(messageError, text);
        } else {
            this.checkFieldForMaxLength(fieldToCheck, fieldName, maxLength, messageError);
        }
    }

    protected void checkOptionalFieldForMaxLength(String field, String fieldName, int maxLength, MessageError messageError) {
        if (StringUtils.isNotBlank((CharSequence)field)) {
            this.checkFieldForMaxLength(field, fieldName, maxLength, messageError);
        }
    }

    private void checkFieldForMaxLength(@NotNull String fieldToCheck, String fieldName, int maxLength, MessageError messageError) {
        if (fieldToCheck.length() > maxLength) {
            String text = String.format("Value '%s' should not be more than %s symbols", fieldName, maxLength);
            this.errorBuildingService.enrichMessageError(messageError, text);
        }
    }

    protected <T> Optional<T> mapBodyToInstance(HttpServletRequest request, MessageError messageError, Class<T> clazz) {
        try {
            return Optional.of(this.objectMapper.readValue((InputStream)request.getInputStream(), clazz));
        }
        catch (IOException e) {
            this.errorBuildingService.enrichMessageError(messageError, "Cannot deserialize the request body");
            return Optional.empty();
        }
    }
}

