/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.mapper;

import de.adorsys.psd2.api.ConsentApi;
import de.adorsys.psd2.aspsp.profile.service.AspspProfileService;
import de.adorsys.psd2.model.AuthenticationType;
import de.adorsys.psd2.model.Authorisations;
import de.adorsys.psd2.model.AuthorisationsList;
import de.adorsys.psd2.model.ChosenScaMethod;
import de.adorsys.psd2.model.ScaStatusResponse;
import de.adorsys.psd2.model.StartScaprocessResponse;
import de.adorsys.psd2.model.UpdatePsuAuthenticationResponse;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.sca.ChallengeData;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import de.adorsys.psd2.xs2a.domain.Links;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.authorisation.AuthorisationResponse;
import de.adorsys.psd2.xs2a.domain.consent.CreateConsentAuthorizationResponse;
import de.adorsys.psd2.xs2a.domain.consent.UpdateConsentPsuDataResponse;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aAuthenticationObject;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aAuthorisationSubResources;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aCreatePisAuthorisationRequest;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aCreatePisAuthorisationResponse;
import de.adorsys.psd2.xs2a.domain.consent.pis.Xs2aUpdatePisCommonPaymentPsuDataResponse;
import de.adorsys.psd2.xs2a.service.ScaApproachResolver;
import de.adorsys.psd2.xs2a.web.RedirectLinkBuilder;
import de.adorsys.psd2.xs2a.web.mapper.CoreObjectsMapper;
import de.adorsys.psd2.xs2a.web.mapper.HrefLinkMapper;
import de.adorsys.psd2.xs2a.web.mapper.ScaMethodsMapper;
import java.beans.ConstructorProperties;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.stereotype.Service;
import org.springframework.web.util.UriComponentsBuilder;

@Service
public class AuthorisationMapper {
    private static final Logger log = LoggerFactory.getLogger(AuthorisationMapper.class);
    private final CoreObjectsMapper coreObjectsMapper;
    private final ScaApproachResolver scaApproachResolver;
    private final RedirectLinkBuilder redirectLinkBuilder;
    private final AspspProfileService aspspProfileService;
    private final HrefLinkMapper hrefLinkMapper;
    private final ScaMethodsMapper scaMethodsMapper;

    public Authorisations mapToAuthorisations(Xs2aAuthorisationSubResources xs2AAuthorisationSubResources) {
        Authorisations authorisations = new Authorisations();
        AuthorisationsList authorisationsList = new AuthorisationsList();
        authorisationsList.addAll(xs2AAuthorisationSubResources.getAuthorisationIds());
        authorisations.setAuthorisationIds(authorisationsList);
        return authorisations;
    }

    public Object mapToPisCreateOrUpdateAuthorisationResponse(ResponseObject responseObject) {
        Object body = responseObject.getBody();
        if (Objects.isNull(body)) {
            return null;
        }
        if (body instanceof Xs2aCreatePisAuthorisationResponse) {
            return this.mapToStartScaProcessResponseFromPis((Xs2aCreatePisAuthorisationResponse)body);
        }
        if (body instanceof Xs2aUpdatePisCommonPaymentPsuDataResponse) {
            return this.mapToPisUpdatePsuAuthenticationResponse((Xs2aUpdatePisCommonPaymentPsuDataResponse)body);
        }
        return null;
    }

    public Object mapToAisCreateOrUpdateAuthorisationResponse(ResponseObject<AuthorisationResponse> responseObject) {
        AuthorisationResponse body = responseObject.getBody();
        if (Objects.isNull(body)) {
            return null;
        }
        if (body instanceof CreateConsentAuthorizationResponse) {
            return this.mapToStartScaProcessResponse((CreateConsentAuthorizationResponse)body);
        }
        if (body instanceof UpdateConsentPsuDataResponse) {
            return this.mapToAisUpdatePsuAuthenticationResponse((UpdateConsentPsuDataResponse)body);
        }
        return null;
    }

    @NotNull
    public ScaStatusResponse mapToScaStatusResponse(@NotNull ScaStatus scaStatus) {
        return new ScaStatusResponse().scaStatus(this.coreObjectsMapper.mapToModelScaStatus(scaStatus));
    }

    public UpdatePsuAuthenticationResponse mapToPisUpdatePsuAuthenticationResponse(Xs2aUpdatePisCommonPaymentPsuDataResponse response) {
        return Optional.ofNullable(response).map(r -> this.buildUpdatePsuAuthenticationResponse(r.getLinks(), r.getAvailableScaMethods(), r.getChosenScaMethod(), r.getPsuMessage(), r.getChallengeData(), r.getScaStatus())).orElse(null);
    }

    public UpdatePsuAuthenticationResponse mapToAisUpdatePsuAuthenticationResponse(UpdateConsentPsuDataResponse response) {
        return Optional.ofNullable(response).map(r -> this.buildUpdatePsuAuthenticationResponse(r.getLinks(), r.getAvailableScaMethods(), r.getChosenScaMethod(), r.getPsuMessage(), r.getChallengeData(), r.getScaStatus())).orElse(null);
    }

    public Xs2aCreatePisAuthorisationRequest mapToXs2aCreatePisAuthorisationRequest(PsuIdData psuData, String paymentId, String paymentService, String paymentProduct, Map body) {
        return new Xs2aCreatePisAuthorisationRequest(paymentId, psuData, paymentProduct, paymentService, this.mapToPasswordFromBody(body));
    }

    public String mapToPasswordFromBody(Map body) {
        return Optional.ofNullable(body).filter(bdy -> !bdy.isEmpty()).map(bdy -> bdy.get("psuData")).map(o -> (LinkedHashMap)o).map(psuDataMap -> (String)psuDataMap.get("password")).orElse(null);
    }

    private StartScaprocessResponse mapToStartScaProcessResponseFromPis(Xs2aCreatePisAuthorisationResponse response) {
        return Optional.ofNullable(response).map(r -> new StartScaprocessResponse().scaStatus(this.coreObjectsMapper.mapToModelScaStatus(r.getScaStatus())).authorisationId(r.getAuthorisationId())._links(this.hrefLinkMapper.mapToLinksMap(r.getLinks()))).orElse(null);
    }

    private StartScaprocessResponse mapToStartScaProcessResponse(CreateConsentAuthorizationResponse createResponse) {
        return Optional.ofNullable(createResponse).map(csar -> {
            boolean redirectApproachUsed = this.scaApproachResolver.resolveScaApproach() == ScaApproach.REDIRECT;
            String link = redirectApproachUsed ? this.redirectLinkBuilder.buildConsentScaRedirectLink(csar.getConsentId(), csar.getAuthorisationId()) : this.createUpdateConsentsPsuDataLink((CreateConsentAuthorizationResponse)csar);
            return new StartScaprocessResponse().scaStatus(this.coreObjectsMapper.mapToModelScaStatus(csar.getScaStatus()))._links(this.hrefLinkMapper.mapToLinksMap(csar.getResponseLinkType().getValue(), link));
        }).orElse(null);
    }

    private String createUpdateConsentsPsuDataLink(CreateConsentAuthorizationResponse csar) {
        URI uri = ControllerLinkBuilder.linkTo((Object)((ConsentApi)ControllerLinkBuilder.methodOn(ConsentApi.class, (Object[])new Object[0]))._updateConsentsPsuData(null, csar.getConsentId(), csar.getAuthorisationId(), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null)).toUri();
        UriComponentsBuilder uriComponentsBuilder = this.aspspProfileService.getAspspSettings().isForceXs2aBaseUrl() ? UriComponentsBuilder.fromHttpUrl((String)this.aspspProfileService.getAspspSettings().getXs2aBaseUrl()).path(uri.getPath()) : UriComponentsBuilder.fromUri((URI)uri);
        return uriComponentsBuilder.toUriString();
    }

    private UpdatePsuAuthenticationResponse buildUpdatePsuAuthenticationResponse(Links links, List<Xs2aAuthenticationObject> availableScaMethods, Xs2aAuthenticationObject chosenScaMethod, String psuMessage, ChallengeData challengeData, ScaStatus scaStatus) {
        return new UpdatePsuAuthenticationResponse()._links(this.hrefLinkMapper.mapToLinksMap(links)).scaMethods(this.scaMethodsMapper.mapToScaMethods(availableScaMethods)).chosenScaMethod(this.mapToChosenScaMethod(chosenScaMethod)).psuMessage(psuMessage).challengeData(this.coreObjectsMapper.mapToChallengeData(challengeData)).scaStatus((de.adorsys.psd2.model.ScaStatus)Optional.ofNullable(scaStatus).map(s -> de.adorsys.psd2.model.ScaStatus.valueOf((String)s.name())).orElse(null));
    }

    private ChosenScaMethod mapToChosenScaMethod(Xs2aAuthenticationObject xs2aAuthenticationObject) {
        return Optional.ofNullable(xs2aAuthenticationObject).map(ch -> {
            ChosenScaMethod method = new ChosenScaMethod();
            method.setAuthenticationMethodId(ch.getAuthenticationMethodId());
            method.setAuthenticationType(AuthenticationType.fromValue((String)ch.getAuthenticationType()));
            method.setAuthenticationVersion(ch.getAuthenticationVersion());
            method.setName(ch.getName());
            method.setExplanation(ch.getExplanation());
            return method;
        }).orElse(null);
    }

    @ConstructorProperties(value={"coreObjectsMapper", "scaApproachResolver", "redirectLinkBuilder", "aspspProfileService", "hrefLinkMapper", "scaMethodsMapper"})
    public AuthorisationMapper(CoreObjectsMapper coreObjectsMapper, ScaApproachResolver scaApproachResolver, RedirectLinkBuilder redirectLinkBuilder, AspspProfileService aspspProfileService, HrefLinkMapper hrefLinkMapper, ScaMethodsMapper scaMethodsMapper) {
        this.coreObjectsMapper = coreObjectsMapper;
        this.scaApproachResolver = scaApproachResolver;
        this.redirectLinkBuilder = redirectLinkBuilder;
        this.aspspProfileService = aspspProfileService;
        this.hrefLinkMapper = hrefLinkMapper;
        this.scaMethodsMapper = scaMethodsMapper;
    }
}

