/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.interceptor.logging;

import de.adorsys.psd2.xs2a.component.TppLogger;
import de.adorsys.psd2.xs2a.service.TppService;
import java.beans.ConstructorProperties;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Component
public class PaymentLoggingInterceptor
extends HandlerInterceptorAdapter {
    private static final String NOT_EXIST_IN_URI = "Not exist in URI";
    private final TppService tppService;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        Map pathVariables = (Map)request.getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE);
        String paymentId = Optional.ofNullable(pathVariables).map(vr -> (String)vr.get("paymentId")).orElse(NOT_EXIST_IN_URI);
        TppLogger.logRequest().withParam("TPP ID", this.tppService.getTppId()).withParam("TPP IP", request.getRemoteAddr()).withParam("x-request-id", request.getHeader("x-request-id")).withParam("URI", request.getRequestURI()).withParam("Payment ID", paymentId).perform();
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        TppLogger.logResponse().withParam("TPP ID", this.tppService.getTppId()).withParam("x-request-id", response.getHeader("x-request-id")).withParam("Status", String.valueOf(response.getStatus())).perform();
    }

    @ConstructorProperties(value={"tppService"})
    public PaymentLoggingInterceptor(TppService tppService) {
        this.tppService = tppService;
    }
}

