/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.aspect;

import de.adorsys.psd2.aspsp.profile.service.AspspProfileService;
import de.adorsys.psd2.xs2a.core.ais.BookingStatus;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.Transactions;
import de.adorsys.psd2.xs2a.domain.account.Xs2aAccountDetails;
import de.adorsys.psd2.xs2a.domain.account.Xs2aAccountDetailsHolder;
import de.adorsys.psd2.xs2a.domain.account.Xs2aAccountListHolder;
import de.adorsys.psd2.xs2a.domain.account.Xs2aAccountReport;
import de.adorsys.psd2.xs2a.domain.account.Xs2aTransactionsReport;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aAccountAccess;
import de.adorsys.psd2.xs2a.service.message.MessageService;
import de.adorsys.psd2.xs2a.web.aspect.AbstractLinkAspect;
import de.adorsys.psd2.xs2a.web.controller.AccountController;
import de.adorsys.psd2.xs2a.web.link.AccountDetailsLinks;
import de.adorsys.psd2.xs2a.web.link.TransactionsReportByPeriodHugeLinks;
import de.adorsys.psd2.xs2a.web.link.TransactionsReportByPeriodLinks;
import java.time.LocalDate;
import java.util.List;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class AccountAspect
extends AbstractLinkAspect<AccountController> {
    private static final Logger log = LoggerFactory.getLogger(AccountAspect.class);

    public AccountAspect(MessageService messageService, AspspProfileService aspspProfileService) {
        super(messageService, aspspProfileService);
    }

    @AfterReturning(pointcut="execution(* de.adorsys.psd2.xs2a.service.AccountService.getAccountDetails(..)) && args( consentId, accountId, withBalance, requestUri)", returning="result", argNames="result,consentId,accountId,withBalance,requestUri")
    public ResponseObject<Xs2aAccountDetailsHolder> getAccountDetailsAspect(ResponseObject<Xs2aAccountDetailsHolder> result, String consentId, String accountId, boolean withBalance, String requestUri) {
        if (!result.hasError()) {
            Xs2aAccountDetailsHolder body = result.getBody();
            Xs2aAccountDetails accountDetails = body.getAccountDetails();
            accountDetails.setLinks(new AccountDetailsLinks(this.getHttpUrl(), accountDetails.getResourceId(), body.getAccountConsent().getAccess()));
            return result;
        }
        return this.enrichErrorTextMessage(result);
    }

    @AfterReturning(pointcut="execution(* de.adorsys.psd2.xs2a.service.AccountService.getAccountList(..)) && args( consentId, withBalance, requestUri)", returning="result", argNames="result,consentId,withBalance,requestUri")
    public ResponseObject<Xs2aAccountListHolder> getAccountDetailsListAspect(ResponseObject<Xs2aAccountListHolder> result, String consentId, boolean withBalance, String requestUri) {
        if (!result.hasError()) {
            Xs2aAccountListHolder body = result.getBody();
            List<Xs2aAccountDetails> accountDetails = body.getAccountDetails();
            Xs2aAccountAccess xs2aAccountAccess = body.getAccountConsent().getAccess();
            accountDetails.forEach(acc -> acc.setLinks(new AccountDetailsLinks(this.getHttpUrl(), acc.getResourceId(), xs2aAccountAccess)));
            return result;
        }
        return this.enrichErrorTextMessage(result);
    }

    @AfterReturning(pointcut="execution(* de.adorsys.psd2.xs2a.service.AccountService.getTransactionsReportByPeriod(..)) && args( consentId, accountId, acceptHeader, withBalance, dateFrom, dateTo, bookingStatus, requestUri)", returning="result", argNames="result,consentId,accountId,acceptHeader,withBalance,dateFrom,dateTo,bookingStatus,requestUri")
    public ResponseObject<Xs2aTransactionsReport> getTransactionsReportByPeriod(ResponseObject<Xs2aTransactionsReport> result, String consentId, String accountId, String acceptHeader, boolean withBalance, LocalDate dateFrom, LocalDate dateTo, BookingStatus bookingStatus, String requestUri) {
        if (!result.hasError()) {
            Xs2aTransactionsReport transactionsReport = result.getBody();
            if (transactionsReport.isTransactionReportHuge()) {
                transactionsReport.setLinks(new TransactionsReportByPeriodHugeLinks(this.getHttpUrl(), accountId));
            } else {
                Xs2aAccountReport accountReport = transactionsReport.getAccountReport();
                accountReport.setLinks(new TransactionsReportByPeriodLinks(this.getHttpUrl(), accountId));
            }
            return result;
        }
        return this.enrichErrorTextMessage(result);
    }

    @AfterReturning(pointcut="execution(* de.adorsys.psd2.xs2a.service.AccountService.getTransactionDetails(..)) && args( consentID, accountId, resourceId, requestUri)", returning="result", argNames="result,consentID,accountId,resourceId,requestUri")
    public ResponseObject<Transactions> getTransactionDetailsAspect(ResponseObject<Transactions> result, String consentID, String accountId, String resourceId, String requestUri) {
        if (!result.hasError()) {
            return result;
        }
        return this.enrichErrorTextMessage(result);
    }
}

