/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator.tpp;

import de.adorsys.psd2.xs2a.core.tpp.TppRole;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.Assert;

public final class TppRoleAccess {
    private static AntPathMatcher matcher = new AntPathMatcher();
    private static Map<String, Set<TppRole>> secureURIs;

    private TppRoleAccess(TppAccessBuilder builder) {
        secureURIs = builder.secureURIs;
    }

    private static TppAccessBuilder builder() {
        return new TppAccessBuilder();
    }

    static boolean hasAccessForPath(List<TppRole> tppRoles, String targetPath) {
        for (Map.Entry<String, Set<TppRole>> entry : secureURIs.entrySet()) {
            Set<TppRole> allowedRoles = entry.getValue();
            String pattern = entry.getKey();
            if (!matcher.match(pattern, targetPath)) continue;
            return tppRoles.stream().anyMatch(allowedRoles::contains);
        }
        return true;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof TppRoleAccess;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "TppRoleAccess()";
    }

    static {
        TppRoleAccess.builder().linkTppRolePatterns("/v1/accounts/**", TppRole.AISP).linkTppRolePatterns("/v1/consents/**", TppRole.AISP).linkTppRolePatterns("/v1/bulk-payments/**", TppRole.PISP).linkTppRolePatterns("/v1/payments/**", TppRole.PISP).linkTppRolePatterns("/v1/periodic-payments/**", TppRole.PISP).linkTppRolePatterns("/v1/funds-confirmations/**", TppRole.PIISP).build();
    }

    private static final class TppAccessBuilder {
        private final Map<String, Set<TppRole>> secureURIs = new HashMap<String, Set<TppRole>>();

        private TppAccessBuilder() {
        }

        TppAccessBuilder linkTppRolePatterns(String pattern, TppRole ... tppRoles) {
            Assert.notEmpty((Object[])tppRoles, (String)"Tpp roles must be set!");
            Set roles = Arrays.stream(tppRoles).collect(Collectors.toSet());
            if (this.secureURIs.containsKey(pattern)) {
                this.secureURIs.get(pattern).addAll(roles);
            } else {
                this.secureURIs.put(pattern, roles);
            }
            return this;
        }

        private TppRoleAccess build() {
            return new TppRoleAccess(this);
        }

        public Map<String, Set<TppRole>> getSecureURIs() {
            return this.secureURIs;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TppAccessBuilder)) {
                return false;
            }
            TppAccessBuilder other = (TppAccessBuilder)o;
            Map<String, Set<TppRole>> this$secureURIs = this.getSecureURIs();
            Map<String, Set<TppRole>> other$secureURIs = other.getSecureURIs();
            return !(this$secureURIs == null ? other$secureURIs != null : !((Object)this$secureURIs).equals(other$secureURIs));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, Set<TppRole>> $secureURIs = this.getSecureURIs();
            result = result * 59 + ($secureURIs == null ? 43 : ((Object)$secureURIs).hashCode());
            return result;
        }

        public String toString() {
            return "TppRoleAccess.TppAccessBuilder(secureURIs=" + this.getSecureURIs() + ")";
        }
    }
}

