/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator.ais.account.common;

import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.profile.AccountReference;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.domain.consent.AccountConsent;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aAccountAccess;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ErrorType;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class PermittedAccountReferenceValidator {
    public ValidationResult validate(AccountConsent accountConsent, List<AccountReference> references, String accountId, boolean withBalance) {
        if (this.isNotPermittedAccountReference(this.findAccountReference(references, accountId), accountConsent.getAccess(), withBalance)) {
            return ValidationResult.invalid(ErrorType.AIS_401, TppMessageInformation.of(MessageErrorCode.CONSENT_INVALID));
        }
        return ValidationResult.valid();
    }

    private AccountReference findAccountReference(List<AccountReference> references, String accountId) {
        return references.stream().filter(accountReference -> StringUtils.equals((CharSequence)accountReference.getResourceId(), (CharSequence)accountId)).findFirst().orElse(null);
    }

    private boolean isNotPermittedAccountReference(AccountReference requestedAccountReference, Xs2aAccountAccess consentAccountAccess, boolean withBalance) {
        if (Objects.isNull(requestedAccountReference)) {
            return true;
        }
        List<AccountReference> accountReferences = withBalance ? consentAccountAccess.getBalances() : consentAccountAccess.getAccounts();
        return !this.isValidAccountByAccess(requestedAccountReference.getResourceId(), accountReferences);
    }

    private boolean isValidAccountByAccess(String accountId, List<AccountReference> allowedAccountData) {
        return CollectionUtils.isNotEmpty(allowedAccountData) && allowedAccountData.stream().anyMatch(a -> a.getResourceId().equals(accountId));
    }
}

