/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.payment;

import de.adorsys.psd2.consent.api.pis.PisPayment;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.domain.ErrorHolder;
import de.adorsys.psd2.xs2a.domain.pis.BulkPayment;
import de.adorsys.psd2.xs2a.domain.pis.PaymentInformationResponse;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.context.SpiContextDataProvider;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ServiceType;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiErrorMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aBulkPaymentMapper;
import de.adorsys.psd2.xs2a.service.payment.ReadPaymentService;
import de.adorsys.psd2.xs2a.service.payment.SpiPaymentFactory;
import de.adorsys.psd2.xs2a.service.payment.Xs2aUpdatePaymentStatusAfterSpiService;
import de.adorsys.psd2.xs2a.service.spi.SpiAspspConsentDataProviderFactory;
import de.adorsys.psd2.xs2a.spi.domain.SpiAspspConsentDataProvider;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiBulkPayment;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.BulkPaymentSpi;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="bulk-payments")
public class ReadBulkPaymentService
extends ReadPaymentService<PaymentInformationResponse<BulkPayment>> {
    private static final Logger log = LoggerFactory.getLogger(ReadBulkPaymentService.class);
    private final SpiContextDataProvider spiContextDataProvider;
    private final Xs2aUpdatePaymentStatusAfterSpiService updatePaymentStatusAfterSpiService;
    private final BulkPaymentSpi bulkPaymentSpi;
    private final SpiToXs2aBulkPaymentMapper spiToXs2aBulkPaymentMapper;
    private final SpiErrorMapper spiErrorMapper;
    private final SpiPaymentFactory spiPaymentFactory;
    private final RequestProviderService requestProviderService;
    private final SpiAspspConsentDataProviderFactory aspspConsentDataProviderFactory;

    @Override
    public PaymentInformationResponse<BulkPayment> getPayment(List<PisPayment> pisPayments, String paymentProduct, PsuIdData psuData, @NotNull String encryptedPaymentId) {
        Optional<SpiBulkPayment> spiPaymentOptional = this.spiPaymentFactory.createSpiBulkPayment(pisPayments, paymentProduct);
        if (!spiPaymentOptional.isPresent()) {
            return new PaymentInformationResponse<BulkPayment>(ErrorHolder.builder(MessageErrorCode.RESOURCE_UNKNOWN_404).messages(Collections.singletonList("Payment not found")).build());
        }
        SpiAspspConsentDataProvider aspspConsentDataProvider = this.aspspConsentDataProviderFactory.getSpiAspspDataProviderFor(encryptedPaymentId);
        SpiResponse spiResponse = this.bulkPaymentSpi.getPaymentById(this.spiContextDataProvider.provideWithPsuIdData(psuData), spiPaymentOptional.get(), aspspConsentDataProvider);
        if (spiResponse.getAspspConsentData() != null) {
            aspspConsentDataProvider.updateAspspConsentData(spiResponse.getAspspConsentData().getAspspConsentData());
        }
        if (spiResponse.hasError()) {
            return new PaymentInformationResponse<BulkPayment>(this.spiErrorMapper.mapToErrorHolder(spiResponse, ServiceType.PIS));
        }
        SpiBulkPayment spiResponsePayment = (SpiBulkPayment)spiResponse.getPayload();
        BulkPayment xs2aBulkPayment = this.spiToXs2aBulkPaymentMapper.mapToXs2aBulkPayment(spiResponsePayment);
        TransactionStatus paymentStatus = xs2aBulkPayment.getTransactionStatus();
        if (!this.updatePaymentStatusAfterSpiService.updatePaymentStatus(encryptedPaymentId, paymentStatus)) {
            log.info("X-Request-ID: [{}], Internal payment ID: [{}], Transaction status: [{}]. Update of a payment status in the CMS has failed.", new Object[]{this.requestProviderService.getRequestId(), xs2aBulkPayment.getPaymentId(), paymentStatus});
        }
        return new PaymentInformationResponse<BulkPayment>(xs2aBulkPayment);
    }

    @ConstructorProperties(value={"spiContextDataProvider", "updatePaymentStatusAfterSpiService", "bulkPaymentSpi", "spiToXs2aBulkPaymentMapper", "spiErrorMapper", "spiPaymentFactory", "requestProviderService", "aspspConsentDataProviderFactory"})
    public ReadBulkPaymentService(SpiContextDataProvider spiContextDataProvider, Xs2aUpdatePaymentStatusAfterSpiService updatePaymentStatusAfterSpiService, BulkPaymentSpi bulkPaymentSpi, SpiToXs2aBulkPaymentMapper spiToXs2aBulkPaymentMapper, SpiErrorMapper spiErrorMapper, SpiPaymentFactory spiPaymentFactory, RequestProviderService requestProviderService, SpiAspspConsentDataProviderFactory aspspConsentDataProviderFactory) {
        this.spiContextDataProvider = spiContextDataProvider;
        this.updatePaymentStatusAfterSpiService = updatePaymentStatusAfterSpiService;
        this.bulkPaymentSpi = bulkPaymentSpi;
        this.spiToXs2aBulkPaymentMapper = spiToXs2aBulkPaymentMapper;
        this.spiErrorMapper = spiErrorMapper;
        this.spiPaymentFactory = spiPaymentFactory;
        this.requestProviderService = requestProviderService;
        this.aspspConsentDataProviderFactory = aspspConsentDataProviderFactory;
    }
}

