/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers;

import de.adorsys.psd2.xs2a.domain.Transactions;
import de.adorsys.psd2.xs2a.domain.code.BankTransactionCode;
import de.adorsys.psd2.xs2a.domain.code.Xs2aPurposeCode;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aAccountReferenceMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aAmountMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aExchangeRateMapper;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiTransaction;
import java.beans.ConstructorProperties;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public class SpiToXs2aTransactionMapper {
    private final SpiToXs2aAmountMapper amountMapper;
    private final SpiToXs2aExchangeRateMapper exchangeRateMapper;
    private final SpiToXs2aAccountReferenceMapper accountReferenceMapper;

    public Transactions mapToXs2aTransaction(SpiTransaction spiTransaction) {
        return Optional.ofNullable(spiTransaction).map(t -> {
            Transactions transactions = new Transactions();
            transactions.setTransactionId(t.getTransactionId());
            transactions.setEntryReference(t.getEntryReference());
            transactions.setEndToEndId(t.getEndToEndId());
            transactions.setMandateId(t.getMandateId());
            transactions.setCheckId(t.getCheckId());
            transactions.setCreditorId(t.getCreditorId());
            transactions.setBookingDate(t.getBookingDate());
            transactions.setValueDate(t.getValueDate());
            transactions.setAmount(this.amountMapper.mapToXs2aAmount(t.getSpiAmount()));
            transactions.setExchangeRate(this.exchangeRateMapper.mapToExchangeRateList(t.getExchangeRate()));
            transactions.setCreditorName(t.getCreditorName());
            transactions.setCreditorAccount(this.accountReferenceMapper.mapToXs2aAccountReference(t.getCreditorAccount()).orElse(null));
            transactions.setUltimateCreditor(t.getUltimateCreditor());
            transactions.setDebtorName(t.getDebtorName());
            transactions.setDebtorAccount(this.accountReferenceMapper.mapToXs2aAccountReference(t.getDebtorAccount()).orElse(null));
            transactions.setUltimateDebtor(t.getUltimateDebtor());
            transactions.setRemittanceInformationUnstructured(t.getRemittanceInformationUnstructured());
            transactions.setRemittanceInformationStructured(t.getRemittanceInformationStructured());
            transactions.setPurposeCode(new Xs2aPurposeCode(t.getPurposeCode()));
            transactions.setBankTransactionCodeCode(new BankTransactionCode(t.getBankTransactionCodeCode()));
            transactions.setProprietaryBankTransactionCode(t.getProprietaryBankTransactionCode());
            return transactions;
        }).orElse(null);
    }

    @ConstructorProperties(value={"amountMapper", "exchangeRateMapper", "accountReferenceMapper"})
    public SpiToXs2aTransactionMapper(SpiToXs2aAmountMapper amountMapper, SpiToXs2aExchangeRateMapper exchangeRateMapper, SpiToXs2aAccountReferenceMapper accountReferenceMapper) {
        this.amountMapper = amountMapper;
        this.exchangeRateMapper = exchangeRateMapper;
        this.accountReferenceMapper = accountReferenceMapper;
    }
}

