/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers;

import de.adorsys.psd2.xs2a.domain.account.Xs2aBalancesReport;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aAccountReferenceMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aBalanceMapper;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountBalance;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountReference;
import java.beans.ConstructorProperties;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class SpiToXs2aBalanceReportMapper {
    private final SpiToXs2aBalanceMapper balanceMapper;
    private final SpiToXs2aAccountReferenceMapper referenceMapper;

    public Xs2aBalancesReport mapToXs2aBalancesReport(List<SpiAccountBalance> balances, SpiAccountReference accountReference) {
        Xs2aBalancesReport xs2aBalancesReport = new Xs2aBalancesReport();
        xs2aBalancesReport.setBalances(this.balanceMapper.mapToXs2aBalanceList(balances));
        xs2aBalancesReport.setXs2aAccountReference(this.referenceMapper.mapToXs2aAccountReference(accountReference).orElse(null));
        return xs2aBalancesReport;
    }

    @ConstructorProperties(value={"balanceMapper", "referenceMapper"})
    public SpiToXs2aBalanceReportMapper(SpiToXs2aBalanceMapper balanceMapper, SpiToXs2aAccountReferenceMapper referenceMapper) {
        this.balanceMapper = balanceMapper;
        this.referenceMapper = referenceMapper;
    }
}

