/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper.psd2.pis;

import de.adorsys.psd2.model.Error409NGPIS;
import de.adorsys.psd2.model.MessageCode409PIS;
import de.adorsys.psd2.model.TppMessage409PIS;
import de.adorsys.psd2.model.TppMessageCategory;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.service.mapper.psd2.Psd2ErrorMapper;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

@Component
public class PIS409ErrorMapper
extends Psd2ErrorMapper<MessageError, Error409NGPIS> {
    @Override
    public Function<MessageError, Error409NGPIS> getMapper() {
        return this::mapToPsd2Error;
    }

    @Override
    public HttpStatus getErrorStatus() {
        return HttpStatus.CONFLICT;
    }

    private Error409NGPIS mapToPsd2Error(MessageError messageError) {
        return new Error409NGPIS().tppMessages(this.mapToTppMessage409PIS(messageError.getTppMessages()));
    }

    private List<TppMessage409PIS> mapToTppMessage409PIS(Set<TppMessageInformation> tppMessages) {
        return tppMessages.stream().map(m -> new TppMessage409PIS().category(TppMessageCategory.fromValue((String)m.getCategory().name())).code(MessageCode409PIS.fromValue((String)m.getMessageErrorCode().getName())).path(m.getPath()).text(this.getErrorText((TppMessageInformation)m))).collect(Collectors.toList());
    }
}

