/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper.psd2.ais;

import de.adorsys.psd2.model.Error429NGAIS;
import de.adorsys.psd2.model.MessageCode429AIS;
import de.adorsys.psd2.model.TppMessage429AIS;
import de.adorsys.psd2.model.TppMessageCategory;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.service.mapper.psd2.Psd2ErrorMapper;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

@Component
public class AIS429ErrorMapper
extends Psd2ErrorMapper<MessageError, Error429NGAIS> {
    @Override
    public Function<MessageError, Error429NGAIS> getMapper() {
        return this::mapToPsd2Error;
    }

    @Override
    public HttpStatus getErrorStatus() {
        return HttpStatus.TOO_MANY_REQUESTS;
    }

    private Error429NGAIS mapToPsd2Error(MessageError messageError) {
        return new Error429NGAIS().tppMessages(this.mapToTppMessages(messageError.getTppMessages()));
    }

    private List<TppMessage429AIS> mapToTppMessages(Set<TppMessageInformation> tppMessages) {
        return tppMessages.stream().map(m -> new TppMessage429AIS().category(TppMessageCategory.fromValue((String)m.getCategory().name())).code(MessageCode429AIS.fromValue((String)m.getMessageErrorCode().getName())).path(m.getPath()).text(this.getErrorText((TppMessageInformation)m))).collect(Collectors.toList());
    }
}

