/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service;

import de.adorsys.psd2.consent.api.pis.PisPayment;
import de.adorsys.psd2.consent.api.pis.proto.PisCommonPaymentResponse;
import de.adorsys.psd2.xs2a.config.factory.ReadPaymentFactory;
import de.adorsys.psd2.xs2a.config.factory.ReadPaymentStatusFactory;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.event.EventType;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.tpp.TppInfo;
import de.adorsys.psd2.xs2a.domain.ErrorHolder;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.domain.pis.BulkPayment;
import de.adorsys.psd2.xs2a.domain.pis.CancelPaymentResponse;
import de.adorsys.psd2.xs2a.domain.pis.CommonPayment;
import de.adorsys.psd2.xs2a.domain.pis.PaymentInformationResponse;
import de.adorsys.psd2.xs2a.domain.pis.PaymentInitiationParameters;
import de.adorsys.psd2.xs2a.domain.pis.PaymentInitiationResponse;
import de.adorsys.psd2.xs2a.domain.pis.PeriodicPayment;
import de.adorsys.psd2.xs2a.domain.pis.ReadPaymentStatusResponse;
import de.adorsys.psd2.xs2a.domain.pis.SinglePayment;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.TppService;
import de.adorsys.psd2.xs2a.service.consent.PisPsuDataService;
import de.adorsys.psd2.xs2a.service.consent.Xs2aPisCommonPaymentService;
import de.adorsys.psd2.xs2a.service.context.SpiContextDataProvider;
import de.adorsys.psd2.xs2a.service.event.Xs2aEventService;
import de.adorsys.psd2.xs2a.service.mapper.consent.CmsToXs2aPaymentMapper;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ErrorType;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.Xs2aToSpiPaymentInfoMapper;
import de.adorsys.psd2.xs2a.service.payment.CancelPaymentService;
import de.adorsys.psd2.xs2a.service.payment.CreateBulkPaymentService;
import de.adorsys.psd2.xs2a.service.payment.CreateCommonPaymentService;
import de.adorsys.psd2.xs2a.service.payment.CreatePeriodicPaymentService;
import de.adorsys.psd2.xs2a.service.payment.CreateSinglePaymentService;
import de.adorsys.psd2.xs2a.service.payment.ReadCommonPaymentService;
import de.adorsys.psd2.xs2a.service.payment.ReadCommonPaymentStatusService;
import de.adorsys.psd2.xs2a.service.payment.ReadPaymentService;
import de.adorsys.psd2.xs2a.service.payment.ReadPaymentStatusService;
import de.adorsys.psd2.xs2a.service.payment.SpiPaymentFactory;
import de.adorsys.psd2.xs2a.service.payment.Xs2aUpdatePaymentStatusAfterSpiService;
import de.adorsys.psd2.xs2a.service.profile.StandardPaymentProductsResolver;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.service.validator.pis.payment.CancelPaymentPO;
import de.adorsys.psd2.xs2a.service.validator.pis.payment.CancelPaymentValidator;
import de.adorsys.psd2.xs2a.service.validator.pis.payment.CreatePaymentValidator;
import de.adorsys.psd2.xs2a.service.validator.pis.payment.GetPaymentByIdPO;
import de.adorsys.psd2.xs2a.service.validator.pis.payment.GetPaymentByIdValidator;
import de.adorsys.psd2.xs2a.service.validator.pis.payment.GetPaymentStatusByIdPO;
import de.adorsys.psd2.xs2a.service.validator.pis.payment.GetPaymentStatusByIdValidator;
import de.adorsys.psd2.xs2a.service.validator.pis.payment.dto.CreatePaymentRequestObject;
import de.adorsys.psd2.xs2a.spi.domain.SpiContextData;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiPaymentInfo;
import de.adorsys.psd2.xs2a.spi.service.SpiPayment;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PaymentService {
    private static final Logger log = LoggerFactory.getLogger(PaymentService.class);
    private static final String PAYMENT_NOT_FOUND_MESSAGE = "Payment not found";
    private final ReadPaymentFactory readPaymentFactory;
    private final ReadPaymentStatusFactory readPaymentStatusFactory;
    private final SpiPaymentFactory spiPaymentFactory;
    private final Xs2aPisCommonPaymentService pisCommonPaymentService;
    private final Xs2aUpdatePaymentStatusAfterSpiService updatePaymentStatusAfterSpiService;
    private final PisPsuDataService pisPsuDataService;
    private final TppService tppService;
    private final CreateSinglePaymentService createSinglePaymentService;
    private final CreatePeriodicPaymentService createPeriodicPaymentService;
    private final CreateBulkPaymentService createBulkPaymentService;
    private final CancelPaymentService cancelPaymentService;
    private final Xs2aEventService xs2aEventService;
    private final CreateCommonPaymentService createCommonPaymentService;
    private final ReadCommonPaymentService readCommonPaymentService;
    private final Xs2aToSpiPaymentInfoMapper xs2aToSpiPaymentInfoMapper;
    private final CmsToXs2aPaymentMapper cmsToXs2aPaymentMapper;
    private final SpiContextDataProvider spiContextDataProvider;
    private final ReadCommonPaymentStatusService readCommonPaymentStatusService;
    private final RequestProviderService requestProviderService;
    private final StandardPaymentProductsResolver standardPaymentProductsResolver;
    private final CreatePaymentValidator createPaymentValidator;
    private final GetPaymentByIdValidator getPaymentByIdValidator;
    private final GetPaymentStatusByIdValidator getPaymentStatusByIdValidator;
    private final CancelPaymentValidator cancelPaymentValidator;

    public ResponseObject<PaymentInitiationResponse> createPayment(Object payment, PaymentInitiationParameters paymentInitiationParameters) {
        this.xs2aEventService.recordTppRequest(EventType.PAYMENT_INITIATION_REQUEST_RECEIVED, payment);
        ValidationResult validationResult = this.createPaymentValidator.validate(new CreatePaymentRequestObject(payment, paymentInitiationParameters));
        if (validationResult.isNotValid()) {
            return ResponseObject.builder().fail(validationResult.getMessageError()).build();
        }
        TppInfo tppInfo = this.tppService.getTppInfo();
        tppInfo.setTppRedirectUri(paymentInitiationParameters.getTppRedirectUri());
        if (this.standardPaymentProductsResolver.isRawPaymentProduct(paymentInitiationParameters.getPaymentProduct())) {
            CommonPayment request = new CommonPayment();
            request.setPaymentType(paymentInitiationParameters.getPaymentType());
            request.setPaymentProduct(paymentInitiationParameters.getPaymentProduct());
            request.setPaymentData((byte[])payment);
            request.setTppInfo(tppInfo);
            request.setPsuDataList(Collections.singletonList(paymentInitiationParameters.getPsuData()));
            return this.createCommonPaymentService.createPayment(request, paymentInitiationParameters, tppInfo);
        }
        ResponseObject<PaymentInitiationResponse> responseObject = paymentInitiationParameters.getPaymentType() == PaymentType.SINGLE ? this.createSinglePaymentService.createPayment((SinglePayment)payment, paymentInitiationParameters, tppInfo) : (paymentInitiationParameters.getPaymentType() == PaymentType.PERIODIC ? this.createPeriodicPaymentService.createPayment((PeriodicPayment)payment, paymentInitiationParameters, tppInfo) : this.createBulkPaymentService.createPayment((BulkPayment)payment, paymentInitiationParameters, tppInfo));
        if (responseObject.hasError()) {
            return ResponseObject.builder().fail(responseObject.getError()).build();
        }
        return ResponseObject.builder().body(responseObject.getBody()).build();
    }

    public ResponseObject getPaymentById(PaymentType paymentType, String paymentProduct, String encryptedPaymentId) {
        PaymentInformationResponse response;
        this.xs2aEventService.recordPisTppRequest(encryptedPaymentId, EventType.GET_PAYMENT_REQUEST_RECEIVED);
        Optional<PisCommonPaymentResponse> pisCommonPaymentOptional = this.pisCommonPaymentService.getPisCommonPaymentById(encryptedPaymentId);
        if (!pisCommonPaymentOptional.isPresent()) {
            return ResponseObject.builder().fail(ErrorType.PIS_404, TppMessageInformation.of(MessageErrorCode.RESOURCE_UNKNOWN_404, PAYMENT_NOT_FOUND_MESSAGE)).build();
        }
        PisCommonPaymentResponse commonPaymentResponse = pisCommonPaymentOptional.get();
        ValidationResult validationResult = this.getPaymentByIdValidator.validate(new GetPaymentByIdPO(commonPaymentResponse, paymentType, paymentProduct));
        if (validationResult.isNotValid()) {
            return ResponseObject.builder().fail(validationResult.getMessageError()).build();
        }
        CommonPayment commonPayment = this.cmsToXs2aPaymentMapper.mapToXs2aCommonPayment(commonPaymentResponse);
        if (commonPayment.getPaymentData() != null) {
            response = this.readCommonPaymentService.getPayment(commonPayment, this.readPsuIdDataFromList(commonPayment.getPsuDataList()), encryptedPaymentId);
        } else {
            List<PisPayment> pisPayments = this.getPisPaymentFromCommonPaymentResponse(commonPaymentResponse);
            if (CollectionUtils.isEmpty(pisPayments)) {
                return ResponseObject.builder().fail(ErrorType.PIS_400, TppMessageInformation.of(MessageErrorCode.FORMAT_ERROR, PAYMENT_NOT_FOUND_MESSAGE)).build();
            }
            ReadPaymentService readPaymentService = (ReadPaymentService)this.readPaymentFactory.getService(paymentType.getValue());
            response = (PaymentInformationResponse)readPaymentService.getPayment(pisPayments, commonPaymentResponse.getPaymentProduct(), this.readPsuIdDataFromList(commonPayment.getPsuDataList()), encryptedPaymentId);
        }
        if (response.hasError()) {
            return ResponseObject.builder().fail(response.getErrorHolder()).build();
        }
        return ResponseObject.builder().body(response.getPayment()).build();
    }

    public ResponseObject<TransactionStatus> getPaymentStatusById(PaymentType paymentType, String paymentProduct, String encryptedPaymentId) {
        ReadPaymentStatusResponse readPaymentStatusResponse;
        this.xs2aEventService.recordPisTppRequest(encryptedPaymentId, EventType.GET_TRANSACTION_STATUS_REQUEST_RECEIVED);
        Optional<PisCommonPaymentResponse> pisCommonPaymentOptional = this.pisCommonPaymentService.getPisCommonPaymentById(encryptedPaymentId);
        if (!pisCommonPaymentOptional.isPresent()) {
            return ResponseObject.builder().fail(ErrorType.PIS_404, TppMessageInformation.of(MessageErrorCode.RESOURCE_UNKNOWN_404, PAYMENT_NOT_FOUND_MESSAGE)).build();
        }
        PisCommonPaymentResponse pisCommonPaymentResponse = pisCommonPaymentOptional.get();
        ValidationResult validationResult = this.getPaymentStatusByIdValidator.validate(new GetPaymentStatusByIdPO(pisCommonPaymentResponse, paymentType, paymentProduct));
        if (validationResult.isNotValid()) {
            return ResponseObject.builder().fail(validationResult.getMessageError()).build();
        }
        if (pisCommonPaymentResponse.getTransactionStatus() == TransactionStatus.RJCT) {
            return ResponseObject.builder().body(TransactionStatus.RJCT).build();
        }
        List<PsuIdData> psuData = this.pisPsuDataService.getPsuDataByPaymentId(encryptedPaymentId);
        SpiContextData spiContextData = this.spiContextDataProvider.provideWithPsuIdData(this.readPsuIdDataFromList(psuData));
        if (pisCommonPaymentResponse.getPaymentData() != null) {
            readPaymentStatusResponse = this.readCommonPaymentStatusService.readPaymentStatus(pisCommonPaymentResponse, spiContextData, encryptedPaymentId);
        } else {
            List<PisPayment> pisPayments = this.getPisPaymentFromCommonPaymentResponse(pisCommonPaymentResponse);
            if (CollectionUtils.isEmpty(pisPayments)) {
                return ResponseObject.builder().fail(ErrorType.PIS_400, TppMessageInformation.of(MessageErrorCode.FORMAT_ERROR, PAYMENT_NOT_FOUND_MESSAGE)).build();
            }
            ReadPaymentStatusService readPaymentStatusService = (ReadPaymentStatusService)this.readPaymentStatusFactory.getService("status-" + paymentType.getValue());
            readPaymentStatusResponse = readPaymentStatusService.readPaymentStatus(pisPayments, pisCommonPaymentResponse.getPaymentProduct(), spiContextData, encryptedPaymentId);
        }
        if (readPaymentStatusResponse.hasError()) {
            ErrorHolder errorHolder = readPaymentStatusResponse.getErrorHolder();
            return ResponseObject.builder().fail(errorHolder).build();
        }
        TransactionStatus transactionStatus = readPaymentStatusResponse.getStatus();
        if (transactionStatus == null) {
            return ResponseObject.builder().fail(ErrorType.PIS_403, TppMessageInformation.of(MessageErrorCode.RESOURCE_UNKNOWN_403)).build();
        }
        if (!this.updatePaymentStatusAfterSpiService.updatePaymentStatus(encryptedPaymentId, transactionStatus)) {
            log.info("X-Request-ID: [{}], Payment ID: [{}], Transaction status: [{}]. Update of a payment status in the CMS has failed.", new Object[]{this.requestProviderService.getRequestId(), encryptedPaymentId, transactionStatus});
        }
        return ResponseObject.builder().body(transactionStatus).build();
    }

    public ResponseObject<CancelPaymentResponse> cancelPayment(PaymentType paymentType, String paymentProduct, String encryptedPaymentId) {
        this.xs2aEventService.recordPisTppRequest(encryptedPaymentId, EventType.PAYMENT_CANCELLATION_REQUEST_RECEIVED);
        Optional<PisCommonPaymentResponse> pisCommonPaymentOptional = this.pisCommonPaymentService.getPisCommonPaymentById(encryptedPaymentId);
        if (!pisCommonPaymentOptional.isPresent()) {
            return ResponseObject.builder().fail(ErrorType.PIS_404, TppMessageInformation.of(MessageErrorCode.RESOURCE_UNKNOWN_404, PAYMENT_NOT_FOUND_MESSAGE)).build();
        }
        PisCommonPaymentResponse pisCommonPaymentResponse = pisCommonPaymentOptional.get();
        ValidationResult validationResult = this.cancelPaymentValidator.validate(new CancelPaymentPO(pisCommonPaymentResponse, paymentType, paymentProduct));
        if (validationResult.isNotValid()) {
            return ResponseObject.builder().fail(validationResult.getMessageError()).build();
        }
        if (this.isFinalisedPayment(pisCommonPaymentResponse)) {
            return ResponseObject.builder().fail(ErrorType.PIS_400, TppMessageInformation.of(MessageErrorCode.RESOURCE_BLOCKED)).build();
        }
        SpiPaymentInfo spiPayment = null;
        if (this.standardPaymentProductsResolver.isRawPaymentProduct(paymentProduct)) {
            CommonPayment commonPayment = this.cmsToXs2aPaymentMapper.mapToXs2aCommonPayment(pisCommonPaymentResponse);
            spiPayment = this.xs2aToSpiPaymentInfoMapper.mapToSpiPaymentInfo(commonPayment);
        } else {
            List<PisPayment> pisPayments = this.getPisPaymentFromCommonPaymentResponse(pisCommonPaymentResponse);
            if (CollectionUtils.isEmpty(pisPayments)) {
                return ResponseObject.builder().fail(ErrorType.PIS_404, TppMessageInformation.of(MessageErrorCode.RESOURCE_UNKNOWN_404, PAYMENT_NOT_FOUND_MESSAGE)).build();
            }
            Optional<? extends SpiPayment> spiPaymentOptional = this.spiPaymentFactory.createSpiPaymentByPaymentType(pisPayments, pisCommonPaymentResponse.getPaymentProduct(), paymentType);
            if (!spiPaymentOptional.isPresent()) {
                log.info("X-Request-ID: [{}], Payment ID: [{}]. Cancelling payment has failed: couldn't create SPI payment from CMS payments", (Object)this.requestProviderService.getRequestId(), (Object)encryptedPaymentId);
                return ResponseObject.builder().fail(ErrorType.PIS_404, TppMessageInformation.of(MessageErrorCode.RESOURCE_UNKNOWN_404, PAYMENT_NOT_FOUND_MESSAGE)).build();
            }
            spiPayment = spiPaymentOptional.get();
        }
        List psuData = pisCommonPaymentResponse.getPsuData();
        return this.cancelPaymentService.initiatePaymentCancellation(this.readPsuIdDataFromList(psuData), (SpiPayment)spiPayment, encryptedPaymentId);
    }

    private boolean isFinalisedPayment(PisCommonPaymentResponse response) {
        return response.getTransactionStatus().isFinalisedStatus();
    }

    private List<PisPayment> getPisPaymentFromCommonPaymentResponse(PisCommonPaymentResponse pisCommonPaymentResponse) {
        List pisPayments = Optional.of(pisCommonPaymentResponse).map(PisCommonPaymentResponse::getPayments).orElseGet(Collections::emptyList);
        pisPayments.forEach(pmt -> {
            pmt.setPaymentId(pisCommonPaymentResponse.getExternalId());
            pmt.setTransactionStatus(pisCommonPaymentResponse.getTransactionStatus());
            pmt.setPsuDataList(pisCommonPaymentResponse.getPsuData());
            pmt.setStatusChangeTimestamp(pisCommonPaymentResponse.getStatusChangeTimestamp());
        });
        return pisPayments;
    }

    private PsuIdData readPsuIdDataFromList(List<PsuIdData> psuIdDataList) {
        if (CollectionUtils.isNotEmpty(psuIdDataList)) {
            return psuIdDataList.get(0);
        }
        return null;
    }

    @ConstructorProperties(value={"readPaymentFactory", "readPaymentStatusFactory", "spiPaymentFactory", "pisCommonPaymentService", "updatePaymentStatusAfterSpiService", "pisPsuDataService", "tppService", "createSinglePaymentService", "createPeriodicPaymentService", "createBulkPaymentService", "cancelPaymentService", "xs2aEventService", "createCommonPaymentService", "readCommonPaymentService", "xs2aToSpiPaymentInfoMapper", "cmsToXs2aPaymentMapper", "spiContextDataProvider", "readCommonPaymentStatusService", "requestProviderService", "standardPaymentProductsResolver", "createPaymentValidator", "getPaymentByIdValidator", "getPaymentStatusByIdValidator", "cancelPaymentValidator"})
    public PaymentService(ReadPaymentFactory readPaymentFactory, ReadPaymentStatusFactory readPaymentStatusFactory, SpiPaymentFactory spiPaymentFactory, Xs2aPisCommonPaymentService pisCommonPaymentService, Xs2aUpdatePaymentStatusAfterSpiService updatePaymentStatusAfterSpiService, PisPsuDataService pisPsuDataService, TppService tppService, CreateSinglePaymentService createSinglePaymentService, CreatePeriodicPaymentService createPeriodicPaymentService, CreateBulkPaymentService createBulkPaymentService, CancelPaymentService cancelPaymentService, Xs2aEventService xs2aEventService, CreateCommonPaymentService createCommonPaymentService, ReadCommonPaymentService readCommonPaymentService, Xs2aToSpiPaymentInfoMapper xs2aToSpiPaymentInfoMapper, CmsToXs2aPaymentMapper cmsToXs2aPaymentMapper, SpiContextDataProvider spiContextDataProvider, ReadCommonPaymentStatusService readCommonPaymentStatusService, RequestProviderService requestProviderService, StandardPaymentProductsResolver standardPaymentProductsResolver, CreatePaymentValidator createPaymentValidator, GetPaymentByIdValidator getPaymentByIdValidator, GetPaymentStatusByIdValidator getPaymentStatusByIdValidator, CancelPaymentValidator cancelPaymentValidator) {
        this.readPaymentFactory = readPaymentFactory;
        this.readPaymentStatusFactory = readPaymentStatusFactory;
        this.spiPaymentFactory = spiPaymentFactory;
        this.pisCommonPaymentService = pisCommonPaymentService;
        this.updatePaymentStatusAfterSpiService = updatePaymentStatusAfterSpiService;
        this.pisPsuDataService = pisPsuDataService;
        this.tppService = tppService;
        this.createSinglePaymentService = createSinglePaymentService;
        this.createPeriodicPaymentService = createPeriodicPaymentService;
        this.createBulkPaymentService = createBulkPaymentService;
        this.cancelPaymentService = cancelPaymentService;
        this.xs2aEventService = xs2aEventService;
        this.createCommonPaymentService = createCommonPaymentService;
        this.readCommonPaymentService = readCommonPaymentService;
        this.xs2aToSpiPaymentInfoMapper = xs2aToSpiPaymentInfoMapper;
        this.cmsToXs2aPaymentMapper = cmsToXs2aPaymentMapper;
        this.spiContextDataProvider = spiContextDataProvider;
        this.readCommonPaymentStatusService = readCommonPaymentStatusService;
        this.requestProviderService = requestProviderService;
        this.standardPaymentProductsResolver = standardPaymentProductsResolver;
        this.createPaymentValidator = createPaymentValidator;
        this.getPaymentByIdValidator = getPaymentByIdValidator;
        this.getPaymentStatusByIdValidator = getPaymentStatusByIdValidator;
        this.cancelPaymentValidator = cancelPaymentValidator;
    }
}

